/*
 * Decompiled with CFR 0.152.
 */
package com.xmooncorp.magic8ball;

import com.xmooncorp.magic8ball.core.ConfigBasedLocalization;
import com.xmooncorp.magic8ball.implementation.Items;
import com.xmooncorp.magic8ball.implementation.resources.Magic8BallFragmentResource;
import com.xmooncorp.magic8ball.implementation.setup.ItemSetup;
import com.xmooncorp.magic8ball.implementation.setup.ResearchSetup;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.libraries.dough.config.Config;
import io.github.thebusybiscuit.slimefun4.libraries.dough.updater.BlobBuildUpdater;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Magic8Ball
extends JavaPlugin
implements SlimefunAddon {
    private static Magic8Ball instance;
    private ConfigBasedLocalization localization;
    private Config config;

    public void onEnable() {
        instance = this;
        this.config = new Config((Plugin)this);
        this.tryAutoUpdate();
        this.loadLanguage();
        Magic8Ball.log(this.localization().getString("console.registering-geo"));
        this.registerGeoResources();
        Magic8Ball.log(this.localization().getString("console.loading-items"));
        this.loadItems();
        Magic8Ball.log(this.localization().getString("console.loading-researches"));
        this.loadResearches();
        Magic8Ball.log(this.localization().getString("console.addon-enabled"));
    }

    public void onDisable() {
        Magic8Ball.log(this.localization().getString("console.addon-disabled"));
        instance = null;
    }

    public String getBugTrackerURL() {
        return "https://github.com/xMoonGames/Magic-8-Ball/issues";
    }

    @Nonnull
    public JavaPlugin getJavaPlugin() {
        return this;
    }

    @Nonnull
    public static Magic8Ball instance() {
        return instance;
    }

    private void tryAutoUpdate() {
        if (this.getConfig().getBoolean("options.auto-update") && this.getDescription().getVersion().startsWith("Dev")) {
            new BlobBuildUpdater((Plugin)this, this.getFile(), "Magic8Ball", "Dev").start();
        }
    }

    public static void log(@Nonnull String message) {
        Magic8Ball.instance().getLogger().info(message);
    }

    private void loadItems() {
        try {
            ItemSetup.setup(this);
        }
        catch (Exception | LinkageError x) {
            this.getLogger().log(Level.SEVERE, x, () -> "Error loading Magic8Ball Items");
        }
    }

    private void loadResearches() {
        try {
            ResearchSetup.setupResearches();
        }
        catch (Exception | LinkageError x) {
            this.getLogger().log(Level.SEVERE, x, () -> "Error loading Magic8Ball researches");
        }
    }

    private void registerGeoResources() {
        new Magic8BallFragmentResource((Plugin)this, (ItemStack)Items.MAGIC_8_BALL_FRAGMENT, "magic8ball_fragment_geo_resource").register();
    }

    private void loadLanguage() {
        Magic8Ball.instance().localization = new ConfigBasedLocalization("en-US", this.config());
        Magic8Ball.log(this.localization().getString("console.loading-language"));
        Magic8Ball.log(this.localization().getString("console.loaded-language") + " " + this.localization.getName());
    }

    public ConfigBasedLocalization localization() {
        return Magic8Ball.instance().localization;
    }

    public Config config() {
        return Magic8Ball.instance().config;
    }
}

