/*
 * Decompiled with CFR 0.152.
 */
package com.xmooncorp.magic8ball.utils;

import javax.annotation.Nonnull;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public class LocationUtils {
    public static Location getFrontSide(@Nonnull Location location, double distance) {
        return location.clone().add(new Vector(-Math.sin(Math.toRadians(location.getYaw())), 0.0, Math.cos(Math.toRadians(location.getYaw()))).normalize().multiply(distance));
    }

    public static Location getBackSide(@Nonnull Location location, double distance) {
        return location.clone().subtract(new Vector(-Math.sin(Math.toRadians(location.getYaw())), 0.0, Math.cos(Math.toRadians(location.getYaw()))).normalize().multiply(distance));
    }

    public static Location getRightSide(@Nonnull Location location, double distance) {
        float angle = location.getYaw() / 60.0f;
        return location.clone().subtract(new Vector(Math.cos(angle), 0.0, Math.sin(angle)).normalize().multiply(distance));
    }

    public static Location getLeftSide(@Nonnull Location location, double distance) {
        float angle = location.getYaw() / 60.0f;
        return location.clone().add(new Vector(Math.cos(angle), 0.0, Math.sin(angle)).normalize().multiply(distance));
    }
}

