/*
 * Decompiled with CFR 0.152.
 */
package com.xmooncorp.magic8ball.core;

import io.github.thebusybiscuit.slimefun4.libraries.dough.config.Config;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class ConfigBasedLocalization {
    private final Config config;
    private final String name;
    private final String root;

    public ConfigBasedLocalization(@Nonnull String defaultLocalization, @Nonnull Config config) {
        this.config = config;
        String lang = config.getString("options.lang");
        this.name = Objects.requireNonNullElse(lang, defaultLocalization);
        this.root = String.format("languages.%s.", this.name);
    }

    @Nonnull
    public String getString(@Nonnull String path) {
        return (String)((Object)Objects.requireNonNullElse(this.config.getString(this.root + path), "Locale Error: NotFound. Path: \"" + path + "\""));
    }

    @Nonnull
    public List<String> getStringList(@Nonnull String path) {
        return Objects.requireNonNullElse(this.config.getStringList(this.root + path), Arrays.stream(new String[]{"Locale Error: NotFound. Path: \"" + path + "\""}).toList());
    }

    @Nonnull
    public String getName() {
        return this.name;
    }
}

