/*
 * Decompiled with CFR 0.152.
 */
package com.xmooncorp.magic8ball.implementation.items;

import com.xmooncorp.magic8ball.Magic8Ball;
import com.xmooncorp.magic8ball.core.ConfigBasedLocalization;
import com.xmooncorp.magic8ball.utils.LocationUtils;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockUseHandler;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class Magic8BallItem
extends SlimefunItem
implements Listener {
    private final Random random = new Random(System.currentTimeMillis());
    ConfigBasedLocalization localization = Magic8Ball.instance().localization();
    private final String[] affirmative = this.localization.getStringList("responses.affirmative").toArray(new String[0]);
    private final String[] noncommittal = this.localization.getStringList("responses.noncommittal").toArray(new String[0]);
    private final String[] negative = this.localization.getStringList("responses.negative").toArray(new String[0]);

    public Magic8BallItem(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
        this.addItemHandler(new ItemHandler[]{this.onPlayerInteractBlock()});
    }

    public void preRegister() {
        Magic8Ball plugin = Magic8Ball.instance();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)Magic8Ball.instance());
    }

    public void sendRandom8BallMessage(@Nonnull Player player, @Nullable Block block) {
        String[] randomMessage = this.getRandomMessage();
        String color = "\u00a7r";
        Sound sound = Sound.INTENTIONALLY_EMPTY;
        Particle particle = Particle.PORTAL;
        switch (randomMessage[0]) {
            case "affirmative": {
                color = "\u00a7a";
                sound = Sound.ENTITY_VILLAGER_YES;
                particle = Particle.TOTEM;
                break;
            }
            case "noncommittal": {
                color = "\u00a77";
                sound = Sound.ENTITY_VILLAGER_TRADE;
                particle = Particle.CRIT;
                break;
            }
            case "negative": {
                color = "\u00a7c";
                sound = Sound.ENTITY_VILLAGER_NO;
                particle = Particle.CRIT_MAGIC;
            }
        }
        this.sendActionBarMessage(player, color + randomMessage[1]);
        this.playSoundAtLocation(player.getWorld(), player.getLocation(), sound);
        Location handLocation = LocationUtils.getFrontSide(LocationUtils.getRightSide(player.getEyeLocation(), 0.325).subtract(0.0, 0.7, 0.0), 0.6);
        if (block != null) {
            this.createParticleAtLocation(block.getWorld(), block.getLocation(), particle);
        } else {
            this.createParticleAtLocation(player.getWorld(), handLocation, particle);
        }
    }

    @Nonnull
    private String[] getRandomMessage() {
        switch (this.random.nextInt(3)) {
            case 0: {
                return new String[]{"affirmative", this.affirmative[this.random.nextInt(this.affirmative.length)]};
            }
            case 1: {
                return new String[]{"noncommittal", this.noncommittal[this.random.nextInt(this.noncommittal.length)]};
            }
            case 2: {
                return new String[]{"negative", this.negative[this.random.nextInt(this.negative.length)]};
            }
        }
        return new String[2];
    }

    private void sendActionBarMessage(@Nonnull Player player, @Nonnull String message) {
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacy((String)message));
    }

    private void createParticleAtLocation(@Nonnull World world, @Nonnull Location location, @Nonnull Particle particle) {
        world.spawnParticle(particle, location, 20);
    }

    private void playSoundAtLocation(@Nonnull World world, @Nonnull Location location, @Nonnull Sound sound) {
        world.playSound(location, sound, 1.0f, 0.65f);
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.LEFT_CLICK_AIR) {
            return;
        }
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Player player = event.getPlayer();
        SlimefunItem itemHeld = SlimefunItem.getByItem((ItemStack)event.getItem());
        if (itemHeld != null && itemHeld.getId().equals(this.getId())) {
            this.sendRandom8BallMessage(player, null);
        }
    }

    private BlockUseHandler onPlayerInteractBlock() {
        return playerRightClickEvent -> {
            Player player = playerRightClickEvent.getPlayer();
            Optional block = playerRightClickEvent.getClickedBlock();
            block.ifPresent(value -> this.sendRandom8BallMessage(player, (Block)value));
        };
    }
}

