/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.msua;

import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.geo.GEOResource;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.Radioactive;
import io.github.thebusybiscuit.slimefun4.core.multiblocks.MultiBlockMachine;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.collections.KeyMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Obsolete
public final class SlimefunUnregisterUtil {
    public static void unregisterItem(SlimefunItem item) {
        if (item instanceof Radioactive) {
            Slimefun.getRegistry().getRadioactiveItems().remove(item);
        }
        if (item instanceof GEOResource) {
            GEOResource geor = (GEOResource)item;
            Slimefun.getRegistry().getGEOResources().remove((Object)geor.getKey());
        }
        if (item instanceof MultiBlockMachine) {
            MultiBlockMachine mbm = (MultiBlockMachine)item;
            Slimefun.getRegistry().getMultiBlocks().remove(mbm.getMultiBlock());
        }
        Slimefun.getRegistry().getTickerBlocks().remove(item.getId());
        Slimefun.getRegistry().getEnabledSlimefunItems().remove(item);
        Slimefun.getRegistry().getSlimefunItemIds().remove(item.getId());
        Slimefun.getRegistry().getAllSlimefunItems().remove(item);
        Slimefun.getRegistry().getMenuPresets().remove(item.getId());
        Slimefun.getRegistry().getBarteringDrops().remove(item.getItem());
        if (item.getRecipeType() == RecipeType.MOB_DROP) {
            ItemStack[] recipe = item.getRecipe();
            if (recipe.length < 5) {
                return;
            }
            ItemStack itemStack = recipe[4];
            if (itemStack == null || itemStack.getType() == Material.AIR) {
                return;
            }
            ItemMeta meta = itemStack.getItemMeta();
            if (meta == null) {
                return;
            }
            String mob = ChatColor.stripColor((String)meta.getDisplayName().toUpperCase(Locale.ROOT).replace(' ', '_'));
            try {
                EntityType entity = EntityType.valueOf((String)mob);
                Set dropping = (Set)Slimefun.getRegistry().getMobDrops().get(entity);
                if (dropping == null) {
                    return;
                }
                ItemStack output = item.getRecipeOutput();
                dropping.remove(output);
                Slimefun.getRegistry().getMobDrops().put(entity, dropping);
            }
            catch (IllegalArgumentException ignored) {
                return;
            }
        }
    }

    public static void unregisterAddon(@NotNull SlimefunAddon addon) {
        SlimefunUnregisterUtil.unregisterAllItems(addon);
        SlimefunUnregisterUtil.unregisterItemGroups(addon);
        SlimefunUnregisterUtil.unregisterAllGEOResources(addon);
    }

    public static void unregisterAllItems(@NotNull SlimefunAddon addon) {
        ArrayList items = new ArrayList(Slimefun.getRegistry().getAllSlimefunItems());
        for (SlimefunItem item : items) {
            if (item.getAddon() != addon) continue;
            SlimefunUnregisterUtil.unregisterItem(item);
        }
    }

    public static void unregisterItemGroups(@NotNull SlimefunAddon addon) {
        HashSet<ItemGroup> itemGroups = new HashSet<ItemGroup>();
        for (ItemGroup itemGroup : Slimefun.getRegistry().getAllItemGroups()) {
            if (!Objects.equals(itemGroup.getAddon(), addon)) continue;
            itemGroups.add(itemGroup);
        }
        for (ItemGroup itemGroup : itemGroups) {
            SlimefunUnregisterUtil.unregisterItemGroup(itemGroup);
        }
    }

    public static void unregisterAllGEOResources(@NotNull SlimefunAddon addon) {
        ArrayList<NamespacedKey> toRemove = new ArrayList<NamespacedKey>();
        KeyMap resources = Slimefun.getRegistry().getGEOResources();
        for (NamespacedKey key : resources.keySet()) {
            if (!key.getNamespace().equalsIgnoreCase(addon.getName())) continue;
            toRemove.add(key);
        }
        for (NamespacedKey key : toRemove) {
            resources.remove((Object)key);
        }
    }

    public static void unregisterItemGroup(@Nullable ItemGroup itemGroup) {
        if (itemGroup == null) {
            return;
        }
        Slimefun.getRegistry().getAllItemGroups().remove(itemGroup);
    }

    @Generated
    private SlimefunUnregisterUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

