/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.msua.command.sub;

import com.balugaq.msua.FileUtil;
import com.balugaq.msua.MSUA;
import com.balugaq.msua.PluginUtil;
import com.balugaq.msua.command.AccessLevel;
import com.balugaq.msua.command.MSUACommand;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Obsolete
public class LoadCommand
implements MSUACommand {
    @Override
    @NotNull
    public AccessLevel accessLevel() {
        return AccessLevel.op;
    }

    @Override
    @NotNull
    public String name() {
        return "load";
    }

    @Override
    public boolean execute(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        boolean loadDependencies = this.getArgument(args, 1, "<arg>").equalsIgnoreCase("--load-dependencies");
        String simpleName = this.getBehindArgument(args, 1 + (loadDependencies ? 1 : 0), "<file_name>");
        File file = new File(FileUtil.pluginFolder, simpleName + ".jar");
        if (!file.exists()) {
            this.wrongUsage(sender, "/msua load [--load-dependencies] <plugin>");
            return true;
        }
        try {
            Plugin plugin = PluginUtil.loadJar(file, false);
            if (plugin != null) {
                if (plugin.isEnabled()) {
                    MSUA.complain(sender, "Plugin " + simpleName + " is already loaded.");
                }
                PluginUtil.adaptedLoadPlugin(plugin, loadDependencies);
                PluginUtil.enablePlugin(plugin, loadDependencies);
                MSUA.blue(sender, "Loaded " + simpleName + ".");
            } else {
                MSUA.complain(sender, "Unable to load plugin " + simpleName + ".");
            }
            return true;
        }
        catch (Throwable e) {
            MSUA.complain(sender, "Unable to load plugin " + simpleName + ".", e);
            return false;
        }
    }

    @Override
    public boolean executable(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        return this.isCommand(args, this.name());
    }

    @Override
    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        ArrayList<String> simpleNames = new ArrayList<String>();
        if (args.length == 2 && "--load-dependencies".toLowerCase().startsWith(args[1].toLowerCase())) {
            simpleNames.add("--load-dependencies");
        }
        if (args.length > 3) {
            return simpleNames;
        }
        File[] files = FileUtil.pluginFolder.listFiles();
        if (files == null) {
            return simpleNames;
        }
        List<String> loadedPaths = Arrays.stream(Bukkit.getPluginManager().getPlugins()).map(plugin -> FileUtil.getJarFile(plugin.getClass())).filter(Objects::nonNull).map(File::getAbsolutePath).toList();
        for (File file : files) {
            if (file.isDirectory() || !file.getName().endsWith(".jar") || loadedPaths.contains(file.getAbsolutePath()) || args.length != 0 && !file.getName().startsWith(args[args.length - 1])) continue;
            simpleNames.add(file.getName().substring(0, file.getName().length() - 4));
        }
        return simpleNames;
    }
}

