/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.msua.command;

import com.balugaq.msua.MSUA;
import com.balugaq.msua.command.CommandMissingArgException;
import com.balugaq.msua.command.MSUACommand;
import com.balugaq.msua.command.sub.DisableCommand;
import com.balugaq.msua.command.sub.EnableCommand;
import com.balugaq.msua.command.sub.LoadCommand;
import com.balugaq.msua.command.sub.UnloadCommand;
import com.balugaq.msua.command.sub.WtfCommand;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Obsolete
public class MSUACommands
implements TabExecutor {
    public static final List<MSUACommand> commands = new ArrayList<MSUACommand>();

    public static boolean accessible(@NotNull MSUACommand cmd, @NotNull CommandSender sender) {
        return sender.isOp() || sender.hasPermission("msua.admin");
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        for (MSUACommand cmd : commands) {
            if (!MSUACommands.accessible(cmd, sender) || !cmd.executable(sender, command, label, args)) continue;
            try {
                cmd.execute(sender, command, label, args);
            }
            catch (CommandMissingArgException e) {
                cmd.missingRequirements(sender, e.getMissingRequirements());
            }
            catch (Throwable e) {
                MSUA.complain(sender, e);
            }
            return true;
        }
        return false;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length <= 1) {
            return commands.stream().filter(cmd -> MSUACommands.accessible(cmd, sender)).map(MSUACommand::name).toList();
        }
        for (MSUACommand cmd2 : commands) {
            if (!MSUACommands.accessible(cmd2, sender) || !cmd2.executable(sender, command, label, args)) continue;
            return cmd2.tabComplete(sender, command, label, args);
        }
        return new ArrayList<String>();
    }

    static {
        commands.add(new LoadCommand());
        commands.add(new UnloadCommand());
        commands.add(new WtfCommand());
        commands.add(new EnableCommand());
        commands.add(new DisableCommand());
    }
}

