/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.msua;

import com.balugaq.msua.MSUA;
import com.balugaq.msua.ReflectionUtil;
import com.balugaq.msua.libraries.paperlib.PaperLib;
import com.google.common.base.Preconditions;
import io.papermc.paper.plugin.configuration.PluginMeta;
import io.papermc.paper.plugin.provider.entrypoint.DependencyContext;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.plugin.InvalidDescriptionException;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.SimplePluginManager;
import org.bukkit.plugin.UnknownDependencyException;
import org.bukkit.plugin.java.JavaPluginLoader;
import org.bukkit.plugin.java.LibraryLoader;
import org.bukkit.plugin.java.PluginClassLoader;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.error.YAMLException;

@ApiStatus.Experimental
public class PluginUtil {
    public static final Server server = Bukkit.getServer();
    @Deprecated
    public static final List<PluginClassLoader> loaders = new CopyOnWriteArrayList<PluginClassLoader>();
    @Deprecated
    public static final LibraryLoader libraryLoader = new LibraryLoader(server.getLogger());

    @ApiStatus.Obsolete
    public static void adaptedLoadPlugin(Plugin plugin, boolean loadDependencies) {
        if (loadDependencies) {
            List<Plugin> dependencies = PluginUtil.getDependencies(plugin);
            for (Plugin p : dependencies) {
                PluginUtil.adaptedLoadPlugin(p, true);
            }
        }
        PluginUtil.handlePaperLoadPlugin(plugin);
    }

    @ApiStatus.Obsolete
    public static void adaptedUnloadPlugin(Plugin plugin, boolean unloadChildren) {
        if (unloadChildren) {
            List<Plugin> children = PluginUtil.getChildren(plugin);
            for (Plugin p : children) {
                PluginUtil.adaptedUnloadPlugin(p, true);
            }
        }
        PluginUtil.handlePaperUnloadPlugin(plugin);
    }

    @ApiStatus.Experimental
    @NotNull
    public static synchronized Plugin loadJar(@NotNull File file) {
        return PluginUtil.loadJar(file, true);
    }

    @ApiStatus.Experimental
    @NotNull
    public static synchronized Plugin loadJar(@NotNull File file, boolean loadPlugin) {
        Preconditions.checkArgument((file != null ? 1 : 0) != 0, (Object)"File cannot be null");
        Plugin result = PluginUtil.loadPlugin0(file, true);
        if (result != null && loadPlugin) {
            PluginUtil.adaptedLoadPlugin(result, true);
        }
        return result;
    }

    @ApiStatus.Experimental
    @ApiStatus.Internal
    @Nullable
    public static Plugin loadPlugin0(@NotNull File file, boolean loadDependencies) {
        PluginClassLoader loader;
        PluginDescriptionFile description;
        Preconditions.checkArgument((file != null ? 1 : 0) != 0, (Object)"File cannot be null");
        if (!file.exists()) {
            throw new InvalidPluginException((Throwable)new FileNotFoundException(file.getPath() + " does not exist"));
        }
        try {
            description = PluginUtil.getPluginDescription(file);
        }
        catch (InvalidDescriptionException ex) {
            throw new InvalidPluginException((Throwable)ex);
        }
        File parentFile = server.getPluginsFolder();
        File dataFolder = new File(parentFile, description.getName());
        File oldDataFolder = new File(parentFile, description.getRawName());
        if (!dataFolder.equals(oldDataFolder)) {
            if (dataFolder.isDirectory() && oldDataFolder.isDirectory()) {
                server.getLogger().warning(String.format("While loading %s (%s) found old-data folder: `%s' next to the new one `%s'", description.getFullName(), file, oldDataFolder, dataFolder));
            } else if (oldDataFolder.isDirectory() && !dataFolder.exists()) {
                if (!oldDataFolder.renameTo(dataFolder)) {
                    throw new InvalidPluginException("Unable to rename old data folder: `" + String.valueOf(oldDataFolder) + "' to: `" + String.valueOf(dataFolder) + "'");
                }
                server.getLogger().log(Level.INFO, String.format("While loading %s (%s) renamed data folder: `%s' to `%s'", description.getFullName(), file, oldDataFolder, dataFolder));
            }
        }
        if (dataFolder.exists() && !dataFolder.isDirectory()) {
            throw new InvalidPluginException(String.format("Projected datafolder: `%s' for %s (%s) exists and is not a directory", dataFolder, description.getFullName(), file));
        }
        block7: for (String pluginName : description.getDepend()) {
            Plugin current = server.getPluginManager().getPlugin(pluginName);
            if (current != null) continue;
            if (loadDependencies) {
                List<File> files = Arrays.stream(server.getPluginsFolder().listFiles()).filter(f -> f.getName().endsWith(".jar")).toList();
                for (File f2 : files) {
                    Plugin plugin = PluginUtil.loadJar(f2, false);
                    if (!plugin.getName().equals(pluginName)) continue;
                    PluginUtil.adaptedLoadPlugin(plugin, true);
                    continue block7;
                }
                continue;
            }
            throw new UnknownDependencyException("Unknown dependency " + pluginName + ". Please download and install " + pluginName + " to run this plugin.");
        }
        server.getUnsafe().checkSupported(description);
        JarFile jar = new JarFile(file);
        try {
            loader = new PluginClassLoader(JavaPluginLoader.class.getClassLoader(), description, dataFolder, file, libraryLoader != null ? libraryLoader.createLoader(description) : null, jar, new DependencyContext(){

                public boolean isTransitiveDependency(@NotNull PluginMeta pluginMeta, @NotNull PluginMeta pluginMeta1) {
                    return Bukkit.getPluginManager().isTransitiveDependency(pluginMeta, pluginMeta1);
                }

                public boolean hasDependency(@NotNull String s) {
                    PluginManager pluginManager;
                    if (PaperLib.isPaper() && (pluginManager = Bukkit.getPluginManager()) instanceof SimplePluginManager) {
                        SimplePluginManager spm = (SimplePluginManager)pluginManager;
                        PluginManager impl = spm.paperPluginManager;
                        return (Boolean)ReflectionUtil.invokeMethod(impl, "hasDependency", s);
                    }
                    return Bukkit.getPluginManager().getPlugin(s) != null;
                }
            });
        }
        catch (InvalidPluginException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new InvalidPluginException(ex);
        }
        loaders.add(loader);
        return loader.getPlugin();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ApiStatus.Experimental
    @NotNull
    public static PluginDescriptionFile getPluginDescription(@NotNull File file) throws InvalidDescriptionException {
        Preconditions.checkArgument((file != null ? 1 : 0) != 0, (Object)"File cannot be null");
        JarFile jar = null;
        InputStream stream = null;
        try {
            jar = new JarFile(file);
            JarEntry entry = jar.getJarEntry("plugin.yml");
            if (entry == null) {
                throw new InvalidDescriptionException((Throwable)new FileNotFoundException("Jar does not contain plugin.yml"));
            }
            stream = jar.getInputStream(entry);
            PluginDescriptionFile pluginDescriptionFile = new PluginDescriptionFile(stream);
            return pluginDescriptionFile;
        }
        catch (IOException | YAMLException ex) {
            throw new InvalidDescriptionException(ex);
        }
        finally {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (IOException iOException) {}
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @ApiStatus.Experimental
    public static void handlePaperLoadPlugin(Plugin plugin) {
        PluginManager pluginManager;
        PluginUtil.handleSpigotLoadPlugin(plugin);
        if (PaperLib.isPaper() && (pluginManager = Bukkit.getPluginManager()) instanceof SimplePluginManager) {
            SimplePluginManager spm = (SimplePluginManager)pluginManager;
            PluginManager impl = spm.paperPluginManager;
            Method loadPlugin = ReflectionUtil.getMethod(impl.getClass(), "loadPlugin", Plugin.class);
            loadPlugin.invoke((Object)impl, plugin);
        }
    }

    @ApiStatus.Obsolete
    public static void handleSpigotLoadPlugin(Plugin plugin) {
        List plugins = (List)ReflectionUtil.getValue(Bukkit.getPluginManager(), "plugins");
        plugins.add(plugin);
        Map lookupNames = (Map)ReflectionUtil.getValue(Bukkit.getPluginManager(), "lookupNames");
        lookupNames.put(plugin.getDescription().getName().toLowerCase(Locale.ENGLISH), plugin);
        for (String provided : plugin.getDescription().getProvides()) {
            lookupNames.putIfAbsent(provided.toLowerCase(Locale.ENGLISH), plugin);
        }
    }

    @ApiStatus.Experimental
    public static void handlePaperUnloadPlugin(Plugin plugin) {
        PluginManager pluginManager;
        PluginUtil.handleSpigotUnloadPlugin(plugin);
        if (PaperLib.isPaper() && (pluginManager = Bukkit.getPluginManager()) instanceof SimplePluginManager) {
            SimplePluginManager spm = (SimplePluginManager)pluginManager;
            PluginManager impl = spm.paperPluginManager;
            Object instanceManager = ReflectionUtil.getValue(impl, "instanceManager");
            PluginMeta configuration = plugin.getPluginMeta();
            List plugins = (List)ReflectionUtil.getValue(instanceManager, "plugins");
            plugins.remove(plugin);
            Map lookupNames = (Map)ReflectionUtil.getValue(instanceManager, "lookupNames");
            lookupNames.remove(configuration.getName().toLowerCase(Locale.ENGLISH), plugin);
            for (String providedPlugin : configuration.getProvidedPlugins()) {
                lookupNames.remove(providedPlugin.toLowerCase(Locale.ENGLISH), plugin);
            }
            Object dependencyTree = ReflectionUtil.getValue(instanceManager, "dependencyTree");
            Method remove = ReflectionUtil.getMethod(dependencyTree.getClass(), "remove", PluginMeta.class);
            remove.invoke(dependencyTree, configuration);
        }
        PluginUtil.unloadJar(plugin);
    }

    @ApiStatus.Obsolete
    public static void handleSpigotUnloadPlugin(Plugin plugin) {
        List plugins = (List)ReflectionUtil.getValue(Bukkit.getPluginManager(), "plugins");
        plugins.remove(plugin);
        Map lookupNames = (Map)ReflectionUtil.getValue(Bukkit.getPluginManager(), "lookupNames");
        lookupNames.remove(plugin.getDescription().getName().toLowerCase(Locale.ENGLISH));
        for (String provided : plugin.getDescription().getProvides()) {
            lookupNames.remove(provided.toLowerCase(Locale.ENGLISH));
        }
    }

    @ApiStatus.Obsolete
    public static void enablePlugin(Plugin plugin, boolean enableDependencies) {
        if (enableDependencies) {
            List<Plugin> dependencies = PluginUtil.getDependencies(plugin);
            for (Plugin p : dependencies) {
                PluginUtil.enablePlugin(p, true);
            }
        }
        Bukkit.getPluginManager().enablePlugin(plugin);
    }

    @ApiStatus.Obsolete
    public static void disablePlugin(Plugin plugin, boolean disableChildren) {
        if (disableChildren) {
            List<Plugin> children = PluginUtil.getChildren(plugin);
            for (Plugin p : children) {
                PluginUtil.disablePlugin(p, true);
            }
        }
        Bukkit.getPluginManager().disablePlugin(plugin);
    }

    @ApiStatus.Experimental
    public static void unloadJar(Plugin plugin) {
        ClassLoader classLoader = plugin.getClass().getClassLoader();
        if (classLoader instanceof Closeable) {
            Closeable c = (Closeable)((Object)classLoader);
            PluginUtil.unloadJar(c);
        } else {
            MSUA.console(new RuntimeException("Plugin(" + plugin.getName() + ") class loader is not closeable"));
        }
    }

    @ApiStatus.Experimental
    public static void unloadJar(Closeable classLoader) {
        classLoader.close();
    }

    public static List<Plugin> getChildren(Plugin plugin) {
        ArrayList<Plugin> children = new ArrayList<Plugin>();
        for (Plugin p : Bukkit.getPluginManager().getPlugins()) {
            if (p == plugin || !PluginUtil.getDependencies(p).contains(plugin)) continue;
            children.add(p);
        }
        return children;
    }

    public static List<Plugin> getDependencies(Plugin plugin) {
        if (!PaperLib.isPaper()) {
            return plugin.getDescription().getDepend().stream().map(arg_0 -> ((PluginManager)Bukkit.getPluginManager()).getPlugin(arg_0)).toList();
        }
        return plugin.getPluginMeta().getPluginDependencies().stream().map(arg_0 -> ((PluginManager)Bukkit.getPluginManager()).getPlugin(arg_0)).toList();
    }
}

