/*
 * Decompiled with CFR 0.152.
 */
package dev.j3fftw.litexpansion;

import dev.j3fftw.litexpansion.Constants;
import dev.j3fftw.litexpansion.Events;
import dev.j3fftw.litexpansion.Items;
import dev.j3fftw.litexpansion.NanoBladeActiveEnchant;
import dev.j3fftw.litexpansion.armor.ElectricChestplate;
import dev.j3fftw.litexpansion.items.FoodSynthesizer;
import dev.j3fftw.litexpansion.items.MagThor;
import dev.j3fftw.litexpansion.items.Thorium;
import dev.j3fftw.litexpansion.machine.MassFabricator;
import dev.j3fftw.litexpansion.machine.ScrapMachine;
import dev.j3fftw.litexpansion.resources.MagThorResource;
import dev.j3fftw.litexpansion.resources.ThoriumResource;
import dev.j3fftw.litexpansion.weapons.NanoBlade;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Arrays;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Research;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.bstats.bukkit.Metrics;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class LiteXpansion
extends JavaPlugin
implements SlimefunAddon {
    private static LiteXpansion instance;

    public static LiteXpansion getInstance() {
        return instance;
    }

    public void onEnable() {
        instance = this;
        if (!new File(this.getDataFolder(), "config.yml").exists()) {
            this.saveDefaultConfig();
        }
        new Metrics((Plugin)this, 7111);
        this.getServer().getPluginManager().registerEvents((Listener)new Events(), (Plugin)this);
        Items.LITEXPANSION.register();
        new FoodSynthesizer().register(this);
        new MagThor().register(this);
        new Thorium().register(this);
        this.registerItem(Items.SCRAP, ScrapMachine.RECIPE_TYPE, new ItemStack[]{new CustomItem(Material.COBBLESTONE, "&7Any Item!", new String[0])});
        this.registerItem(Items.UU_MATTER, MassFabricator.RECIPE_TYPE, new ItemStack[]{Items.SCRAP});
        new NanoBlade().register(this);
        new ElectricChestplate().register(this);
        new ScrapMachine().register(this);
        new MassFabricator().register(this);
        this.registerUuMatterRecipes();
        try {
            if (!Enchantment.isAcceptingRegistrations()) {
                Field accepting = Enchantment.class.getDeclaredField("acceptingNew");
                accepting.setAccessible(true);
                accepting.set(null, true);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException ignored) {
            this.getLogger().warning("Failed to register enchantment. Seems the 'acceptingNew' field changed monkaS");
        }
        Enchantment.registerEnchantment((Enchantment)new NanoBladeActiveEnchant(Constants.NANO_BLADE_ACTIVE_ENCHANT));
        this.setupResearches();
        new ThoriumResource(this.getConfig().getBoolean("options.thorium-via-geo-miner")).register();
        new MagThorResource(this.getConfig().getBoolean("options.mag-thor-via-geo-miner")).register();
    }

    private void registerItem(@Nonnull SlimefunItemStack item, @Nonnull RecipeType type, ItemStack ... items) {
        Object[] recipe;
        if (items.length == 1) {
            recipe = new ItemStack[]{null, null, null, null, items[0], null, null, null, null};
        } else if (items.length < 9) {
            recipe = new ItemStack[9];
            System.arraycopy(items, 0, recipe, 0, items.length);
            Arrays.fill(recipe, null);
        } else {
            recipe = items;
        }
        new SlimefunItem(Items.LITEXPANSION, item, type, (ItemStack[])recipe).register((SlimefunAddon)this);
    }

    private void registerUuRecipe(@Nonnull ItemStack result, @Nonnull ItemStack[] recipe) {
        RecipeType.ENHANCED_CRAFTING_TABLE.register(recipe, result);
    }

    private void registerUuMatterRecipes() {
        this.registerUuRecipe((ItemStack)Items.IRIDIUM, new ItemStack[]{Items.UU_MATTER, Items.UU_MATTER, Items.UU_MATTER, null, Items.UU_MATTER, null, Items.UU_MATTER, Items.UU_MATTER, Items.UU_MATTER});
    }

    private void setupResearches() {
        Slimefun.registerResearch((Research)new Research(new NamespacedKey((Plugin)this, "sanitizing_foots"), 696969, "Sanitizing  foots since 2k10", 45), (ItemStack[])new ItemStack[]{Items.FOOD_SYNTHESIZER});
        Slimefun.registerResearch((Research)new Research(new NamespacedKey((Plugin)this, "superalloys"), 696970, "Superalloys", 35), (ItemStack[])new ItemStack[]{Items.THORIUM, Items.MAG_THOR});
        Slimefun.registerResearch((Research)new Research(new NamespacedKey((Plugin)this, "super_hot_fire"), 696971, "Super Hot Fire", 31), (ItemStack[])new ItemStack[]{Items.NANO_BLADE});
    }

    public void onDisable() {
        instance = null;
    }

    public JavaPlugin getJavaPlugin() {
        return this;
    }

    public String getBugTrackerURL() {
        return "https://github.com/J3fftw1/LiteXpansion/issues";
    }
}

