/*
 * Decompiled with CFR 0.152.
 */
package dev.j3fftw.litexpansion.machine;

import dev.j3fftw.litexpansion.Items;
import dev.j3fftw.litexpansion.LiteXpansion;
import dev.j3fftw.litexpansion.utils.Utils;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.interfaces.InventoryBlock;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.Objects.handlers.ItemHandler;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.cscorelib2.blocks.BlockPosition;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class RubberSynthesizer
extends SlimefunItem
implements InventoryBlock,
EnergyNetComponent {
    public static final RecipeType RECIPE_TYPE = new RecipeType(new NamespacedKey((Plugin)LiteXpansion.getInstance(), "rubber_synthesizer_machine"), (ItemStack)Items.RUBBER_SYNTHESIZER_MACHINE);
    private static final int INPUT_SLOT = 11;
    private static final int OUTPUT_SLOT = 15;
    private static final int PROGRESS_SLOT = 13;
    private static final int PROGRESS_AMOUNT = 26;
    public static final int ENERGY_CONSUMPTION = 769;
    public static final int CAPACITY = 3845;
    private static final Map<BlockPosition, Integer> progress = new HashMap<BlockPosition, Integer>();
    private static final CustomItem progressItem = new CustomItem(Material.FIRE_CHARGE, "&7Idle", new String[0]);

    public RubberSynthesizer() {
        super(Items.LITEXPANSION, Items.RUBBER_SYNTHESIZER_MACHINE, RecipeType.ENHANCED_CRAFTING_TABLE, new ItemStack[]{SlimefunItems.REINFORCED_PLATE, SlimefunItems.MEDIUM_CAPACITOR, SlimefunItems.REINFORCED_PLATE, new ItemStack(Material.PISTON), Items.MACHINE_BLOCK, new ItemStack(Material.PISTON), SlimefunItems.REINFORCED_PLATE, new ItemStack(Material.FLINT_AND_STEEL), SlimefunItems.REINFORCED_PLATE});
        this.setupInv();
    }

    private void setupInv() {
        this.createPreset(this, "&6Rubber Synthesizer", blockMenuPreset -> {
            for (int i2 = 0; i2 < 27; ++i2) {
                blockMenuPreset.addItem(i2, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
            }
            blockMenuPreset.addItem(11, null, (player, i, itemStack, clickAction) -> true);
            Utils.putOutputSlot(blockMenuPreset, 15);
            blockMenuPreset.addItem(13, (ItemStack)progressItem);
        });
    }

    public void preRegister() {
        this.addItemHandler(new ItemHandler[]{new BlockTicker(){

            public void tick(Block b, SlimefunItem sf, Config data) {
                RubberSynthesizer.this.tick(b);
            }

            public boolean isSynchronized() {
                return false;
            }
        }});
    }

    private void tick(@Nonnull Block b) {
        BlockMenu inv = BlockStorage.getInventory((Block)b);
        if (inv == null) {
            return;
        }
        ItemStack input = inv.getItemInSlot(11);
        ItemStack output = inv.getItemInSlot(15);
        if (input == null || input.getType() == Material.AIR || !SlimefunUtils.isItemSimilar((ItemStack)input, (ItemStack)SlimefunItems.OIL_BUCKET, (boolean)true) || output != null && (output.getType() != Items.RUBBER.getType() || output.getAmount() == output.getMaxStackSize() || !Items.RUBBER.getItem().isItem(output))) {
            return;
        }
        BlockPosition pos = new BlockPosition(b.getWorld(), b.getX(), b.getY(), b.getZ());
        int currentProgress = progress.getOrDefault(pos, -1);
        if (currentProgress == -1 && this.takePower(b)) {
            progress.put(pos, 0);
            return;
        }
        if (currentProgress == -1 || !this.takePower(b)) {
            return;
        }
        if (currentProgress == 26) {
            inv.consumeItem(11);
            if (output != null && output.getAmount() > 0) {
                output.setAmount(output.getAmount() + 1);
            } else {
                inv.replaceExistingItem(15, Items.RUBBER.clone());
            }
            progress.remove(pos);
            ChestMenuUtils.updateProgressbar((ChestMenu)inv, (int)13, (int)26, (int)26, (ItemStack)progressItem);
        } else {
            progress.put(pos, ++currentProgress);
            ChestMenuUtils.updateProgressbar((ChestMenu)inv, (int)13, (int)(26 - currentProgress), (int)26, (ItemStack)progressItem);
        }
    }

    private boolean takePower(@Nonnull Block b) {
        if (this.getCharge(b.getLocation()) < 769) {
            return false;
        }
        this.removeCharge(b.getLocation(), 769);
        return true;
    }

    @Nonnull
    public EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.CONSUMER;
    }

    public int getCapacity() {
        return 3845;
    }

    public int[] getInputSlots() {
        return new int[]{11};
    }

    public int[] getOutputSlots() {
        return new int[]{15};
    }
}

