/*
 * Decompiled with CFR 0.152.
 */
package dev.j3fftw.litexpansion.machine;

import dev.j3fftw.litexpansion.Items;
import dev.j3fftw.litexpansion.LiteXpansion;
import io.github.thebusybiscuit.slimefun4.core.multiblocks.MultiBlockMachine;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.cscorelib2.inventory.InvUtils;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Dispenser;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class MetalForge
extends MultiBlockMachine {
    public static final RecipeType RECIPE_TYPE = new RecipeType(new NamespacedKey((Plugin)LiteXpansion.getInstance(), "metal_forge"), Items.METAL_FORGE, new String[]{"", "&7Used to Forge Metals"});
    private static final ItemStack anvil = new ItemStack(Material.ANVIL);
    private static final ItemStack ironBlock = new ItemStack(Material.IRON_BLOCK);

    public MetalForge() {
        super(Items.LITEXPANSION, Items.METAL_FORGE, new ItemStack[]{anvil, new ItemStack(Material.STONE_BRICK_WALL), anvil, ironBlock, new ItemStack(Material.DISPENSER), ironBlock, null, new ItemStack(Material.DIAMOND_BLOCK), null}, new ItemStack[0], BlockFace.DOWN);
    }

    @Nonnull
    public List<ItemStack> getDisplayRecipes() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < this.recipes.size() - 1; i += 2) {
            items.add(((ItemStack[])this.recipes.get(i))[0]);
            items.add(((ItemStack[])this.recipes.get(i + 1))[0]);
        }
        return items;
    }

    protected Inventory createVirtualInventory(Inventory inv) {
        Inventory fakeInv = Bukkit.createInventory(null, (int)9, (String)"Fake Inventory");
        for (int j = 0; j < inv.getContents().length; ++j) {
            CustomItem stack = inv.getContents()[j] != null && inv.getContents()[j].getAmount() > 1 ? new CustomItem(inv.getContents()[j], inv.getContents()[j].getAmount() - 1) : null;
            fakeInv.setItem(j, stack);
        }
        return fakeInv;
    }

    public void onInteract(Player p, Block b) {
        Block dispBlock = b.getRelative(BlockFace.DOWN);
        Dispenser disp = (Dispenser)dispBlock.getState();
        Inventory inv = disp.getInventory();
        List inputs = RecipeType.getRecipeInputList((MultiBlockMachine)this);
        for (ItemStack[] input : inputs) {
            if (!this.canCraft(inv, input)) continue;
            ItemStack output = RecipeType.getRecipeOutputList((MultiBlockMachine)this, (ItemStack[])input).clone();
            if (Slimefun.hasUnlocked((Player)p, (ItemStack)output, (boolean)true)) {
                Inventory fakeInv = this.createVirtualInventory(inv);
                Inventory outputInv = this.findOutputInventory(output, dispBlock, inv, fakeInv);
                if (outputInv != null) {
                    this.craft(p, b, inv, input, output, outputInv);
                } else {
                    SlimefunPlugin.getLocalization().sendMessage((CommandSender)p, "machines.full-inventory", true);
                }
            }
            return;
        }
        SlimefunPlugin.getLocalization().sendMessage((CommandSender)p, "machines.unknown-material", true);
    }

    private void craft(Player p, Block b, Inventory inv, ItemStack[] recipe, ItemStack output, Inventory outputInv) {
        for (ItemStack removing : recipe) {
            if (removing == null) continue;
            InvUtils.removeItem((Inventory)inv, (int)removing.getAmount(), (boolean)true, stack -> SlimefunUtils.isItemSimilar((ItemStack)stack, (ItemStack)removing, (boolean)true));
        }
        outputInv.addItem(new ItemStack[]{output});
        p.getWorld().playSound(p.getLocation(), Sound.BLOCK_ANVIL_BREAK, 1.0f, 1.0f);
        Block diamondBlock = b.getRelative(BlockFace.DOWN, 2);
        diamondBlock.setType(Material.AIR);
    }

    private boolean canCraft(Inventory inv, ItemStack[] recipe) {
        int counter = 0;
        for (int j = 0; j < inv.getContents().length; ++j) {
            SlimefunItem sfItemInv = SlimefunItem.getByItem((ItemStack)inv.getContents()[j]);
            SlimefunItem sfItemRecipe = SlimefunItem.getByItem((ItemStack)recipe[j]);
            if (sfItemInv == null && sfItemRecipe == null) {
                ++counter;
                continue;
            }
            if (sfItemInv == null || sfItemRecipe == null || !sfItemInv.getID().equals(sfItemRecipe.getID())) continue;
            ++counter;
        }
        return counter == inv.getContents().length;
    }
}

