/*
 * Decompiled with CFR 0.152.
 */
package dev.j3fftw.litexpansion;

import dev.j3fftw.litexpansion.Items;
import dev.j3fftw.litexpansion.LiteXpansion;
import dev.j3fftw.litexpansion.items.CargoConfigurator;
import dev.j3fftw.litexpansion.items.FoodSynthesizer;
import dev.j3fftw.litexpansion.items.GlassCutter;
import dev.j3fftw.litexpansion.items.MagThor;
import dev.j3fftw.litexpansion.items.Thorium;
import dev.j3fftw.litexpansion.machine.AdvancedSolarPanel;
import dev.j3fftw.litexpansion.machine.MassFabricator;
import dev.j3fftw.litexpansion.machine.RefinedSmeltery;
import dev.j3fftw.litexpansion.machine.RubberSynthesizer;
import dev.j3fftw.litexpansion.machine.ScrapMachine;
import dev.j3fftw.litexpansion.weapons.NanoBlade;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.implementation.items.blocks.UnplaceableBlock;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

final class ItemSetup {
    protected static final ItemSetup INSTANCE = new ItemSetup();
    private final ItemStack glass = new ItemStack(Material.GLASS);
    private final SlimefunAddon plugin = LiteXpansion.getInstance();
    private boolean initialised;

    private ItemSetup() {
    }

    public void init() {
        if (this.initialised) {
            return;
        }
        this.initialised = true;
        this.registerTools();
        this.registerMachines();
        this.registerRubber();
        this.registerMiscItems();
        this.registerEndgameItems();
        this.registerCarbonStuff();
        this.registerSolarPanels();
    }

    private void registerTools() {
        new CargoConfigurator().register(this.plugin);
        new GlassCutter().register(this.plugin);
    }

    private void registerMachines() {
        new FoodSynthesizer().register(LiteXpansion.getInstance());
        new ScrapMachine().register(LiteXpansion.getInstance());
        new MassFabricator().register(LiteXpansion.getInstance());
        new RefinedSmeltery().register(LiteXpansion.getInstance());
    }

    private void registerRubber() {
        if (!Bukkit.getServer().getPluginManager().isPluginEnabled("SlimyTreeTaps")) {
            this.registerNonPlaceableItem(Items.RUBBER, RubberSynthesizer.RECIPE_TYPE, new ItemStack[]{SlimefunItems.OIL_BUCKET});
            new RubberSynthesizer().register(LiteXpansion.getInstance());
        }
    }

    private void registerMiscItems() {
        ItemStack rubberItem = SlimefunItem.getByID((String)"RUBBER").getItem();
        this.registerNonPlaceableItem(Items.ADVANCED_ALLOY, RecipeType.COMPRESSOR, new ItemStack[]{Items.MIXED_METAL_INGOT});
        this.registerItem(Items.MIXED_METAL_INGOT, RecipeType.ENHANCED_CRAFTING_TABLE, new ItemStack[]{Items.REFINED_IRON, Items.REFINED_IRON, Items.REFINED_IRON, SlimefunItems.BRONZE_INGOT, SlimefunItems.BRONZE_INGOT, SlimefunItems.BRONZE_INGOT, SlimefunItems.TIN_INGOT, SlimefunItems.TIN_INGOT, SlimefunItems.TIN_INGOT});
        this.registerNonPlaceableItem(Items.REINFORCED_GLASS, RecipeType.ENHANCED_CRAFTING_TABLE, new ItemStack[]{this.glass, this.glass, this.glass, Items.ADVANCED_ALLOY, this.glass, Items.ADVANCED_ALLOY, this.glass, this.glass, this.glass});
        this.registerItem(Items.MACHINE_BLOCK, RecipeType.ENHANCED_CRAFTING_TABLE, new ItemStack[]{Items.REFINED_IRON, Items.REFINED_IRON, Items.REFINED_IRON, Items.REFINED_IRON, null, Items.REFINED_IRON, Items.REFINED_IRON, Items.REFINED_IRON, Items.REFINED_IRON});
        this.registerItem(Items.ADVANCED_MACHINE_BLOCK, RecipeType.ENHANCED_CRAFTING_TABLE, new ItemStack[]{null, Items.ADVANCED_ALLOY, null, Items.CARBON_PLATE, Items.MACHINE_BLOCK, Items.CARBON_PLATE, null, Items.CARBON_PLATE, null});
        this.registerNonPlaceableItem(Items.UNINSULATED_COPPER_CABLE, RecipeType.ENHANCED_CRAFTING_TABLE, new ItemStack[]{SlimefunItems.COPPER_INGOT, SlimefunItems.COPPER_INGOT, SlimefunItems.COPPER_INGOT});
        this.registerNonPlaceableItem(Items.COPPER_CABLE, RecipeType.ENHANCED_CRAFTING_TABLE, new ItemStack[]{rubberItem, rubberItem, rubberItem, Items.UNINSULATED_COPPER_CABLE, Items.UNINSULATED_COPPER_CABLE, Items.UNINSULATED_COPPER_CABLE, rubberItem, rubberItem, rubberItem});
        this.registerNonPlaceableItem(Items.ELECTRONIC_CIRCUIT, RecipeType.ENHANCED_CRAFTING_TABLE, new ItemStack[]{Items.COPPER_CABLE, Items.COPPER_CABLE, Items.COPPER_CABLE, new ItemStack(Material.REDSTONE), Items.REFINED_IRON, new ItemStack(Material.REDSTONE), Items.COPPER_CABLE, Items.COPPER_CABLE, Items.COPPER_CABLE});
        this.registerNonPlaceableItem(Items.ADVANCED_CIRCUIT, RecipeType.ENHANCED_CRAFTING_TABLE, new ItemStack[]{new ItemStack(Material.REDSTONE), new ItemStack(Material.LAPIS_LAZULI), new ItemStack(Material.REDSTONE), new ItemStack(Material.GLOWSTONE_DUST), Items.ELECTRONIC_CIRCUIT, new ItemStack(Material.GLOWSTONE_DUST), new ItemStack(Material.REDSTONE), new ItemStack(Material.LAPIS_LAZULI), new ItemStack(Material.REDSTONE)});
        this.registerNonPlaceableItem(Items.REFINED_IRON, RefinedSmeltery.REFINED_SMELTERY_RECIPE, new ItemStack(Material.IRON_INGOT));
        this.registerRecipe(Items.REFINED_IRON, Items.MACHINE_BLOCK);
        new MagThor().register(this.plugin);
        new Thorium().register(this.plugin);
    }

    private void registerEndgameItems() {
        this.registerNonPlaceableItem(Items.SCRAP, ScrapMachine.RECIPE_TYPE, new ItemStack[]{new CustomItem(Material.COBBLESTONE, "&7Any Item!", new String[0])});
        this.registerNonPlaceableItem(Items.UU_MATTER, MassFabricator.RECIPE_TYPE, new ItemStack[]{Items.SCRAP});
        this.registerNonPlaceableItem(Items.IRIDIUM, RecipeType.ENHANCED_CRAFTING_TABLE, new ItemStack[]{Items.UU_MATTER, Items.UU_MATTER, Items.UU_MATTER, null, Items.UU_MATTER, null, Items.UU_MATTER, Items.UU_MATTER, Items.UU_MATTER});
        this.registerItem(Items.IRIDIUM_PLATE, RecipeType.ENHANCED_CRAFTING_TABLE, new ItemStack[]{Items.IRIDIUM, Items.ADVANCED_ALLOY, Items.IRIDIUM, Items.ADVANCED_ALLOY, new ItemStack(Material.DIAMOND), Items.ADVANCED_ALLOY, Items.IRIDIUM, Items.ADVANCED_ALLOY, Items.IRIDIUM});
        new NanoBlade().register(this.plugin);
    }

    private void registerCarbonStuff() {
        this.registerItem(Items.COAL_DUST, RecipeType.ORE_CRUSHER, new ItemStack(Material.COAL));
        this.registerItem(Items.RAW_CARBON_FIBRE, RecipeType.ENHANCED_CRAFTING_TABLE, new ItemStack[]{Items.COAL_DUST, Items.COAL_DUST, null, Items.COAL_DUST, Items.COAL_DUST, null});
        this.registerItem(Items.RAW_CARBON_MESH, RecipeType.ENHANCED_CRAFTING_TABLE, new ItemStack[]{Items.RAW_CARBON_FIBRE, Items.RAW_CARBON_FIBRE, null});
        this.registerNonPlaceableItem(Items.CARBON_PLATE, RecipeType.COMPRESSOR, new ItemStack[]{Items.RAW_CARBON_MESH});
    }

    private void registerSolarPanels() {
        new AdvancedSolarPanel(AdvancedSolarPanel.Type.ADVANCED).register(this.plugin);
        new AdvancedSolarPanel(AdvancedSolarPanel.Type.HYBRID).register(this.plugin);
        new AdvancedSolarPanel(AdvancedSolarPanel.Type.ULTIMATE).register(this.plugin);
    }

    private void registerItem(@Nonnull SlimefunItemStack result, @Nonnull RecipeType type, ItemStack ... items) {
        ItemStack[] recipe;
        if (items.length == 1) {
            ItemStack[] recipe2 = new ItemStack[]{null, null, null, null, items[0], null, null, null, null};
            new SlimefunItem(Items.LITEXPANSION, result, type, recipe2).register(this.plugin);
            for (int i = 0; i < 9; ++i) {
                if (i == 4) continue;
                ItemStack[] recipe22 = new ItemStack[9];
                recipe22[i] = items[0];
                type.register(recipe22, (ItemStack)result);
            }
            return;
        }
        if (items.length < 9) {
            recipe = new ItemStack[9];
            System.arraycopy(items, 0, recipe, 0, items.length);
        } else {
            recipe = items;
        }
        new SlimefunItem(Items.LITEXPANSION, result, type, recipe).register(this.plugin);
    }

    private void registerNonPlaceableItem(@Nonnull SlimefunItemStack result, @Nonnull RecipeType type, ItemStack ... items) {
        ItemStack[] recipe;
        if (items.length == 1) {
            ItemStack[] recipe2 = new ItemStack[]{null, null, null, null, items[0], null, null, null, null};
            new UnplaceableBlock(Items.LITEXPANSION, result, type, recipe2).register(this.plugin);
            for (int i = 0; i < 9; ++i) {
                if (i == 4) continue;
                ItemStack[] recipe22 = new ItemStack[9];
                recipe22[i] = items[0];
                type.register(recipe22, (ItemStack)result);
            }
            return;
        }
        if (items.length < 9) {
            recipe = new ItemStack[9];
            System.arraycopy(items, 0, recipe, 0, items.length);
        } else {
            recipe = items;
        }
        new UnplaceableBlock(Items.LITEXPANSION, result, type, recipe).register(this.plugin);
    }

    private void registerRecipe(@Nonnull SlimefunItemStack result, @Nonnull SlimefunItemStack item) {
        for (int i = 0; i < 9; ++i) {
            ItemStack[] recipe = new ItemStack[9];
            recipe[i] = item;
            RecipeType.ENHANCED_CRAFTING_TABLE.register(recipe, (ItemStack)result);
        }
    }
}

