/*
 * Decompiled with CFR 0.152.
 */
package dev.j3fftw.litexpansion;

import dev.j3fftw.litexpansion.Items;
import dev.j3fftw.litexpansion.armor.ElectricChestplate;
import dev.j3fftw.litexpansion.items.FoodSynthesizer;
import dev.j3fftw.litexpansion.utils.Constants;
import dev.j3fftw.litexpansion.weapons.NanoBlade;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.inventory.ItemStack;

public class Events
implements Listener {
    @EventHandler
    public void onHunger(FoodLevelChangeEvent e) {
        Player p = (Player)e.getEntity();
        if (e.getFoodLevel() < p.getFoodLevel()) {
            this.checkAndConsume(p, e);
        }
    }

    @EventHandler
    public void onPlayerDamageDeal(EntityDamageByEntityEvent e) {
        if (e.getDamager() instanceof Player) {
            Player p = (Player)e.getDamager();
            ItemStack itemInHand = p.getInventory().getItemInMainHand();
            NanoBlade nanoBlade = (NanoBlade)SlimefunItem.getByID((String)Items.NANO_BLADE.getItemId());
            if (nanoBlade.isItem(itemInHand) && itemInHand.containsEnchantment(Enchantment.getByKey((NamespacedKey)Constants.GLOW_ENCHANT)) && nanoBlade.removeItemCharge(itemInHand, 10.0f)) {
                e.setDamage(e.getDamage() * 1.75);
            }
        }
    }

    @EventHandler
    public void onPlayerDamage(EntityDamageEvent e) {
        if (e.getEntity() instanceof Player && ((Player)e.getEntity()).getEquipment() != null) {
            Player p = (Player)e.getEntity();
            ItemStack chestplate = p.getEquipment().getChestplate();
            ElectricChestplate electricChestplate = (ElectricChestplate)SlimefunItem.getByID((String)Items.ELECTRIC_CHESTPLATE.getItemId());
            if (chestplate != null && electricChestplate.isItem(chestplate) && electricChestplate.removeItemCharge(chestplate, (float)(e.getDamage() / 1.75))) {
                e.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onHungerDamage(EntityDamageEvent e) {
        if (Items.FOOD_SYNTHESIZER == null || Items.FOOD_SYNTHESIZER.getItem().isDisabled() || !(e.getEntity() instanceof Player)) {
            return;
        }
        if (e.getCause() == EntityDamageEvent.DamageCause.STARVATION) {
            this.checkAndConsume((Player)e.getEntity(), null);
        }
    }

    public void checkAndConsume(Player p, FoodLevelChangeEvent e) {
        FoodSynthesizer foodSynth = (FoodSynthesizer)Items.FOOD_SYNTHESIZER.getItem();
        for (ItemStack item : p.getInventory().getContents()) {
            if (!foodSynth.isItem(item) || !foodSynth.removeItemCharge(item, 3.0f)) continue;
            p.playSound(p.getLocation(), Sound.ENTITY_GENERIC_EAT, 1.5f, 1.0f);
            p.setFoodLevel(20);
            p.setSaturation(5.0f);
            if (e == null) continue;
            e.setFoodLevel(20);
        }
    }
}

