/*
 * Decompiled with CFR 0.152.
 */
package dev.j3fftw.litexpansion.utils;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class Timing {
    private final String name;
    private final List<Long> steps = new ArrayList<Long>();
    private long start;
    private long end;

    private Timing(@Nonnull String name) {
        this.name = name;
    }

    public static Timing create(String name) {
        Timing timing = new Timing(name);
        timing.start();
        return timing;
    }

    public void start() {
        this.start = System.nanoTime();
    }

    public void step() {
        this.steps.add(System.nanoTime());
    }

    public void stop() {
        this.end = System.nanoTime();
    }

    public void stop(boolean printResults) {
        this.stop();
        if (printResults) {
            this.sendResults();
        }
    }

    public void sendResults() {
        StringBuilder sb = new StringBuilder(this.name + " timings, took: " + this.time(this.start, this.end));
        int idx = 1;
        for (long step : this.steps) {
            long before = idx == 1 ? this.start : this.steps.get(idx - 1);
            sb.append("\n  Step ").append(idx++).append(": ").append(this.time(before, step));
        }
        if (!this.steps.isEmpty()) {
            sb.append("\n  Final step: ").append(this.time(this.steps.get(this.steps.size() - 1), this.end));
        }
        System.out.println(sb.toString());
    }

    private String time(long a, long b) {
        return b - a + "ns (" + (double)(b - a) / 1000000.0 + "ms)";
    }
}

