/*
 * Decompiled with CFR 0.152.
 */
package dev.j3fftw.litexpansion;

import dev.j3fftw.litexpansion.Events;
import dev.j3fftw.litexpansion.ItemSetup;
import dev.j3fftw.litexpansion.Items;
import dev.j3fftw.litexpansion.NanoBladeActiveEnchant;
import dev.j3fftw.litexpansion.armor.ElectricChestplate;
import dev.j3fftw.litexpansion.resources.ThoriumResource;
import dev.j3fftw.litexpansion.utils.Constants;
import dev.j3fftw.litexpansion.uumatter.UUMatter;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import java.io.File;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.Research;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.bstats.bukkit.Metrics;
import me.mrCookieSlime.Slimefun.cscorelib2.updater.GitHubBuildsUpdater;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class LiteXpansion
extends JavaPlugin
implements SlimefunAddon {
    private static LiteXpansion instance;

    public void onEnable() {
        instance = this;
        if (!new File(this.getDataFolder(), "config.yml").exists()) {
            this.saveDefaultConfig();
        }
        Metrics metrics = new Metrics((Plugin)this, 7111);
        this.setupCustomMetrics(metrics);
        if (this.getConfig().getBoolean("options.auto-update") && this.getDescription().getVersion().startsWith("DEV - ")) {
            new GitHubBuildsUpdater((Plugin)this, this.getFile(), "J3fftw1/LiteXpansion/master").start();
        }
        this.getServer().getPluginManager().registerEvents((Listener)new Events(), (Plugin)this);
        Items.LITEXPANSION.register();
        ItemSetup.INSTANCE.init();
        new ElectricChestplate().register(this);
        UUMatter.INSTANCE.register();
        try {
            if (!Enchantment.isAcceptingRegistrations()) {
                Field accepting = Enchantment.class.getDeclaredField("acceptingNew");
                accepting.setAccessible(true);
                accepting.set(null, true);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException ignored) {
            this.getLogger().warning("Failed to register enchantment. Seems the 'acceptingNew' field changed monkaS");
        }
        Enchantment.registerEnchantment((Enchantment)new NanoBladeActiveEnchant(Constants.NANO_BLADE_ACTIVE_ENCHANT));
        this.setupResearches();
        new ThoriumResource().register();
    }

    public void onDisable() {
        instance = null;
    }

    private void setupResearches() {
        Slimefun.registerResearch((Research)new Research(new NamespacedKey((Plugin)this, "sanitizing_foots"), 696969, "Sanitizing  foots since 2k10", 45), (ItemStack[])new ItemStack[]{Items.FOOD_SYNTHESIZER});
        Slimefun.registerResearch((Research)new Research(new NamespacedKey((Plugin)this, "superalloys"), 696970, "Superalloys", 35), (ItemStack[])new ItemStack[]{Items.THORIUM, Items.MAG_THOR});
        Slimefun.registerResearch((Research)new Research(new NamespacedKey((Plugin)this, "super_hot_fire"), 696971, "Super Hot Fire", 31), (ItemStack[])new ItemStack[]{Items.NANO_BLADE});
    }

    private void setupCustomMetrics(@Nonnull Metrics metrics) {
        metrics.addCustomChart((Metrics.CustomChart)new Metrics.AdvancedPie("blocks_placed", () -> {
            HashMap<String, Integer> data = new HashMap<String, Integer>();
            try {
                Class<?> blockStorage = Class.forName("me.mrCookieSlime.Slimefun.api.BlockStorage");
                for (World world : Bukkit.getWorlds()) {
                    BlockStorage storage = BlockStorage.getStorage((World)world);
                    if (storage == null) continue;
                    Field f = blockStorage.getDeclaredField("storage");
                    f.setAccessible(true);
                    Map blocks = (Map)f.get(storage);
                    for (Map.Entry entry : blocks.entrySet()) {
                        SlimefunItem item = SlimefunItem.getByID((String)((Config)entry.getValue()).getString("id"));
                        if (item == null || !(item.getAddon() instanceof LiteXpansion)) continue;
                        data.merge(item.getID(), 1, Integer::sum);
                    }
                }
            }
            catch (ReflectiveOperationException e) {
                this.getLogger().log(Level.WARNING, "Failed to load placed blocks", e);
            }
            return data;
        }));
    }

    public JavaPlugin getJavaPlugin() {
        return this;
    }

    public String getBugTrackerURL() {
        return "https://github.com/J3fftw1/LiteXpansion/issues";
    }

    public static LiteXpansion getInstance() {
        return instance;
    }
}

