/*
 * Decompiled with CFR 0.152.
 */
package dev.j3fftw.litexpansion.uumatter;

import dev.j3fftw.litexpansion.Items;
import dev.j3fftw.litexpansion.LiteXpansion;
import dev.j3fftw.litexpansion.utils.Utils;
import dev.j3fftw.litexpansion.uumatter.UuMatterCategory;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.cscorelib2.config.Config;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public final class UUMatter {
    public static final UUMatter INSTANCE = new UUMatter();
    private final Map<ItemStack, ItemStack[]> recipes = new LinkedHashMap<ItemStack, ItemStack[]>();
    private boolean registered;

    private UUMatter() {
    }

    public void register() {
        if (this.registered) {
            return;
        }
        File uuMatterFile = new File(LiteXpansion.getInstance().getDataFolder(), "uumatter.yml");
        if (!uuMatterFile.exists()) {
            try {
                Files.copy(this.getClass().getResourceAsStream("/uumatter.yml"), uuMatterFile.toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                LiteXpansion.getInstance().getLogger().log(Level.SEVERE, "Failed to copy default uumatter.yml file", e);
            }
        }
        Config config = new Config((Plugin)LiteXpansion.getInstance(), "uumatter.yml");
        for (String key : config.getKeys("recipes")) {
            ItemStack output;
            int idx = key.indexOf(58);
            String id = key.toUpperCase().replace(' ', '_').substring(0, idx == -1 ? key.length() : idx);
            int amount = 1;
            if (idx == -1) {
                amount = Utils.getInt(key.substring(idx + 1), 1);
            }
            if ((output = this.getOutputItem(id, amount)) == null) continue;
            ItemStack[] recipe = new ItemStack[9];
            this.parseRecipe(config, key, recipe);
            this.recipes.put(output, recipe);
        }
        LiteXpansion.getInstance().getLogger().log(Level.INFO, "Loaded {0} UU-Matter recipes", new Object[]{this.recipes.size()});
        UuMatterCategory.INSTANCE.register();
        this.registered = true;
    }

    @Nullable
    private ItemStack getOutputItem(String id, int amount) {
        ItemStack output;
        Material mat = Material.getMaterial((String)id);
        if (mat != null) {
            output = new ItemStack(mat, amount);
        } else {
            SlimefunItem item = SlimefunItem.getByID((String)id);
            if (item == null) {
                LiteXpansion.getInstance().getLogger().log(Level.WARNING, "Unable to create recipe, unknown output item: {0}", new Object[]{id});
                return null;
            }
            output = item.getItem().clone();
            output.setAmount(amount);
        }
        return output;
    }

    private void parseRecipe(@Nonnull Config config, @Nonnull String key, @Nonnull ItemStack[] recipe) {
        int i = 0;
        List recipeList = config.getStringList("recipes." + key);
        for (String line : recipeList.subList(0, Math.min(recipeList.size(), 3))) {
            if (line.length() < 3) {
                LiteXpansion.getInstance().getLogger().log(Level.WARNING, "Failed to load recipe for {0}, recipe length expected is 3 but got {1}", new Object[]{key, line.length()});
                return;
            }
            char[] chars = new char[3];
            System.arraycopy(line.toCharArray(), 0, chars, 0, 3);
            for (char c : chars) {
                recipe[i++] = c == 'x' ? Items.UU_MATTER.clone() : null;
            }
        }
    }

    public void addUuMatterRecipe(@Nonnull SlimefunItemStack item, int amount, @Nonnull ItemStack[] recipe) {
        ItemStack clone = item.clone();
        clone.setAmount(amount);
        this.addUuMatterRecipe(clone, recipe);
    }

    public void addUuMatterRecipe(@Nonnull ItemStack result, @Nonnull ItemStack[] recipe) {
        if (recipe.length < 9) {
            recipe = Arrays.copyOf(recipe, 9);
        }
        RecipeType.ENHANCED_CRAFTING_TABLE.register(recipe, result);
        this.recipes.put(result, recipe);
    }

    public Map<ItemStack, ItemStack[]> getRecipes() {
        return Collections.unmodifiableMap(this.recipes);
    }
}

