/*
 * Decompiled with CFR 0.152.
 */
package dev.j3fftw.litexpansion.machine.extensions;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.multiblocks.MultiBlockMachine;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.items.backpacks.SlimefunBackpack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.ItemUtils;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.List;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Dispenser;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public abstract class CraftingMultiBlock
extends MultiBlockMachine {
    protected CraftingMultiBlock(ItemGroup itemGroup, SlimefunItemStack item, ItemStack[] recipe, ItemStack[] machineRecipes, BlockFace trigger) {
        super(itemGroup, item, recipe, machineRecipes, trigger);
    }

    protected Inventory createVirtualInventory(Inventory inv) {
        Inventory fakeInv = Bukkit.createInventory(null, (int)9, (String)"Fake Inventory");
        for (int j = 0; j < inv.getContents().length; ++j) {
            CustomItemStack stack = inv.getContents()[j] != null && inv.getContents()[j].getAmount() > 1 ? new CustomItemStack(inv.getContents()[j], inv.getContents()[j].getAmount() - 1) : null;
            fakeInv.setItem(j, stack);
        }
        return fakeInv;
    }

    public void onInteract(Player p, Block b) {
        Block dispenser = b.getRelative(BlockFace.DOWN);
        BlockState state = PaperLib.getBlockState((Block)dispenser, (boolean)false).getState();
        Block specialBlock = this.getSpecialBlock(dispenser);
        if (specialBlock != null && !specialBlock.getType().isAir() && BlockStorage.hasBlockInfo((Block)specialBlock)) {
            p.sendMessage(ChatColor.RED + "You can't use Slimefun blocks as part of the multi-block >:(");
            return;
        }
        BlockState blockState = state;
        if (blockState instanceof Dispenser) {
            Dispenser disp = (Dispenser)blockState;
            Inventory inv = disp.getInventory();
            List inputs = RecipeType.getRecipeInputList((MultiBlockMachine)this);
            for (ItemStack[] input : inputs) {
                if (!this.isCraftable(inv, input)) continue;
                ItemStack output = RecipeType.getRecipeOutputList((MultiBlockMachine)this, (ItemStack[])input).clone();
                if (SlimefunUtils.canPlayerUseItem((Player)p, (ItemStack)output, (boolean)true)) {
                    this.craft(inv, dispenser, p, b, output);
                }
                return;
            }
            Slimefun.getLocalization().sendMessage((CommandSender)p, "machines.pattern-not-found", true);
        }
    }

    private void craft(Inventory inv, Block dispenser, Player p, Block b, ItemStack output) {
        Inventory fakeInv = this.createVirtualInventory(inv);
        Inventory outputInv = this.findOutputInventory(output, dispenser, inv, fakeInv);
        if (outputInv != null) {
            Block specialBlock;
            for (int j = 0; j < 9; ++j) {
                ItemStack item = inv.getContents()[j];
                if (item == null || item.getType() == Material.AIR) continue;
                ItemUtils.consumeItem((ItemStack)item, (boolean)true);
            }
            p.getWorld().playSound(b.getLocation(), Sound.BLOCK_WOODEN_BUTTON_CLICK_ON, 1.0f, 1.0f);
            outputInv.addItem(new ItemStack[]{output});
            if (this.removeSpecialBlock() && (specialBlock = this.getSpecialBlock(dispenser)) != null) {
                specialBlock.setType(Material.AIR);
                specialBlock.getWorld().spawnParticle(Particle.PORTAL, specialBlock.getLocation(), 4, 0.5, 0.5, 0.5);
            }
        } else {
            Slimefun.getLocalization().sendMessage((CommandSender)p, "machines.full-inventory", true);
        }
    }

    private boolean isCraftable(Inventory inv, ItemStack[] recipe) {
        for (int j = 0; j < inv.getContents().length; ++j) {
            if (SlimefunUtils.isItemSimilar((ItemStack)inv.getContents()[j], (ItemStack)recipe[j], (boolean)true)) continue;
            if (SlimefunItem.getByItem((ItemStack)recipe[j]) instanceof SlimefunBackpack) {
                if (SlimefunUtils.isItemSimilar((ItemStack)inv.getContents()[j], (ItemStack)recipe[j], (boolean)false)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public abstract Block getSpecialBlock(Block var1);

    public abstract boolean removeSpecialBlock();
}

