/*
 * Decompiled with CFR 0.152.
 */
package dev.j3fftw.litexpansion.utils;

import dev.j3fftw.litexpansion.utils.Log;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class Reflections {
    private Reflections() {
    }

    public static void setStaticField(@Nonnull Class<?> clazz, @Nonnull String fieldName, @Nonnull Object newValue) {
        try {
            Field f = clazz.getDeclaredField(fieldName);
            f.setAccessible(true);
            f.set(null, newValue);
        }
        catch (ReflectiveOperationException e) {
            Log.warn("Failed to change field {} to {} in {}", fieldName, newValue, clazz.getSimpleName());
        }
    }

    public static void setField(@Nullable Object instance, @Nonnull String fieldName, @Nonnull Object newValue) {
        if (instance == null) {
            return;
        }
        try {
            Field f = instance.getClass().getDeclaredField(fieldName);
            f.setAccessible(true);
            f.set(instance, newValue);
        }
        catch (ReflectiveOperationException e) {
            Log.warn("Failed to change field {} to {} in {}", fieldName, newValue, instance.getClass().getSimpleName());
        }
    }

    public static Object getField(@Nonnull Class<?> clazz, @Nullable Object instance, @Nonnull String fieldName) {
        try {
            Field f = clazz.getDeclaredField(fieldName);
            f.setAccessible(true);
            return f.get(instance);
        }
        catch (ReflectiveOperationException e) {
            Log.warn("Failed to get field {} in {}", fieldName, clazz.getSimpleName());
            return null;
        }
    }

    public static <T> T getField(@Nonnull Object instance, @Nonnull Field field) {
        try {
            return (T)field.get(instance);
        }
        catch (ReflectiveOperationException e) {
            Log.warn("Failed to get field value {} from {}", field, instance.getClass().getSimpleName());
            return null;
        }
    }

    public static Field getRawField(@Nonnull Class<?> clazz, @Nonnull String fieldName) {
        try {
            Field f = clazz.getDeclaredField(fieldName);
            f.setAccessible(true);
            return f;
        }
        catch (ReflectiveOperationException e) {
            Log.warn("Failed to get field {} in {}", fieldName, clazz.getSimpleName());
            return null;
        }
    }

    public static void invoke(@Nonnull Class<?> clazz, @Nullable Object instance, @Nonnull String methodName) {
        try {
            Method m = clazz.getDeclaredMethod(methodName, new Class[0]);
            m.setAccessible(true);
            m.invoke(instance, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            Log.warn("Failed to invoke method {} in {}", methodName, clazz.getSimpleName());
        }
    }
}

