/*
 * Decompiled with CFR 0.152.
 */
package dev.j3fftw.litexpansion.weapons;

import dev.j3fftw.litexpansion.Items;
import dev.j3fftw.litexpansion.items.PassiveElectricRemoval;
import dev.j3fftw.litexpansion.machine.multiblock.MetalForge;
import dev.j3fftw.litexpansion.utils.Constants;
import dev.j3fftw.litexpansion.utils.Utils;
import io.github.thebusybiscuit.slimefun4.core.attributes.Rechargeable;
import io.github.thebusybiscuit.slimefun4.core.handlers.ItemUseHandler;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataHolder;

public class NanoBlade
extends SimpleSlimefunItem<ItemUseHandler>
implements Rechargeable,
PassiveElectricRemoval {
    public static final float CAPACITY = 4000.0f;
    public static final float PER_TICK_REMOVAL = 64.0f;

    public NanoBlade() {
        super(Items.LITEXPANSION, Items.NANO_BLADE, MetalForge.RECIPE_TYPE, new ItemStack[]{new ItemStack(Material.GLOWSTONE_DUST), Items.ADVANCED_ALLOY, null, new ItemStack(Material.GLOWSTONE_DUST), Items.ADVANCED_ALLOY, null, Items.CARBON_PLATE, SlimefunItems.POWER_CRYSTAL, Items.CARBON_PLATE});
    }

    public float getMaxItemCharge(ItemStack item) {
        return 4000.0f;
    }

    @Nonnull
    public ItemUseHandler getItemHandler() {
        return event -> {
            int damage;
            Enchantment enchantment;
            boolean enabled;
            ItemMeta nanoBladeMeta = event.getItem().getItemMeta();
            boolean bl = enabled = !nanoBladeMeta.removeEnchant(enchantment = Enchantment.getByKey((NamespacedKey)Constants.GLOW_ENCHANT));
            if (enabled && this.getItemCharge(event.getItem()) > this.getRemovedChargePerTick()) {
                nanoBladeMeta.addEnchant(enchantment, 1, false);
                nanoBladeMeta.setDisplayName(ChatColor.DARK_GREEN + "Nano Blade" + ChatColor.GREEN + " (On)");
                damage = 13;
            } else {
                nanoBladeMeta.setDisplayName(ChatColor.DARK_GREEN + "Nano Blade" + ChatColor.RED + " (Off)");
                damage = -3;
            }
            PersistentDataAPI.setBoolean((PersistentDataHolder)nanoBladeMeta, (NamespacedKey)Constants.NANO_BLADE_ENABLED, (boolean)enabled);
            nanoBladeMeta.removeAttributeModifier(Attribute.GENERIC_ATTACK_DAMAGE);
            nanoBladeMeta.addAttributeModifier(Attribute.GENERIC_ATTACK_DAMAGE, new AttributeModifier(UUID.randomUUID(), Attribute.GENERIC_ATTACK_DAMAGE.getKey().getKey(), (double)damage, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlot.HAND));
            event.getItem().setItemMeta(nanoBladeMeta);
        };
    }

    @Override
    public float getRemovedChargePerTick() {
        return 64.0f;
    }

    @Override
    public float getCapacity() {
        return 4000.0f;
    }

    @Override
    public boolean isEnabled(@Nonnull ItemMeta meta) {
        Optional<Boolean> opt = Utils.getOptionalBoolean(meta, Constants.NANO_BLADE_ENABLED);
        return opt.isPresent() && opt.get() != false || meta.hasEnchant(Enchantment.getByKey((NamespacedKey)Constants.GLOW_ENCHANT));
    }
}

