/*
 * Decompiled with CFR 0.152.
 */
package dev.j3fftw.litexpansion.service;

import dev.j3fftw.litexpansion.LiteXpansion;
import dev.j3fftw.litexpansion.bstats.bukkit.Metrics;
import dev.j3fftw.litexpansion.bstats.charts.AdvancedPie;
import dev.j3fftw.litexpansion.bstats.charts.SimplePie;
import dev.j3fftw.litexpansion.utils.Reflections;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;

public class MetricsService {
    private final Map<UUID, Field> rawStorageMethods = new HashMap<UUID, Field>();

    public void setup(@Nonnull Metrics metrics) {
        LiteXpansion.getInstance().getServer().getScheduler().runTask((Plugin)LiteXpansion.getInstance(), () -> {
            for (World world : Bukkit.getWorlds()) {
                BlockStorage storage = BlockStorage.getStorage((World)world);
                if (storage == null) continue;
                Field field = Reflections.getRawField(BlockStorage.class, "storage");
                this.rawStorageMethods.put(world.getUID(), field);
            }
        });
        this.setupCharts(metrics);
    }

    private void setupCharts(@Nonnull Metrics metrics) {
        metrics.addCustomChart(new AdvancedPie("blocks_placed", () -> {
            HashMap<String, Integer> data = new HashMap<String, Integer>();
            for (World world : Bukkit.getWorlds()) {
                Map<Location, Config> rawStorage = this.getStorageForWorld(world);
                if (rawStorage == null) continue;
                for (Map.Entry<Location, Config> entry : rawStorage.entrySet()) {
                    SlimefunItem item = SlimefunItem.getById((String)entry.getValue().getString("id"));
                    if (item == null || !(item.getAddon() instanceof LiteXpansion)) continue;
                    data.merge(item.getId(), 1, Integer::sum);
                }
            }
            return data;
        }));
        metrics.addCustomChart(new SimplePie("nerf_addons", () -> LiteXpansion.getInstance().getConfig().getBoolean("options.nerf-other-addons", true) ? "true" : "false"));
    }

    @Nullable
    private Map<Location, Config> getStorageForWorld(@Nonnull World world) {
        Field f = this.rawStorageMethods.get(world.getUID());
        BlockStorage storage = BlockStorage.getStorage((World)world);
        if (f != null && storage != null) {
            return (Map)Reflections.getField(storage, f);
        }
        return null;
    }
}

