/*
 * Decompiled with CFR 0.152.
 */
package dev.j3fftw.litexpansion.machine.extensions;

import dev.j3fftw.litexpansion.extrautils.interfaces.InventoryBlock;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.Rechargeable;
import io.github.thebusybiscuit.slimefun4.implementation.handlers.SimpleBlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.implementation.items.electric.Capacitor;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;

public abstract class ChargingStorageUnit
extends Capacitor
implements InventoryBlock {
    private static final int INPUT_SLOT = 13;
    private final int jPerTick;

    @ParametersAreNonnullByDefault
    protected ChargingStorageUnit(ItemGroup itemGroup, int capacity, int jPerTick, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, capacity, item, recipeType, recipe);
        this.jPerTick = jPerTick;
        this.setupInv();
    }

    public void preRegister() {
        this.addItemHandler(new ItemHandler[]{new BlockTicker(){

            public void tick(Block b, SlimefunItem sf, Config data) {
                ChargingStorageUnit.this.doTick(b);
            }

            public boolean isSynchronized() {
                return false;
            }
        }});
    }

    public abstract String getTitle();

    @Override
    public int[] getInputSlots() {
        return new int[]{13};
    }

    @Override
    public int[] getOutputSlots() {
        return new int[0];
    }

    private void setupInv() {
        this.createPreset((SlimefunItem)this, this.getTitle(), blockMenuPreset -> {
            for (int i = 0; i < 27; ++i) {
                if (i == 13) continue;
                blockMenuPreset.addItem(i, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
            }
        });
        this.addItemHandler(new ItemHandler[]{new SimpleBlockBreakHandler(){

            public void onBlockBreak(@Nonnull Block b) {
                BlockMenu inv = BlockStorage.getInventory((Block)b);
                if (inv != null) {
                    inv.dropItems(b.getLocation(), new int[]{13});
                }
            }
        }});
    }

    private void doTick(@Nonnull Block b) {
        BlockMenu inv = BlockStorage.getInventory((Block)b);
        if (inv == null) {
            return;
        }
        ItemStack input = inv.getItemInSlot(13);
        SlimefunItem item = SlimefunItem.getByItem((ItemStack)input);
        if (item instanceof Rechargeable && input.getAmount() == 1) {
            ((Rechargeable)item).addItemCharge(input, (float)this.jPerTick);
        }
    }
}

