/*
 * Decompiled with CFR 0.152.
 */
package dev.j3fftw.litexpansion;

import dev.j3fftw.litexpansion.Items;
import dev.j3fftw.litexpansion.armor.ElectricChestplate;
import dev.j3fftw.litexpansion.extrautils.objects.DyeItem;
import dev.j3fftw.litexpansion.items.FoodSynthesizer;
import dev.j3fftw.litexpansion.items.GlassCutter;
import dev.j3fftw.litexpansion.items.MiningDrill;
import dev.j3fftw.litexpansion.items.PassiveElectricRemoval;
import dev.j3fftw.litexpansion.utils.Utils;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.core.attributes.Rechargeable;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import io.github.thebusybiscuit.slimefun4.utils.ChargeUtils;
import io.github.thebusybiscuit.slimefun4.utils.tags.SlimefunTag;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.ComponentBuilder;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public class Events
implements Listener {
    private final GlassCutter glassCutter = (GlassCutter)Items.GLASS_CUTTER.getItem();
    private final ElectricChestplate electricChestplate = (ElectricChestplate)Items.ELECTRIC_CHESTPLATE.getItem();
    private final FoodSynthesizer foodSynth = (FoodSynthesizer)Items.FOOD_SYNTHESIZER.getItem();

    @EventHandler
    public void onItemDamage(PlayerItemDamageEvent e) {
        SlimefunItem item;
        if (e.getItem().hasItemMeta() && ((item = SlimefunItem.getByItem((ItemStack)e.getItem())) instanceof PassiveElectricRemoval || item instanceof ElectricChestplate)) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerDamage(EntityDamageEvent e) {
        if (e.getEntity() instanceof Player && ((Player)e.getEntity()).getEquipment() != null) {
            Player p = (Player)e.getEntity();
            ItemStack chestplate = p.getEquipment().getChestplate();
            if (e.getFinalDamage() > 0.0 && chestplate != null && this.electricChestplate.isItem(chestplate) && this.electricChestplate.removeItemCharge(chestplate, Math.max(1.0f, (float)e.getFinalDamage()) * 20.0f)) {
                ItemMeta meta = chestplate.getItemMeta();
                float newCharge = ChargeUtils.getCharge((ItemMeta)meta);
                e.setCancelled(true);
                ComponentBuilder builder = new ComponentBuilder();
                builder.append("Electric Chestplate").color(ChatColor.BLUE).append(" absorbed damage - Charge left: ").color(ChatColor.GRAY).append(String.valueOf(this.electricChestplate.getItemCharge(chestplate))).color(ChatColor.YELLOW).append(" J");
                if (meta instanceof Damageable) {
                    double chargePercent = newCharge / this.electricChestplate.getMaxItemCharge(chestplate) * 100.0f;
                    int percentOfMax = (int)(chargePercent / 100.0 * (double)chestplate.getType().getMaxDurability());
                    int damage = Math.max(1, chestplate.getType().getMaxDurability() - percentOfMax);
                    ((Damageable)meta).setDamage(damage);
                    chestplate.setItemMeta(meta);
                }
                ((Player)e.getEntity()).spigot().sendMessage(ChatMessageType.ACTION_BAR, builder.create());
            }
        }
    }

    @EventHandler
    public void onHunger(FoodLevelChangeEvent e) {
        Player p = (Player)e.getEntity();
        if (e.getFoodLevel() < p.getFoodLevel()) {
            this.checkAndConsume(p, e);
        }
    }

    @EventHandler
    public void onHungerDamage(EntityDamageEvent e) {
        if (e.getCause() == EntityDamageEvent.DamageCause.STARVATION && e.getEntity() instanceof Player && Items.FOOD_SYNTHESIZER != null && !Items.FOOD_SYNTHESIZER.getItem().isDisabled()) {
            this.checkAndConsume((Player)e.getEntity(), null);
        }
    }

    @EventHandler
    public void onDye(PlayerInteractEntityEvent e) {
        ItemStack item = e.getHand() == EquipmentSlot.HAND ? e.getPlayer().getInventory().getItemInMainHand() : e.getPlayer().getInventory().getItemInOffHand();
        if (SlimefunItem.getByItem((ItemStack)item) instanceof DyeItem) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onDrillUse(PlayerInteractEvent event) {
        MiningDrill diamondDrill;
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        Material blockType = block.getType();
        Location blockLocation = block.getLocation();
        ItemStack hand = event.getItem();
        MiningDrill miningDrill = (MiningDrill)SlimefunItem.getById((String)Items.MINING_DRILL.getItemId());
        if (miningDrill.isItem(hand)) {
            if (!this.check(miningDrill, event, blockLocation)) {
                return;
            }
            if (!SlimefunTag.STONE_VARIANTS.isTagged(blockType)) {
                return;
            }
            this.drillUse(0.5f, block, blockType, blockLocation, event);
        }
        if ((diamondDrill = (MiningDrill)SlimefunItem.getById((String)Items.DIAMOND_DRILL.getItemId())).isItem(hand)) {
            if (!this.check(diamondDrill, event, blockLocation)) {
                return;
            }
            if (!SlimefunTag.MINEABLE_PICKAXE.isTagged((Keyed)blockType)) {
                return;
            }
            this.drillUse(1.5f, block, blockType, blockLocation, event);
        }
    }

    public boolean check(MiningDrill miningDrill, PlayerInteractEvent event, Location blockLocation) {
        return miningDrill.isItem(event.getItem()) && !miningDrill.isDisabled() && Slimefun.getProtectionManager().hasPermission((OfflinePlayer)event.getPlayer(), blockLocation, Interaction.BREAK_BLOCK);
    }

    public void drillUse(float charge, Block block, Material blockType, Location blockLocation, PlayerInteractEvent event) {
        event.setCancelled(true);
        SlimefunItem slimefunItem = BlockStorage.check((Block)block);
        if (slimefunItem != null) {
            return;
        }
        if (!(slimefunItem instanceof Rechargeable)) {
            return;
        }
        Rechargeable item = (Rechargeable)SlimefunItem.getByItem((ItemStack)event.getItem());
        if (item == null) {
            return;
        }
        if (!item.removeItemCharge(event.getItem(), charge)) {
            return;
        }
        BlockBreakEvent newEvent = new BlockBreakEvent(block, event.getPlayer());
        Bukkit.getServer().getPluginManager().callEvent((Event)newEvent);
        if (event.isCancelled()) {
            return;
        }
        block.setType(Material.AIR);
        event.getPlayer().playSound(blockLocation, Sound.BLOCK_STONE_BREAK, 1.5f, 1.0f);
        if (blockType == Material.STONE) {
            blockLocation.getWorld().dropItem(blockLocation, new ItemStack(Material.COBBLESTONE));
        } else if (blockType == Material.DEEPSLATE) {
            blockLocation.getWorld().dropItem(blockLocation, new ItemStack(Material.COBBLED_DEEPSLATE));
        } else {
            blockLocation.getWorld().dropItem(blockLocation, new ItemStack(blockType));
        }
    }

    @EventHandler
    public void onDiamondDrillUpgrade(InventoryClickEvent e) {
        Player p = (Player)e.getWhoClicked();
        MiningDrill diamondDrill = (MiningDrill)SlimefunItem.getById((String)Items.DIAMOND_DRILL.getItemId());
        Validate.notNull((Object)((Object)diamondDrill), (String)"Can not be null");
        if (diamondDrill.isItem(e.getCurrentItem()) && p.getOpenInventory().getType().toString().equals("SMITHING")) {
            e.setCancelled(true);
            Utils.send(p, "&cYou can not upgrade your Diamond Drill!");
        }
    }

    @EventHandler
    public void onGlassCut(PlayerInteractEvent e) {
        Block block = e.getClickedBlock();
        if (block == null) {
            return;
        }
        Material blockType = block.getType();
        Location blockLocation = block.getLocation();
        ItemStack item = e.getItem();
        Validate.notNull((Object)((Object)this.glassCutter), (String)"Can not be null");
        if (SlimefunTag.GLASS.isTagged(blockType) && this.glassCutter.isItem(item) && !this.glassCutter.isDisabled() && Slimefun.getProtectionManager().hasPermission((OfflinePlayer)e.getPlayer(), blockLocation, Interaction.BREAK_BLOCK)) {
            e.setCancelled(true);
            SlimefunItem slimefunItem = BlockStorage.check((Block)block);
            if (slimefunItem == null && ((Rechargeable)SlimefunItem.getByItem((ItemStack)item)).removeItemCharge(item, 0.5f)) {
                blockLocation.getWorld().dropItemNaturally(blockLocation, new ItemStack(blockType));
                block.setType(Material.AIR);
                e.getPlayer().playSound(block.getLocation(), Sound.BLOCK_GLASS_HIT, SoundCategory.BLOCKS, 1.5f, 1.0f);
            }
        }
    }

    public void checkAndConsume(@Nonnull Player p, @Nullable FoodLevelChangeEvent e) {
        for (ItemStack item : p.getInventory().getContents()) {
            Validate.notNull((Object)((Object)this.foodSynth), (String)"Can not be null");
            if (!this.foodSynth.isItem(item) || !this.foodSynth.removeItemCharge(item, 5.0f)) continue;
            p.playSound(p.getLocation(), Sound.ENTITY_GENERIC_EAT, 1.5f, 1.0f);
            p.setFoodLevel(20);
            p.setSaturation(5.0f);
            if (e == null) break;
            e.setFoodLevel(20);
            break;
        }
    }
}

