/*
 * Decompiled with CFR 0.152.
 */
package dev.j3fftw.litexpansion.machine;

import dev.j3fftw.litexpansion.Items;
import dev.j3fftw.litexpansion.extrautils.interfaces.InventoryBlock;
import dev.j3fftw.litexpansion.machine.api.PoweredMachine;
import dev.j3fftw.litexpansion.utils.BlockMenuPresetTest;
import dev.j3fftw.litexpansion.uumatter.UUMatter;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;

public class UUCrafter
extends SlimefunItem
implements InventoryBlock,
EnergyNetComponent,
PoweredMachine {
    public static final int ENERGY_CONSUMPTION = 200;
    public static final int CAPACITY = 600;
    public static final int INPUT_SLOT = 19;
    public static final int OUTPUT_SLOT = 25;
    public static final int[] CRAFTING_SLOTS = new int[]{12, 13, 14, 21, 22, 23, 30, 31, 32};
    public static final int START_STOP = 40;
    public static final CustomItemStack RUNNING = new CustomItemStack(Material.GREEN_STAINED_GLASS_PANE, ChatColor.GRAY + "Click to stop", new String[0]);
    public static final CustomItemStack NOT_RUNNING = new CustomItemStack(Material.RED_STAINED_GLASS_PANE, ChatColor.GRAY + "Click to start", new String[0]);
    protected static final Map<Location, Boolean> whatIsRunning = new HashMap<Location, Boolean>();

    public UUCrafter() {
        super(Items.LITEXPANSION, Items.UU_CRAFTER, RecipeType.ENHANCED_CRAFTING_TABLE, new ItemStack[]{SlimefunItems.ADVANCED_CIRCUIT_BOARD, SlimefunItems.REINFORCED_PLATE, SlimefunItems.ADVANCED_CIRCUIT_BOARD, SlimefunItems.REINFORCED_PLATE, Items.MACHINE_BLOCK, SlimefunItems.REINFORCED_PLATE, SlimefunItems.ADVANCED_CIRCUIT_BOARD, SlimefunItems.REINFORCED_PLATE, SlimefunItems.ADVANCED_CIRCUIT_BOARD});
        this.setup();
        this.addItemHandler(new ItemHandler[]{new BlockBreakHandler(false, false){

            public void onPlayerBreak(BlockBreakEvent event, ItemStack item, List<ItemStack> drops) {
                BlockMenu blockMenu = BlockStorage.getInventory((Block)event.getBlock());
                if (blockMenu != null) {
                    blockMenu.dropItems(blockMenu.getLocation(), new int[]{19, 25});
                    blockMenu.dropItems(blockMenu.getLocation(), CRAFTING_SLOTS);
                }
            }
        }});
    }

    public void preRegister() {
        this.addItemHandler(new ItemHandler[]{new BlockTicker(){

            public void tick(Block b, SlimefunItem sf, Config data) {
                UUCrafter.this.tick(b);
            }

            public boolean isSynchronized() {
                return false;
            }
        }});
    }

    private void tick(Block block) {
        BlockMenu blockMenu = BlockStorage.getInventory((Block)block);
        if (blockMenu == null) {
            return;
        }
        if (!whatIsRunning.get(block.getLocation()).booleanValue()) {
            return;
        }
        Object[] itemStacks = new ItemStack[9];
        int i = 0;
        for (int slot : CRAFTING_SLOTS) {
            itemStacks[i] = blockMenu.getItemInSlot(slot);
            ++i;
        }
        Object object = UUMatter.INSTANCE.getRecipes().entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            if (!Arrays.equals((Object[])entry.getValue(), itemStacks)) continue;
            int amount = 9;
            for (ItemStack recipeStack : (ItemStack[])entry.getValue()) {
                if (recipeStack != null) continue;
                --amount;
            }
            ItemStack output = ((ItemStack)entry.getKey()).clone();
            if (blockMenu.getItemInSlot(19).getAmount() < amount || !blockMenu.fits(output, new int[]{25})) break;
            blockMenu.pushItem(output, new int[]{25});
            blockMenu.consumeItem(19, amount);
            break;
        }
    }

    public void setup() {
        new BlockMenuPresetTest(this.getId(), "&8UU Crafter", this);
    }

    public void onNewInstance(BlockMenu menu, Block block) {
        String isRunningString = BlockStorage.getLocationInfo((Location)block.getLocation(), (String)"RUNNING");
        boolean isRunning = false;
        if (isRunningString != null) {
            isRunning = Boolean.parseBoolean(isRunningString);
        }
        whatIsRunning.put(block.getLocation(), isRunning);
        menu.replaceExistingItem(40, (ItemStack)(isRunning ? RUNNING : NOT_RUNNING));
        menu.addMenuClickHandler(40, (p, slot, item, action) -> {
            this.toggleRunning(menu, block);
            return false;
        });
    }

    public void toggleRunning(BlockMenu blockMenu, Block block) {
        boolean setTo = whatIsRunning.get(block.getLocation()) == false;
        BlockStorage.addBlockInfo((Block)block, (String)"RUNNING", (String)String.valueOf(setTo));
        whatIsRunning.put(block.getLocation(), setTo);
        CustomItemStack itemStack = setTo ? RUNNING : NOT_RUNNING;
        blockMenu.replaceExistingItem(40, (ItemStack)itemStack);
    }

    @Nonnull
    public EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.CONSUMER;
    }

    public int getCapacity() {
        return 600;
    }

    @Override
    public int getDefaultEnergyConsumption() {
        return 200;
    }

    @Override
    public int[] getInputSlots() {
        return new int[]{19};
    }

    @Override
    public int[] getOutputSlots() {
        return new int[]{25};
    }
}

