/*
 * Decompiled with CFR 0.152.
 */
package dev.j3fftw.litexpansion.machine.generators;

import dev.j3fftw.litexpansion.Items;
import dev.j3fftw.litexpansion.extrautils.interfaces.InventoryBlock;
import dev.j3fftw.litexpansion.extrautils.utils.Utils;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetProvider;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import javax.annotation.Nonnull;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;

public class AdvancedSolarPanel
extends SlimefunItem
implements InventoryBlock,
EnergyNetProvider {
    private static final int PROGRESS_SLOT = 4;
    private static final CustomItemStack generatingItem = new CustomItemStack(Material.ORANGE_STAINED_GLASS_PANE, "&cNot Generating...", new String[0]);
    public static final int ADVANCED_DAY_RATE = 80;
    public static final int ADVANCED_NIGHT_RATE = 10;
    public static final int ADVANCED_OUTPUT = 320;
    public static final int ADVANCED_STORAGE = 320000;
    public static final int HYBRID_DAY_RATE = 640;
    public static final int HYBRID_NIGHT_RATE = 80;
    public static final int HYBRID_OUTPUT = 1200;
    public static final int HYBRID_STORAGE = 1000000;
    public static final int ULTIMATE_DAY_RATE = 5120;
    public static final int ULTIMATE_NIGHT_RATE = 640;
    public static final int ULTIMATE_OUTPUT = 5120;
    public static final int ULTIMATE_STORAGE = 10000000;
    private final Type type;

    public AdvancedSolarPanel(Type type) {
        super(Items.LITEXPANSION, type.getItem(), RecipeType.ENHANCED_CRAFTING_TABLE, type.getRecipe());
        this.type = type;
        this.createPreset(this, type.getItem().getItemMetaSnapshot().getDisplayName().orElse("&7Solar Panel"), blockMenuPreset -> {
            for (int i = 0; i < 9; ++i) {
                blockMenuPreset.addItem(i, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
            }
            blockMenuPreset.addItem(4, (ItemStack)generatingItem);
        });
    }

    public int getGeneratedOutput(@Nonnull Location l, @Nonnull Config data) {
        BlockMenu inv = BlockStorage.getInventory((Location)l);
        if (inv == null) {
            return 0;
        }
        int stored = this.getCharge(l);
        boolean canGenerate = stored < this.getCapacity();
        Validate.notNull((Object)l.getWorld());
        int rate = canGenerate ? this.getGeneratingAmount(inv.getBlock(), l.getWorld()) : 0;
        String generationType = "&4Unknown";
        if (l.getWorld().getEnvironment() == World.Environment.NETHER) {
            generationType = "&cNether &e(Day)";
        } else if (l.getWorld().getEnvironment() == World.Environment.THE_END) {
            generationType = "&5End &8(Night)";
        } else if (rate == this.type.getDayGenerationRate()) {
            generationType = "&aOverworld &e(Day)";
        } else if (rate == this.type.getNightGenerationRate()) {
            generationType = "&aOverworld &8(Night)";
        }
        if (inv.toInventory() != null && !inv.toInventory().getViewers().isEmpty()) {
            inv.replaceExistingItem(4, (ItemStack)(canGenerate ? new CustomItemStack(Material.GREEN_STAINED_GLASS_PANE, "&aGenerating", new String[]{"", "&bRate: " + generationType, "&7Generating at &6" + Utils.powerFormatAndFadeDecimals(Utils.perTickToPerSecond(rate)) + " J/s &8(" + rate + " J/t)", "", "&7Stored: &6" + Utils.powerFormatAndFadeDecimals((double)stored + (double)rate) + " J"}) : new CustomItemStack(Material.ORANGE_STAINED_GLASS_PANE, "&cNot Generating", new String[]{"", "&7Generator has reached maximum capacity.", "", "&7Stored: &6" + Utils.powerFormatAndFadeDecimals(stored) + " J"})));
        }
        return rate;
    }

    public boolean willExplode(@Nonnull Location l, @Nonnull Config data) {
        return false;
    }

    private int getGeneratingAmount(@Nonnull Block b, @Nonnull World world) {
        if (world.getEnvironment() == World.Environment.NETHER) {
            return this.type.getDayGenerationRate();
        }
        if (world.getEnvironment() == World.Environment.THE_END) {
            return this.type.getNightGenerationRate();
        }
        if (world.isThundering() || world.hasStorm() || world.getTime() >= 13000L || b.getLocation().add(0.0, 1.0, 0.0).getBlock().getLightFromSky() != 15) {
            return this.type.getNightGenerationRate();
        }
        return this.type.getDayGenerationRate();
    }

    @Nonnull
    public EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.GENERATOR;
    }

    public int getCapacity() {
        return this.type.getStorage();
    }

    @Override
    public int[] getInputSlots() {
        return new int[0];
    }

    @Override
    public int[] getOutputSlots() {
        return new int[0];
    }

    public static enum Type {
        ADVANCED(Items.ADVANCED_SOLAR_PANEL, 80, 10, 320, 320000, new ItemStack[]{Items.REINFORCED_GLASS, Items.REINFORCED_GLASS, Items.REINFORCED_GLASS, Items.ADVANCED_ALLOY, SlimefunItems.SOLAR_GENERATOR_4, Items.ADVANCED_ALLOY, SlimefunItems.ADVANCED_CIRCUIT_BOARD, Items.ADVANCED_MACHINE_BLOCK, SlimefunItems.ADVANCED_CIRCUIT_BOARD}),
        HYBRID(Items.HYBRID_SOLAR_PANEL, 640, 80, 1200, 1000000, new ItemStack[]{Items.CARBON_PLATE, new ItemStack(Material.LAPIS_BLOCK), Items.CARBON_PLATE, Items.IRIDIUM_PLATE, Items.ADVANCED_MACHINE_BLOCK, Items.IRIDIUM_PLATE, SlimefunItems.ADVANCED_CIRCUIT_BOARD, Items.IRIDIUM_PLATE, SlimefunItems.ADVANCED_CIRCUIT_BOARD}),
        ULTIMATE(Items.ULTIMATE_SOLAR_PANEL, 5120, 640, 5120, 10000000, new ItemStack[]{Items.HYBRID_SOLAR_PANEL, Items.HYBRID_SOLAR_PANEL, Items.HYBRID_SOLAR_PANEL, Items.HYBRID_SOLAR_PANEL, SlimefunItems.ADVANCED_CIRCUIT_BOARD, Items.HYBRID_SOLAR_PANEL, Items.HYBRID_SOLAR_PANEL, Items.HYBRID_SOLAR_PANEL, Items.HYBRID_SOLAR_PANEL});

        @Nonnull
        private final SlimefunItemStack item;
        private final int dayGenerationRate;
        private final int nightGenerationRate;
        private final int output;
        private final int storage;
        @Nonnull
        private final ItemStack[] recipe;

        @Nonnull
        public SlimefunItemStack getItem() {
            return this.item;
        }

        public int getDayGenerationRate() {
            return this.dayGenerationRate;
        }

        public int getNightGenerationRate() {
            return this.nightGenerationRate;
        }

        public int getOutput() {
            return this.output;
        }

        public int getStorage() {
            return this.storage;
        }

        @Nonnull
        public ItemStack[] getRecipe() {
            return this.recipe;
        }

        private Type(SlimefunItemStack item, int dayGenerationRate, int nightGenerationRate, @Nonnull int output, int storage, ItemStack[] recipe) {
            if (item == null) {
                throw new NullPointerException("item is marked non-null but is null");
            }
            if (recipe == null) {
                throw new NullPointerException("recipe is marked non-null but is null");
            }
            this.item = item;
            this.dayGenerationRate = dayGenerationRate;
            this.nightGenerationRate = nightGenerationRate;
            this.output = output;
            this.storage = storage;
            this.recipe = recipe;
        }
    }
}

