/*
 * Decompiled with CFR 0.152.
 */
package dev.j3fftw.litexpansion.machine;

import dev.j3fftw.litexpansion.Items;
import dev.j3fftw.litexpansion.LiteXpansion;
import dev.j3fftw.litexpansion.extrautils.interfaces.InventoryBlock;
import dev.j3fftw.litexpansion.extrautils.utils.Utils;
import dev.j3fftw.litexpansion.machine.api.PoweredMachine;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.Objects.handlers.ItemHandler;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.cscorelib2.blocks.BlockPosition;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class MassFabricator
extends SlimefunItem
implements InventoryBlock,
EnergyNetComponent,
PoweredMachine {
    public static final RecipeType RECIPE_TYPE = new RecipeType(new NamespacedKey((Plugin)LiteXpansion.getInstance(), "mass_fabricator"), (ItemStack)Items.MASS_FABRICATOR_MACHINE);
    public static final int ENERGY_CONSUMPTION = 16666;
    public static final int CAPACITY = 49998;
    private static final int[] INPUT_SLOTS = new int[]{10, 11};
    private static final int OUTPUT_SLOT = 15;
    private static final int PROGRESS_SLOT = 13;
    private static final int PROGRESS_AMOUNT = 200;
    private static final Map<BlockPosition, Integer> progress = new HashMap<BlockPosition, Integer>();
    private static final CustomItem progressItem = new CustomItem(Items.UU_MATTER.getType(), "&7Progress", new String[0]);
    private static final ItemStack plate = SlimefunItems.REINFORCED_PLATE;
    private static final ItemStack circuitBoard = SlimefunItems.ADVANCED_CIRCUIT_BOARD;

    public MassFabricator() {
        super(Items.LITEXPANSION, Items.MASS_FABRICATOR_MACHINE, RecipeType.ENHANCED_CRAFTING_TABLE, new ItemStack[]{plate, circuitBoard, plate, circuitBoard, Items.MACHINE_BLOCK, circuitBoard, plate, circuitBoard, plate});
        this.setupInv();
    }

    private void setupInv() {
        this.createPreset(this, "&5Mass Fabricator", blockMenuPreset -> {
            for (int i = 0; i < 27; ++i) {
                if (i == INPUT_SLOTS[0] || i == INPUT_SLOTS[1]) continue;
                blockMenuPreset.addItem(i, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
            }
            Utils.putOutputSlot(blockMenuPreset, 15);
            blockMenuPreset.addItem(13, (ItemStack)progressItem);
            blockMenuPreset.addMenuClickHandler(13, ChestMenuUtils.getEmptyClickHandler());
        });
    }

    public void preRegister() {
        this.addItemHandler(new ItemHandler[]{new BlockTicker(){

            public void tick(Block b, SlimefunItem sf, Config data) {
                MassFabricator.this.tick(b);
            }

            public boolean isSynchronized() {
                return false;
            }
        }});
    }

    private void tick(@Nonnull Block b) {
        BlockMenu inv = BlockStorage.getInventory((Block)b);
        if (inv == null) {
            return;
        }
        ItemStack input = inv.getItemInSlot(INPUT_SLOTS[0]);
        ItemStack input2 = inv.getItemInSlot(INPUT_SLOTS[1]);
        ItemStack output = inv.getItemInSlot(15);
        if (!(output == null || output.getType() == Items.UU_MATTER.getType() && output.getAmount() != output.getMaxStackSize() && Items.UU_MATTER.getItem().isItem(output))) {
            return;
        }
        if (!Items.SCRAP.getItem().isItem(input)) {
            input = null;
        }
        if (!Items.SCRAP.getItem().isItem(input2)) {
            input2 = null;
        }
        if (input == null && input2 == null) {
            return;
        }
        BlockPosition pos = new BlockPosition(b.getWorld(), b.getX(), b.getY(), b.getZ());
        int currentProgress = progress.getOrDefault(pos, 0);
        if (!this.takePower(b)) {
            return;
        }
        if (currentProgress != 200) {
            if (input != null) {
                inv.consumeItem(INPUT_SLOTS[0]);
            } else {
                inv.consumeItem(INPUT_SLOTS[1]);
            }
            progress.put(pos, ++currentProgress);
            ChestMenuUtils.updateProgressbar((ChestMenu)inv, (int)13, (int)(200 - currentProgress), (int)200, (ItemStack)progressItem);
        } else {
            if (output != null && output.getAmount() > 0) {
                output.setAmount(output.getAmount() + 1);
            } else {
                inv.replaceExistingItem(15, Items.UU_MATTER.clone());
            }
            progress.remove(pos);
            ChestMenuUtils.updateProgressbar((ChestMenu)inv, (int)13, (int)200, (int)200, (ItemStack)progressItem);
        }
    }

    private boolean takePower(@Nonnull Block b) {
        if (this.getCharge(b.getLocation()) < this.getFinalEnergyConsumption()) {
            return false;
        }
        this.removeCharge(b.getLocation(), this.getFinalEnergyConsumption());
        return true;
    }

    @Nonnull
    public EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.CONSUMER;
    }

    public int getCapacity() {
        return 49998;
    }

    @Override
    public int[] getInputSlots() {
        return INPUT_SLOTS;
    }

    @Override
    public int[] getOutputSlots() {
        return new int[]{15};
    }

    @Override
    public int getDefaultEnergyConsumption() {
        return 16666;
    }
}

