/*
 * Decompiled with CFR 0.152.
 */
package dev.j3fftw.litexpansion.items;

import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.utils.PatternUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.ChatColors;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public interface PassiveElectricRemoval {
    public static final String LORE_PREFIX = ChatColors.color((String)"&8\u21e8 &e\u26a1 &7");
    public static final Pattern REGEX = Pattern.compile(ChatColors.color((String)("(&c&o)?" + LORE_PREFIX)) + "[0-9.]+ / [0-9.]+ J");

    public float getRemovedChargePerTick();

    public float getCapacity();

    public boolean isEnabled(@Nonnull ItemMeta var1);

    public static void tick(@Nonnull ItemStack is, @Nonnull PassiveElectricRemoval per) {
        ItemMeta meta = is.getItemMeta();
        if (per.isEnabled(meta)) {
            float charge = PassiveElectricRemoval.getCharge(meta);
            if (charge == 0.0f) {
                return;
            }
            float newCharge = Math.max(charge - per.getRemovedChargePerTick(), 0.0f);
            PassiveElectricRemoval.setCharge(meta, newCharge, per.getCapacity());
            if (meta instanceof Damageable) {
                double chargePercent = newCharge / per.getCapacity() * 100.0f;
                int percentOfMax = (int)(chargePercent / 100.0 * (double)is.getType().getMaxDurability());
                int damage = Math.max(1, is.getType().getMaxDurability() - percentOfMax);
                ((Damageable)meta).setDamage(damage);
            }
            is.setItemMeta(meta);
        }
    }

    @Deprecated
    public static float getCharge(ItemMeta meta) {
        NamespacedKey key = SlimefunPlugin.getRegistry().getItemChargeDataKey();
        PersistentDataContainer container = meta.getPersistentDataContainer();
        Float value = (Float)container.get(key, PersistentDataType.FLOAT);
        if (value != null) {
            return value.floatValue();
        }
        if (meta.hasLore()) {
            for (String line : meta.getLore()) {
                if (!REGEX.matcher(line).matches()) continue;
                String data = ChatColor.stripColor((String)PatternUtils.SLASH_SEPARATOR.split(line)[0].replace(LORE_PREFIX, ""));
                float loreValue = Float.parseFloat(data);
                container.set(key, PersistentDataType.FLOAT, (Object)Float.valueOf(loreValue));
                return loreValue;
            }
        }
        return 0.0f;
    }

    @Deprecated
    public static void setCharge(@Nonnull ItemMeta meta, float charge, float capacity) {
        BigDecimal decimal = BigDecimal.valueOf(charge).setScale(2, RoundingMode.HALF_UP);
        float value = decimal.floatValue();
        NamespacedKey key = SlimefunPlugin.getRegistry().getItemChargeDataKey();
        meta.getPersistentDataContainer().set(key, PersistentDataType.FLOAT, (Object)Float.valueOf(value));
        List lore = meta.hasLore() ? meta.getLore() : new ArrayList();
        for (int i = 0; i < lore.size(); ++i) {
            String line = (String)lore.get(i);
            if (!REGEX.matcher(line).matches()) continue;
            lore.set(i, LORE_PREFIX + value + " / " + capacity + " J");
            meta.setLore(lore);
            return;
        }
        lore.add(LORE_PREFIX + value + " / " + capacity + " J");
        meta.setLore(lore);
    }
}

