/*
 * Decompiled with CFR 0.152.
 */
package dev.j3fftw.litexpansion.utils;

import dev.j3fftw.litexpansion.utils.Log;
import java.lang.reflect.Field;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class Reflections {
    private Reflections() {
    }

    public static void setStaticField(@Nonnull Class<?> clazz, @Nonnull String fieldName, @Nonnull Object newValue) {
        try {
            Field f = clazz.getDeclaredField(fieldName);
            f.setAccessible(true);
            f.set(null, newValue);
        }
        catch (ReflectiveOperationException e) {
            Log.warn("Failed to change field {} to {} in {}", fieldName, newValue, clazz.getSimpleName());
        }
    }

    public static void setField(@Nullable Object instance, @Nonnull String fieldName, @Nonnull Object newValue) {
        if (instance == null) {
            return;
        }
        try {
            Field f = instance.getClass().getDeclaredField(fieldName);
            f.setAccessible(true);
            f.set(instance, newValue);
        }
        catch (ReflectiveOperationException e) {
            Log.warn("Failed to change field {} to {} in {}", fieldName, newValue, instance.getClass().getSimpleName());
        }
    }
}

