/*
 * Decompiled with CFR 0.152.
 */
package dev.j3fftw.litexpansion;

import dev.j3fftw.litexpansion.Events;
import dev.j3fftw.litexpansion.GlowEnchant;
import dev.j3fftw.litexpansion.ItemSetup;
import dev.j3fftw.litexpansion.Items;
import dev.j3fftw.litexpansion.bstats.Metrics;
import dev.j3fftw.litexpansion.resources.ThoriumResource;
import dev.j3fftw.litexpansion.utils.Constants;
import dev.j3fftw.litexpansion.utils.Reflections;
import dev.j3fftw.litexpansion.uumatter.UUMatter;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.core.researching.Research;
import java.io.File;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.cscorelib2.config.Config;
import me.mrCookieSlime.Slimefun.cscorelib2.updater.GitHubBuildsUpdater;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class LiteXpansion
extends JavaPlugin
implements SlimefunAddon {
    private static LiteXpansion instance;

    public void onEnable() {
        LiteXpansion.setInstance(this);
        if (!new File(this.getDataFolder(), "config.yml").exists()) {
            this.saveDefaultConfig();
        }
        Metrics metrics = new Metrics((Plugin)this, 7111);
        this.setupCustomMetrics(metrics);
        if (this.getConfig().getBoolean("options.auto-update") && this.getDescription().getVersion().startsWith("DEV - ")) {
            new GitHubBuildsUpdater((Plugin)this, this.getFile(), "J3fftw1/LiteXpansion/master").start();
        }
        this.registerEnchantments();
        this.changeSfValues();
        ItemSetup.INSTANCE.init();
        this.getServer().getPluginManager().registerEvents((Listener)new Events(), (Plugin)this);
        UUMatter.INSTANCE.register();
        this.setupResearches();
        new ThoriumResource().register();
    }

    public void onDisable() {
        LiteXpansion.setInstance(null);
    }

    private void registerEnchantments() {
        GlowEnchant glowEnchantment;
        if (!Enchantment.isAcceptingRegistrations()) {
            Reflections.setStaticField(Enchantment.class, "acceptingNew", true);
        }
        if (Enchantment.getByKey((NamespacedKey)(glowEnchantment = new GlowEnchant(Constants.GLOW_ENCHANT, new String[]{"ADVANCED_CIRCUIT", "NANO_BLADE", "GLASS_CUTTER", "LAPOTRON_CRYSTAL", "ADVANCEDLX_SOLAR_HELMET", "HYBRID_SOLAR_HELMET", "ULTIMATE_SOLAR_HELMET", "DIAMOND_DRILL"})).getKey()) == null) {
            Enchantment.registerEnchantment((Enchantment)glowEnchantment);
        }
    }

    private void changeSfValues() {
        SlimefunItem energizedPanel = SlimefunItem.getByID((String)"SOLAR_GENERATOR_3");
        if (energizedPanel != null) {
            Reflections.setField(energizedPanel, "dayEnergy", 64);
            Reflections.setField(energizedPanel, "nightEnergy", 32);
        }
    }

    private void setupResearches() {
        new Research(new NamespacedKey((Plugin)this, "sanitizing_foots"), 696969, "Sanitizing  foots since 2k10", 45).addItems(new ItemStack[]{Items.FOOD_SYNTHESIZER}).register();
        new Research(new NamespacedKey((Plugin)this, "superalloys"), 696970, "Superalloys", 35).addItems(new ItemStack[]{Items.THORIUM, Items.MAG_THOR, Items.IRIDIUM, Items.ADVANCED_ALLOY, Items.MIXED_METAL_INGOT, Items.REFINED_IRON}).register();
        new Research(new NamespacedKey((Plugin)this, "super_hot_fire"), 696971, "Super Hot Fire", 31).addItems(new ItemStack[]{Items.NANO_BLADE, Items.ELECTRIC_CHESTPLATE}).register();
        new Research(new NamespacedKey((Plugin)this, "machinereee"), 696972, "Machinereeeeee", 30).addItems(new ItemStack[]{Items.METAL_FORGE, Items.REFINED_SMELTERY, Items.RUBBER_SYNTHESIZER_MACHINE, Items.MANUAL_MILL, Items.GENERATOR}).register();
        new Research(new NamespacedKey((Plugin)this, "the_better_panel"), 696973, "These are the better panels", 45).addItems(new ItemStack[]{Items.ADVANCED_SOLAR_PANEL, Items.ULTIMATE_SOLAR_PANEL, Items.HYBRID_SOLAR_PANEL}).register();
        new Research(new NamespacedKey((Plugin)this, "does_this_even_matter"), 696974, "Does this even matter", 150).addItems(new ItemStack[]{Items.UU_MATTER, Items.SCRAP, Items.MASS_FABRICATOR_MACHINE, Items.RECYCLER}).register();
        new Research(new NamespacedKey((Plugin)this, "what_a_configuration"), 696975, "What a configuration", 39).addItems(new ItemStack[]{Items.CARGO_CONFIGURATOR}).register();
        new Research(new NamespacedKey((Plugin)this, "platings"), 696976, "Platings", 40).addItems(new ItemStack[]{Items.IRIDIUM_PLATE, Items.COPPER_PLATE, Items.TIN_PLATE, Items.DIAMOND_PLATE, Items.IRON_PLATE, Items.GOLD_PLATE, Items.THORIUM_PLATE}).register();
        new Research(new NamespacedKey((Plugin)this, "rubber"), 696977, "Rubber", 25).addItems(new ItemStack[]{Items.RUBBER}).register();
        new Research(new NamespacedKey((Plugin)this, "circuits"), 696978, "Circuits", 25).addItems(new ItemStack[]{Items.ELECTRONIC_CIRCUIT, Items.ADVANCED_CIRCUIT}).register();
        new Research(new NamespacedKey((Plugin)this, "reinforcement_is_coming"), 696979, "Reinforcement is coming", 15).addItems(new ItemStack[]{Items.REINFORCED_DOOR, Items.REINFORCED_GLASS, Items.REINFORCED_STONE}).register();
        new Research(new NamespacedKey((Plugin)this, "only_glass"), 696980, "Only glass", 40).addItems(new ItemStack[]{Items.GLASS_CUTTER}).register();
        new Research(new NamespacedKey((Plugin)this, "machine_blocks"), 696981, "Machine Blocks", 35).addItems(new ItemStack[]{Items.MACHINE_BLOCK, Items.ADVANCED_MACHINE_BLOCK}).register();
        new Research(new NamespacedKey((Plugin)this, "coal_mesh"), 696982, "Coal mesh", 30).addItems(new ItemStack[]{Items.COAL_DUST, Items.RAW_CARBON_MESH, Items.RAW_CARBON_FIBRE, Items.CARBON_PLATE}).register();
        new Research(new NamespacedKey((Plugin)this, "what_are_these_cables"), 696983, "What are these cables", 25).addItems(new ItemStack[]{Items.UNINSULATED_COPPER_CABLE, Items.COPPER_CABLE, Items.UNINSULATED_COPPER_CABLE, Items.TIN_CABLE}).register();
        new Research(new NamespacedKey((Plugin)this, "triple_a"), 696984, "Triple a", 20).addItems(new ItemStack[]{Items.RE_BATTERY}).register();
        new Research(new NamespacedKey((Plugin)this, "casing"), 696985, "S 340", 20).addItems(new ItemStack[]{Items.TIN_ITEM_CASING, Items.COPPER_ITEM_CASING}).register();
        new Research(new NamespacedKey((Plugin)this, "solar_helmets"), 696986, "More solar helmets", 30).addItems(new ItemStack[]{Items.HYBRID_SOLAR_HELMET, Items.ADVANCED_SOLAR_HELMET, Items.ADVANCEDLX_SOLAR_HELMET, Items.CARBONADO_SOLAR_HELMET, Items.ENERGIZED_SOLAR_HELMET, Items.ULTIMATE_SOLAR_HELMET}).register();
    }

    private void setupCustomMetrics(@Nonnull Metrics metrics) {
        metrics.addCustomChart(new Metrics.AdvancedPie("blocks_placed", () -> {
            HashMap<String, Integer> data = new HashMap<String, Integer>();
            try {
                Class<?> blockStorage = Class.forName("me.mrCookieSlime.Slimefun.api.BlockStorage");
                for (World world : Bukkit.getWorlds()) {
                    BlockStorage storage = BlockStorage.getStorage((World)world);
                    if (storage == null) continue;
                    Field f = blockStorage.getDeclaredField("storage");
                    f.setAccessible(true);
                    Map blocks = (Map)f.get(storage);
                    for (Map.Entry entry : blocks.entrySet()) {
                        SlimefunItem item = SlimefunItem.getByID((String)((Config)entry.getValue()).getString("id"));
                        if (item == null || !(item.getAddon() instanceof LiteXpansion)) continue;
                        data.merge(item.getId(), 1, Integer::sum);
                    }
                }
            }
            catch (ReflectiveOperationException e) {
                this.getLogger().log(Level.WARNING, "Failed to load placed blocks", e);
            }
            return data;
        }));
    }

    @Nonnull
    public JavaPlugin getJavaPlugin() {
        return this;
    }

    public String getBugTrackerURL() {
        return "https://github.com/J3fftw1/LiteXpansion/issues";
    }

    private static void setInstance(LiteXpansion ins) {
        instance = ins;
    }

    public static LiteXpansion getInstance() {
        return instance;
    }
}

