/*
 * Decompiled with CFR 0.152.
 */
package dev.j3fftw.litexpansion.utils;

import dev.j3fftw.litexpansion.LiteXpansion;
import javax.annotation.Nonnull;

public final class Log {
    private Log() {
    }

    public static void info(@Nonnull String message) {
        LiteXpansion.getInstance().getLogger().info(message);
    }

    public static void info(@Nonnull String message, Object ... values) {
        Log.warn(Log.replaceVariablesInMessage(message, values));
    }

    public static void warn(@Nonnull String message) {
        LiteXpansion.getInstance().getLogger().warning(message);
    }

    public static void warn(@Nonnull String message, Object ... values) {
        Log.warn(Log.replaceVariablesInMessage(message, values));
    }

    public static void error(@Nonnull String message) {
        LiteXpansion.getInstance().getLogger().severe(message);
    }

    public static void error(@Nonnull String message, Object ... values) {
        Log.warn(Log.replaceVariablesInMessage(message, values));
    }

    private static String replaceVariablesInMessage(@Nonnull String message, Object ... values) {
        int next;
        int idx = 0;
        int off = 0;
        while ((next = message.indexOf("{}", off)) != -1 && idx != values.length) {
            message = message.substring(0, next) + values[idx++].toString() + message.substring(next + 2);
            off = next + 1;
        }
        return message;
    }
}

