/*
 * Decompiled with CFR 0.152.
 */
package dev.j3fftw.extrautils.interfaces;

import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectableAction;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public interface InventoryBlock {
    public int[] getInputSlots();

    public int[] getOutputSlots();

    default public void createPreset(SlimefunItem item, Consumer<BlockMenuPreset> setup) {
        this.createPreset(item, item.getItemName(), setup);
    }

    default public void createPreset(final SlimefunItem item, String title, final Consumer<BlockMenuPreset> setup) {
        new BlockMenuPreset(item.getId(), title){

            public void init() {
                setup.accept(this);
            }

            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow flow) {
                if (flow == ItemTransportFlow.INSERT) {
                    return InventoryBlock.this.getInputSlots();
                }
                return InventoryBlock.this.getOutputSlots();
            }

            public boolean canOpen(@Nonnull Block block, @Nonnull Player player) {
                return player.hasPermission("slimefun.inventory.bypass") || SlimefunPlugin.getProtectionManager().hasPermission((OfflinePlayer)player, block.getLocation(), ProtectableAction.ACCESS_INVENTORIES) && Slimefun.hasUnlocked((Player)player, (SlimefunItem)item, (boolean)false);
            }
        };
    }
}

