/*
 * Decompiled with CFR 0.152.
 */
package dev.j3fftw.litexpansion;

import dev.j3fftw.litexpansion.Items;
import dev.j3fftw.litexpansion.armor.ElectricChestplate;
import dev.j3fftw.litexpansion.items.FoodSynthesizer;
import dev.j3fftw.litexpansion.items.GlassCutter;
import dev.j3fftw.litexpansion.items.MiningDrill;
import dev.j3fftw.litexpansion.objects.DyeItem;
import dev.j3fftw.litexpansion.utils.Constants;
import dev.j3fftw.litexpansion.utils.Utils;
import dev.j3fftw.litexpansion.weapons.NanoBlade;
import io.github.thebusybiscuit.slimefun4.core.attributes.Rechargeable;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectableAction;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class Events
implements Listener {
    private final NanoBlade nanoBlade = (NanoBlade)Items.NANO_BLADE.getItem();
    private final GlassCutter glassCutter = (GlassCutter)Items.GLASS_CUTTER.getItem();
    private final ElectricChestplate electricChestplate = (ElectricChestplate)Items.ELECTRIC_CHESTPLATE.getItem();
    private final FoodSynthesizer foodSynth = (FoodSynthesizer)Items.FOOD_SYNTHESIZER.getItem();
    ArrayList<Material> drillableBlocks = new ArrayList<Material>(Arrays.asList(Material.STONE, Material.COBBLESTONE, Material.ANDESITE, Material.DIORITE, Material.GRANITE, Material.NETHERRACK, Material.END_STONE));

    @EventHandler
    public void onPlayerDamageDeal(EntityDamageByEntityEvent e) {
        Player p;
        ItemStack itemInHand;
        if (e.getDamager() instanceof Player && this.nanoBlade.isItem(itemInHand = (p = (Player)e.getDamager()).getInventory().getItemInMainHand()) && itemInHand.containsEnchantment(Enchantment.getByKey((NamespacedKey)Constants.GLOW_ENCHANT)) && this.nanoBlade.removeItemCharge(itemInHand, 10.0f)) {
            e.setDamage(e.getDamage() * 1.75);
        }
    }

    @EventHandler
    public void onPlayerDamage(EntityDamageEvent e) {
        Player p;
        ItemStack chestplate;
        if (e.getEntity() instanceof Player && ((Player)e.getEntity()).getEquipment() != null && (chestplate = (p = (Player)e.getEntity()).getEquipment().getChestplate()) != null && this.electricChestplate.isItem(chestplate) && this.electricChestplate.removeItemCharge(chestplate, (float)(e.getDamage() / 1.75))) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onHunger(FoodLevelChangeEvent e) {
        Player p = (Player)e.getEntity();
        if (e.getFoodLevel() < p.getFoodLevel()) {
            this.checkAndConsume(p, e);
        }
    }

    @EventHandler
    public void onHungerDamage(EntityDamageEvent e) {
        if (Items.FOOD_SYNTHESIZER == null || Items.FOOD_SYNTHESIZER.getItem().isDisabled() || !(e.getEntity() instanceof Player)) {
            return;
        }
        if (e.getCause() == EntityDamageEvent.DamageCause.STARVATION) {
            this.checkAndConsume((Player)e.getEntity(), null);
        }
    }

    @EventHandler
    public void onDye(PlayerInteractEntityEvent e) {
        ItemStack item = e.getHand() == EquipmentSlot.HAND ? e.getPlayer().getInventory().getItemInMainHand() : e.getPlayer().getInventory().getItemInOffHand();
        if (SlimefunItem.getByItem((ItemStack)item) instanceof DyeItem) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onMiningDrillUse(PlayerInteractEvent e) {
        Block block = e.getClickedBlock();
        if (block == null) {
            return;
        }
        Material blockType = block.getType();
        Location blockLocation = block.getLocation();
        MiningDrill miningDrill = (MiningDrill)SlimefunItem.getByID((String)Items.MINING_DRILL.getItemId());
        if (miningDrill.isItem(e.getItem()) && this.drillableBlocks.contains(blockType) && SlimefunPlugin.getProtectionManager().hasPermission((OfflinePlayer)e.getPlayer(), blockLocation, ProtectableAction.BREAK_BLOCK)) {
            e.setCancelled(true);
            SlimefunItem slimefunItem = BlockStorage.check((Block)block);
            if (slimefunItem == null && ((Rechargeable)SlimefunItem.getByItem((ItemStack)e.getItem())).removeItemCharge(e.getItem(), 0.5f)) {
                BlockBreakEvent newevent = new BlockBreakEvent(block, e.getPlayer());
                Bukkit.getServer().getPluginManager().callEvent((Event)newevent);
                block.setType(Material.AIR);
                e.getPlayer().playSound(blockLocation, Sound.BLOCK_STONE_BREAK, 1.5f, 1.0f);
                if (blockType == Material.STONE) {
                    blockLocation.getWorld().dropItem(blockLocation, new ItemStack(Material.COBBLESTONE));
                } else {
                    blockLocation.getWorld().dropItem(blockLocation, new ItemStack(blockType));
                }
            }
        }
    }

    @EventHandler
    public void onDiamondDrillUse(PlayerInteractEvent e) {
        Block block = e.getClickedBlock();
        if (block == null) {
            return;
        }
        Material blockType = block.getType();
        Location blockLocation = block.getLocation();
        MiningDrill diamondDrill = (MiningDrill)SlimefunItem.getByID((String)Items.DIAMOND_DRILL.getItemId());
        if (diamondDrill.isItem(e.getItem()) && (this.drillableBlocks.contains(blockType) || blockType.equals((Object)Material.OBSIDIAN) || blockType.toString().endsWith("_ORE")) && SlimefunPlugin.getProtectionManager().hasPermission((OfflinePlayer)e.getPlayer(), blockLocation, ProtectableAction.BREAK_BLOCK)) {
            e.setCancelled(true);
            SlimefunItem slimefunItem = BlockStorage.check((Block)block);
            if (slimefunItem == null && ((Rechargeable)SlimefunItem.getByItem((ItemStack)e.getItem())).removeItemCharge(e.getItem(), 1.5f)) {
                BlockBreakEvent newevent = new BlockBreakEvent(block, e.getPlayer());
                Bukkit.getServer().getPluginManager().callEvent((Event)newevent);
                block.setType(Material.AIR);
                e.getPlayer().playSound(blockLocation, Sound.BLOCK_STONE_BREAK, 1.5f, 1.0f);
                if (blockType == Material.STONE) {
                    blockLocation.getWorld().dropItem(blockLocation, new ItemStack(Material.COBBLESTONE));
                } else {
                    blockLocation.getWorld().dropItem(blockLocation, new ItemStack(blockType));
                }
            }
        }
    }

    @EventHandler
    public void onDiamondDrillUpgrade(InventoryClickEvent e) {
        Player p = (Player)e.getWhoClicked();
        MiningDrill diamondDrill = (MiningDrill)SlimefunItem.getByID((String)Items.DIAMOND_DRILL.getItemId());
        if (diamondDrill.isItem(e.getCurrentItem()) && p.getOpenInventory().getType().toString().equals("SMITHING")) {
            e.setCancelled(true);
            Utils.send(p, "&cYou can not upgrade your Diamond Drill!");
        }
    }

    @EventHandler
    public void onGlassCut(PlayerInteractEvent e) {
        Block block = e.getClickedBlock();
        if (block == null) {
            return;
        }
        Material blockType = block.getType();
        Location blockLocation = block.getLocation();
        ItemStack item = e.getItem();
        if ((blockType == Material.GLASS || blockType == Material.GLASS_PANE || blockType.name().endsWith("_GLASS") || blockType.name().endsWith("_GLASS_PANE")) && this.glassCutter.isItem(item) && SlimefunPlugin.getProtectionManager().hasPermission((OfflinePlayer)e.getPlayer(), blockLocation, ProtectableAction.BREAK_BLOCK)) {
            e.setCancelled(true);
            SlimefunItem slimefunItem = BlockStorage.check((Block)block);
            if (slimefunItem == null && ((Rechargeable)SlimefunItem.getByItem((ItemStack)item)).removeItemCharge(item, 0.5f)) {
                blockLocation.getWorld().dropItemNaturally(blockLocation, new ItemStack(blockType));
                block.setType(Material.AIR);
                e.getPlayer().playSound(block.getLocation(), Sound.BLOCK_GLASS_HIT, SoundCategory.BLOCKS, 1.5f, 1.0f);
            }
        }
    }

    public void checkAndConsume(@Nonnull Player p, @Nullable FoodLevelChangeEvent e) {
        for (ItemStack item : p.getInventory().getContents()) {
            if (!this.foodSynth.isItem(item) || !this.foodSynth.removeItemCharge(item, 5.0f)) continue;
            p.playSound(p.getLocation(), Sound.ENTITY_GENERIC_EAT, 1.5f, 1.0f);
            p.setFoodLevel(20);
            p.setSaturation(5.0f);
            if (e == null) break;
            e.setFoodLevel(20);
            break;
        }
    }
}

