/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.api.groups;

import com.balugaq.jeg.api.interfaces.NotDisplayInCheatMode;
import com.balugaq.jeg.api.interfaces.NotDisplayInSurvivalMode;
import com.balugaq.jeg.api.objects.Timer;
import com.balugaq.jeg.api.objects.annotaions.Warn;
import com.balugaq.jeg.api.objects.enums.FilterType;
import com.balugaq.jeg.implementation.JustEnoughGuide;
import com.balugaq.jeg.utils.Debug;
import com.balugaq.jeg.utils.GuideUtil;
import com.balugaq.jeg.utils.ItemStackUtil;
import com.balugaq.jeg.utils.JEGVersionedItemFlag;
import com.balugaq.jeg.utils.Lang;
import com.balugaq.jeg.utils.LocalHelper;
import com.balugaq.jeg.utils.ReflectionUtil;
import com.balugaq.jeg.utils.SlimefunOfficialSupporter;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.items.groups.FlexItemGroup;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.core.guide.GuideHistory;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuide;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideImplementation;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideMode;
import io.github.thebusybiscuit.slimefun4.core.multiblocks.MultiBlockMachine;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.libraries.dough.chat.ChatInput;
import io.github.thebusybiscuit.slimefun4.libraries.dough.collections.RandomizedSet;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.ItemUtils;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.lang.invoke.CallSite;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AContainer;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

@NotDisplayInSurvivalMode
@NotDisplayInCheatMode
public class SearchGroup
extends FlexItemGroup {
    @Deprecated
    public static final Integer ACONTAINER_OFFSET = 50000;
    public static final Integer EN_THRESHOLD = 2;
    public static final Integer MAX_FIX_TIMES = 3;
    public static final String SPLIT = " ";
    @Warn(reason="No longer using it in EN version")
    public static final Map<Character, Reference<Set<SlimefunItem>>> CACHE = new HashMap<Character, Reference<Set<SlimefunItem>>>();
    @Warn(reason="No longer using it in EN version")
    public static final Map<Character, Reference<Set<SlimefunItem>>> CACHE2 = new HashMap<Character, Reference<Set<SlimefunItem>>>();
    public static final List<String> EN_WORDS = new ArrayList<String>();
    public static final Map<String, List<String>> EN_CACHE_ROLLBACK = new HashMap<String, List<String>>();
    public static final Map<String, Reference<Set<String>>> SPECIAL_CACHE = new HashMap<String, Reference<Set<String>>>();
    public static final Map<String, Reference<Set<SlimefunItem>>> EN_CACHE = new HashMap<String, Reference<Set<SlimefunItem>>>();
    public static final Map<String, Reference<Set<SlimefunItem>>> EN_CACHE2 = new HashMap<String, Reference<Set<SlimefunItem>>>();
    @Warn(reason="No longer using it in EN version")
    public static final Set<String> SHARED_CHARS = new HashSet<String>();
    public static final Set<String[]> SHARED_WORDS = new HashSet<String[]>();
    public static final Boolean SHOW_HIDDEN_ITEM_GROUPS = SlimefunOfficialSupporter.isShowHiddenItemGroups();
    public static final Integer DEFAULT_HASH_SIZE = 5000;
    public static final Map<SlimefunItem, Integer> ENABLED_ITEMS = new HashMap<SlimefunItem, Integer>(DEFAULT_HASH_SIZE);
    public static final Set<SlimefunItem> AVAILABLE_ITEMS = new HashSet<SlimefunItem>(DEFAULT_HASH_SIZE);
    public static final Integer BACK_SLOT = 1;
    public static final Integer SEARCH_SLOT = 7;
    public static final Integer PREVIOUS_SLOT = 46;
    public static final Integer NEXT_SLOT = 52;
    public static final Integer[] BORDER = new Integer[]{0, 2, 3, 4, 5, 6, 8, 45, 47, 48, 49, 50, 51, 53};
    public static final Integer[] MAIN_CONTENT = new Integer[]{9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44};
    public static final JavaPlugin JAVA_PLUGIN = JustEnoughGuide.getInstance();
    @NotNull
    public static Boolean LOADED = false;
    public final SlimefunGuideImplementation implementation;
    public final Player player;
    public final String searchTerm;
    public final Boolean pinyin;
    @NotNull
    public final Integer page;
    public final List<SlimefunItem> slimefunItemList;
    public final boolean re_search_when_cache_failed;
    public Map<Integer, SearchGroup> pageMap = new LinkedHashMap<Integer, SearchGroup>();

    public SearchGroup(SlimefunGuideImplementation implementation, @NotNull Player player, @NotNull String searchTerm, boolean pinyin) {
        this(implementation, player, searchTerm, pinyin, true);
    }

    public SearchGroup(SlimefunGuideImplementation implementation, @NotNull Player player, @NotNull String searchTerm, boolean pinyin, boolean re_search_when_cache_failed) {
        super(new NamespacedKey((Plugin)JAVA_PLUGIN, "jeg_search_group_" + String.valueOf(UUID.randomUUID())), new ItemStack(Material.BARRIER));
        if (!LOADED.booleanValue()) {
            SearchGroup.init();
        }
        this.page = 1;
        this.searchTerm = searchTerm;
        this.pinyin = pinyin;
        this.player = player;
        this.re_search_when_cache_failed = re_search_when_cache_failed;
        this.implementation = implementation;
        this.slimefunItemList = this.filterItems(player, searchTerm, pinyin);
        this.pageMap.put(1, this);
    }

    protected SearchGroup(@NotNull SearchGroup searchGroup, int page) {
        super(searchGroup.key, new ItemStack(Material.BARRIER));
        this.page = page;
        this.searchTerm = searchGroup.searchTerm;
        this.pinyin = searchGroup.pinyin;
        this.player = searchGroup.player;
        this.re_search_when_cache_failed = searchGroup.re_search_when_cache_failed;
        this.implementation = searchGroup.implementation;
        this.slimefunItemList = searchGroup.slimefunItemList;
        this.pageMap.put(page, this);
    }

    @ParametersAreNonnullByDefault
    public static boolean isSearchFilterApplicable(Player player, SlimefunItem slimefunItem, String searchTerm, boolean pinyin) {
        if (slimefunItem == null) {
            return false;
        }
        String itemName = ChatColor.stripColor((String)SlimefunOfficialSupporter.getTranslatedItemName(player, slimefunItem)).toLowerCase(Locale.ROOT);
        return SearchGroup.isSearchFilterApplicable(itemName, searchTerm.toLowerCase(), pinyin);
    }

    @ParametersAreNonnullByDefault
    public static boolean isSearchFilterApplicable(Player player, ItemStack itemStack, String searchTerm, boolean pinyin) {
        if (itemStack == null) {
            return false;
        }
        String itemName = ChatColor.stripColor((String)ItemUtils.getItemName((ItemStack)SlimefunOfficialSupporter.translateItem(player, itemStack))).toLowerCase(Locale.ROOT);
        return SearchGroup.isSearchFilterApplicable(itemName, searchTerm.toLowerCase(), pinyin);
    }

    @ParametersAreNonnullByDefault
    public static boolean isSearchFilterApplicable(String itemName, String searchTerm, boolean pinyin) {
        if (itemName.isEmpty()) {
            return false;
        }
        boolean result = itemName.contains(searchTerm);
        return result;
    }

    @NotNull
    public static List<SlimefunItem> filterItems(Player player, @NotNull FilterType filterType, @NotNull String filterValue, boolean pinyin, @NotNull List<SlimefunItem> items) {
        String lowerFilterValue = filterValue.toLowerCase();
        return items.stream().filter(item -> filterType.getFilter().apply(player, (SlimefunItem)item, lowerFilterValue, pinyin)).toList();
    }

    @NotNull
    public static Set<SlimefunItem> filterItems(Player player, @NotNull FilterType filterType, @NotNull String filterValue, boolean pinyin, @NotNull Set<SlimefunItem> items) {
        String lowerFilterValue = filterValue.toLowerCase();
        return items.stream().filter(item -> filterType.getFilter().apply(player, (SlimefunItem)item, lowerFilterValue, pinyin)).collect(Collectors.toSet());
    }

    public static void init() {
        if (!LOADED.booleanValue()) {
            LOADED = true;
            Debug.debug("Initializing Search Group...");
            Timer.start();
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)JAVA_PLUGIN, () -> {
                Map<String, List<String>> map = EN_CACHE_ROLLBACK;
                synchronized (map) {
                    EN_CACHE_ROLLBACK.clear();
                }
                int i = 0;
                for (SlimefunItem item : Slimefun.getRegistry().getEnabledSlimefunItems()) {
                    try {
                        Object r;
                        ENABLED_ITEMS.put(item, i);
                        ++i;
                        if (item.isHidden() && !SHOW_HIDDEN_ITEM_GROUPS.booleanValue() || (r = item.getRecipe()) == null || item.isDisabled()) continue;
                        AVAILABLE_ITEMS.add(item);
                        try {
                            List recipes;
                            String id = item.getId();
                            if (SPECIAL_CACHE.containsKey(id)) continue;
                            HashSet<String> cache = new HashSet<String>();
                            Object Orecipes = ReflectionUtil.getValue(item, "recipes");
                            if (Orecipes == null) {
                                Object object = ReflectionUtil.getValue(item, "material");
                                if (object == null) {
                                    Object ORECIPE_LIST = ReflectionUtil.getValue(item, "RECIPE_LIST");
                                    if (ORECIPE_LIST == null) {
                                        Object object2 = ReflectionUtil.getValue(item, "outputs");
                                        if (object2 == null) {
                                            Object OOUTPUTS = ReflectionUtil.getValue(item, "OUTPUTS");
                                            if (OOUTPUTS == null) continue;
                                            if (OOUTPUTS instanceof ItemStack[]) {
                                                ItemStack[] itemStackArray = (ItemStack[])OOUTPUTS;
                                                if (!SearchGroup.isInstance(item, "StrainerBase")) continue;
                                                for (ItemStack output2 : itemStackArray) {
                                                    cache.add(ItemUtils.getItemName((ItemStack)output2));
                                                }
                                            }
                                        } else if (object2 instanceof Material[]) {
                                            Material[] outputs = (Material[])object2;
                                            if (!SearchGroup.isInstance(item, "Quarry")) continue;
                                            for (Material material : outputs) {
                                                cache.add(ItemUtils.getItemName((ItemStack)new ItemStack(material)));
                                            }
                                        }
                                    } else if (ORECIPE_LIST instanceof List) {
                                        recipes = (List)ORECIPE_LIST;
                                        if (!SearchGroup.isInstance(item, "SingularityConstructor")) continue;
                                        for (Object recipe : recipes) {
                                            SlimefunItem slimefunItem;
                                            SlimefunItemStack slimefunItemStack;
                                            ItemStack input = (ItemStack)ReflectionUtil.getValue(recipe, "input");
                                            if (input != null) {
                                                cache.add(ItemUtils.getItemName((ItemStack)input));
                                            }
                                            if ((slimefunItemStack = (SlimefunItemStack)ReflectionUtil.getValue(recipe, "output")) == null || (slimefunItem = slimefunItemStack.getItem()) == null) continue;
                                            cache.add(slimefunItem.getItemName());
                                        }
                                    }
                                } else {
                                    if (!SearchGroup.isInstance(item, "MaterialGenerator")) continue;
                                    cache.add(ItemUtils.getItemName((ItemStack)new ItemStack((Material)object)));
                                }
                            }
                            if (Orecipes instanceof SlimefunItemStack[]) {
                                SlimefunItemStack[] slimefunItemStackArray = (SlimefunItemStack[])Orecipes;
                                if (!SearchGroup.isInstance(item, "ResourceSynthesizer")) continue;
                                for (SlimefunItemStack slimefunItemStack : slimefunItemStackArray) {
                                    SlimefunItem slimefunItem2 = slimefunItemStack.getItem();
                                    if (slimefunItem2 == null) continue;
                                    cache.add(slimefunItem2.getItemName());
                                }
                            } else if (Orecipes instanceof EnumMap) {
                                EnumMap recipes3 = (EnumMap)Orecipes;
                                if (!SearchGroup.isInstance(item, "GrowingMachine")) continue;
                                recipes3.values().forEach(obj -> {
                                    ItemStack[] items;
                                    for (ItemStack itemStack : items = (ItemStack[])obj) {
                                        cache.add(ItemUtils.getItemName((ItemStack)itemStack));
                                    }
                                });
                            } else if (Orecipes instanceof List) {
                                recipes = (List)Orecipes;
                                if (!SearchGroup.isInstance(item, "MachineBlock")) continue;
                                for (Object recipe : recipes) {
                                    String[] strings = (String[])ReflectionUtil.getValue(recipe, "strings");
                                    if (strings == null) continue;
                                    for (String string : strings) {
                                        SlimefunItem slimefunItem3 = SlimefunItem.getById((String)string);
                                        if (slimefunItem3 != null) {
                                            cache.add(slimefunItem3.getItemName());
                                            continue;
                                        }
                                        Material material2 = Material.getMaterial((String)string);
                                        if (material2 == null) continue;
                                        cache.add(ItemUtils.getItemName((ItemStack)new ItemStack(material2)));
                                    }
                                    ItemStack itemStack = (ItemStack)ReflectionUtil.getValue(recipe, "output");
                                    if (itemStack == null) continue;
                                    cache.add(ItemUtils.getItemName((ItemStack)itemStack));
                                }
                            }
                            if (cache.isEmpty()) continue;
                            SPECIAL_CACHE.put(id, new SoftReference(cache));
                        }
                        catch (Throwable id) {
                        }
                    }
                    catch (Throwable r) {}
                }
                HashSet<Material> materials = new HashSet<Material>();
                materials.add(Material.COBBLESTONE);
                materials.add(Material.STONE);
                materials.add(Material.SAND);
                materials.add(Material.STONE_BRICKS);
                materials.add(Material.SMOOTH_STONE);
                materials.add(Material.GLASS);
                materials.add(Material.CRACKED_STONE_BRICKS);
                materials.add(Material.GRAVEL);
                materials.add(Material.GRANITE);
                materials.add(Material.DIORITE);
                materials.add(Material.ANDESITE);
                materials.add(Material.POLISHED_GRANITE);
                materials.add(Material.POLISHED_DIORITE);
                materials.add(Material.POLISHED_ANDESITE);
                materials.add(Material.SANDSTONE);
                HashSet<String> cache = new HashSet<String>();
                for (Material material : materials) {
                    cache.add(ItemUtils.getItemName((ItemStack)new ItemStack(material)));
                }
                SPECIAL_CACHE.put("STONEWORKS_FACTORY", new SoftReference(cache));
                SlimefunItem item2 = SlimefunItem.getById((String)"VOID_BIT");
                if (item2 != null) {
                    HashSet<String> cache2 = new HashSet<String>();
                    cache2.add(item2.getItemName());
                    SPECIAL_CACHE.put("VOID_HARVESTER", new SoftReference(cache2));
                }
                try {
                    Class<?> MobDataCardClass = Class.forName("io.github.mooy1.infinityexpansion.items.mobdata.MobDataCard");
                    Map cards = (Map)ReflectionUtil.getStaticValue(MobDataCardClass, "CARDS");
                    if (cards != null) {
                        cards.values().forEach(card -> {
                            RandomizedSet drops = (RandomizedSet)ReflectionUtil.getValue(card, "drops");
                            if (drops == null) {
                                return;
                            }
                            HashSet<String> cache2 = new HashSet<String>();
                            for (ItemStack itemStack : drops.toMap().keySet()) {
                                cache2.add(ItemUtils.getItemName((ItemStack)itemStack));
                            }
                            SPECIAL_CACHE.put(((SlimefunItem)card).getId(), new SoftReference(cache2));
                        });
                    }
                }
                catch (Throwable MobDataCardClass) {
                    // empty catch block
                }
                for (SlimefunItem slimefunItem : AVAILABLE_ITEMS) {
                    try {
                        Set<String> set;
                        Reference<Set<String>> ref2;
                        String id;
                        void var7_21;
                        if (slimefunItem == null) continue;
                        String name = ChatColor.stripColor((String)slimefunItem.getItemName());
                        for (String string : name.split(SPLIT)) {
                            Set<SlimefunItem> set2;
                            String d = string.toLowerCase(Locale.ROOT);
                            if (!EN_WORDS.contains(d)) {
                                EN_WORDS.add(d);
                            }
                            EN_CACHE.putIfAbsent(string, new SoftReference(new HashSet()));
                            Reference<Set<SlimefunItem>> ref = EN_CACHE.get(d);
                            if (ref == null || (set2 = ref.get()) == null) continue;
                            set2.add(slimefunItem);
                        }
                        Object var7_18 = null;
                        if (slimefunItem instanceof AContainer) {
                            AContainer ac = (AContainer)slimefunItem;
                            List list = ac.getDisplayRecipes();
                        } else if (slimefunItem instanceof MultiBlockMachine) {
                            MultiBlockMachine mb = (MultiBlockMachine)slimefunItem;
                            List list = mb.getDisplayRecipes();
                        }
                        if (var7_21 != null) {
                            for (ItemStack itemStack : var7_21) {
                                if (itemStack == null) continue;
                                String string = ChatColor.stripColor((String)ItemUtils.getItemName((ItemStack)itemStack));
                                for (String s : string.split(SPLIT)) {
                                    String d = s.toLowerCase(Locale.ROOT);
                                    EN_CACHE2.putIfAbsent(d, new SoftReference(new HashSet()));
                                    Reference<Set<SlimefunItem>> ref = EN_CACHE2.get(d);
                                    if (ref != null) {
                                        Set<SlimefunItem> set3 = ref.get();
                                        if (set3 == null) {
                                            set3 = new HashSet<SlimefunItem>();
                                            EN_CACHE2.put(d, new SoftReference<Set<SlimefunItem>>(set3));
                                        }
                                        set3.add(slimefunItem);
                                    }
                                    if (EN_WORDS.contains(s)) continue;
                                    EN_WORDS.add(s);
                                }
                            }
                        }
                        if (!SPECIAL_CACHE.containsKey(id = slimefunItem.getId()) || (ref2 = SPECIAL_CACHE.get(id)) == null || (set = ref2.get()) == null) continue;
                        for (String s : set) {
                            Set<SlimefunItem> set4;
                            String string = s.toLowerCase(Locale.ROOT);
                            EN_CACHE2.putIfAbsent(string, new SoftReference(new HashSet()));
                            Reference<Set<SlimefunItem>> ref = EN_CACHE2.get(string);
                            if (ref == null || (set4 = ref.get()) == null) continue;
                            set4.add(slimefunItem);
                        }
                    }
                    catch (Throwable throwable) {
                    }
                }
                HashSet<SlimefunItemStack> ACCEPTED_ITEMS = new HashSet<SlimefunItemStack>(Arrays.asList(SlimefunItems.BILLON_INGOT, SlimefunItems.SOLDER_INGOT, SlimefunItems.NICKEL_INGOT, SlimefunItems.COBALT_INGOT, SlimefunItems.DURALUMIN_INGOT, SlimefunItems.BRONZE_INGOT, SlimefunItems.BRASS_INGOT, SlimefunItems.ALUMINUM_BRASS_INGOT, SlimefunItems.STEEL_INGOT, SlimefunItems.DAMASCUS_STEEL_INGOT, SlimefunItems.ALUMINUM_BRONZE_INGOT, SlimefunItems.CORINTHIAN_BRONZE_INGOT, SlimefunItems.GILDED_IRON, SlimefunItems.REDSTONE_ALLOY, SlimefunItems.HARDENED_METAL_INGOT, SlimefunItems.REINFORCED_ALLOY_INGOT, SlimefunItems.FERROSILICON, SlimefunItems.ELECTRO_MAGNET, SlimefunItems.ELECTRIC_MOTOR, SlimefunItems.HEATING_COIL, SlimefunItems.SYNTHETIC_EMERALD, SlimefunItems.GOLD_4K, SlimefunItems.GOLD_6K, SlimefunItems.GOLD_8K, SlimefunItems.GOLD_10K, SlimefunItems.GOLD_12K, SlimefunItems.GOLD_14K, SlimefunItems.GOLD_16K, SlimefunItems.GOLD_18K, SlimefunItems.GOLD_20K, SlimefunItems.GOLD_22K, SlimefunItems.GOLD_24K));
                HashSet<String> items = new HashSet<String>();
                for (SlimefunItemStack slimefunItemStack : ACCEPTED_ITEMS) {
                    SlimefunItem slimefunItem = slimefunItemStack.getItem();
                    if (slimefunItem == null) continue;
                    items.add(slimefunItem.getItemName());
                }
                SPECIAL_CACHE.put("SMART_FACTORY", new SoftReference(items));
                SHARED_WORDS.add(new String[]{"storage", "barrel"});
                Debug.debug("Cache initialized.");
                Timer.log();
                Debug.debug("Search Group initialized.");
                Debug.debug("Enabled items: " + ENABLED_ITEMS.size());
                Debug.debug("Available items: " + AVAILABLE_ITEMS.size());
                Debug.debug("Machine blocks cache: " + SPECIAL_CACHE.size());
                Debug.debug("Shared cache: " + SHARED_WORDS.size());
                Debug.debug("EN Words: " + EN_WORDS.size());
                Debug.debug("EN Cache 1 (Keywords): " + EN_CACHE.size());
                Debug.debug("EN Cache 2 (Display Recipes): " + EN_CACHE2.size());
            });
        }
    }

    public static boolean isInstance(@NotNull SlimefunItem item, String classSimpleName) {
        for (Class<?> clazz = item.getClass(); clazz != SlimefunItem.class; clazz = clazz.getSuperclass()) {
            if (!clazz.getSimpleName().equals(classSimpleName)) continue;
            return true;
        }
        return false;
    }

    public boolean isVisible(@NotNull Player player, @NotNull PlayerProfile playerProfile, @NotNull SlimefunGuideMode slimefunGuideMode) {
        return false;
    }

    public void open(@NotNull Player player, @NotNull PlayerProfile playerProfile, @NotNull SlimefunGuideMode slimefunGuideMode) {
        playerProfile.getGuideHistory().add((ItemGroup)this, this.page.intValue());
        this.generateMenu(player, playerProfile, slimefunGuideMode).open(new Player[]{player});
    }

    public void refresh(@NotNull Player player, @NotNull PlayerProfile playerProfile, @NotNull SlimefunGuideMode slimefunGuideMode) {
        GuideUtil.removeLastEntry(playerProfile.getGuideHistory());
        this.open(player, playerProfile, slimefunGuideMode);
    }

    @NotNull
    private ChestMenu generateMenu(@NotNull Player player, @NotNull PlayerProfile playerProfile, @NotNull SlimefunGuideMode slimefunGuideMode) {
        ChestMenu chestMenu = new ChestMenu(Lang.getGuideMessage("searching", "item_name", ChatUtils.crop((ChatColor)ChatColor.WHITE, (String)this.searchTerm)));
        chestMenu.setEmptySlotsClickable(false);
        chestMenu.addMenuOpeningHandler(pl -> pl.playSound(pl.getLocation(), Sound.ITEM_BOOK_PAGE_TURN, 1.0f, 1.0f));
        chestMenu.addItem(BACK_SLOT.intValue(), SlimefunOfficialSupporter.getBackButton(player));
        chestMenu.addMenuClickHandler(BACK_SLOT.intValue(), (pl, s, is, action) -> {
            GuideHistory guideHistory = playerProfile.getGuideHistory();
            if (action.isShiftClicked()) {
                SlimefunGuide.openMainMenu((PlayerProfile)playerProfile, (SlimefunGuideMode)slimefunGuideMode, (int)guideHistory.getMainMenuPage());
            } else {
                guideHistory.goBack(Slimefun.getRegistry().getSlimefunGuide(slimefunGuideMode));
            }
            return false;
        });
        chestMenu.addItem(SEARCH_SLOT.intValue(), ItemStackUtil.getCleanItem(ChestMenuUtils.getSearchButton((Player)player)));
        chestMenu.addMenuClickHandler(SEARCH_SLOT.intValue(), (pl, slot, item, action) -> {
            pl.closeInventory();
            Slimefun.getLocalization().sendMessage((CommandSender)pl, "guide.search.message");
            ChatInput.waitForPlayer((Plugin)JAVA_PLUGIN, (Player)pl, msg -> this.implementation.openSearch(playerProfile, msg, this.implementation.getMode() == SlimefunGuideMode.SURVIVAL_MODE));
            return false;
        });
        chestMenu.addItem(PREVIOUS_SLOT.intValue(), ItemStackUtil.getCleanItem(ChestMenuUtils.getPreviousButton((Player)player, (int)this.page, (int)((this.slimefunItemList.size() - 1) / MAIN_CONTENT.length + 1))));
        chestMenu.addMenuClickHandler(PREVIOUS_SLOT.intValue(), (p, slot, item, action) -> {
            GuideUtil.removeLastEntry(playerProfile.getGuideHistory());
            SearchGroup searchGroup = this.getByPage(Math.max(this.page - 1, 1));
            searchGroup.open(player, playerProfile, slimefunGuideMode);
            return false;
        });
        chestMenu.addItem(NEXT_SLOT.intValue(), ItemStackUtil.getCleanItem(ChestMenuUtils.getNextButton((Player)player, (int)this.page, (int)((this.slimefunItemList.size() - 1) / MAIN_CONTENT.length + 1))));
        chestMenu.addMenuClickHandler(NEXT_SLOT.intValue(), (p, slot, item, action) -> {
            GuideUtil.removeLastEntry(playerProfile.getGuideHistory());
            SearchGroup searchGroup = this.getByPage(Math.min(this.page + 1, (this.slimefunItemList.size() - 1) / MAIN_CONTENT.length + 1));
            searchGroup.open(player, playerProfile, slimefunGuideMode);
            return false;
        });
        Integer[] integerArray = BORDER;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int slot2 = integerArray[i];
            chestMenu.addItem(slot2, ItemStackUtil.getCleanItem(ChestMenuUtils.getBackground()));
            chestMenu.addMenuClickHandler(slot2, ChestMenuUtils.getEmptyClickHandler());
        }
        for (int i = 0; i < MAIN_CONTENT.length; ++i) {
            int index = i + this.page * MAIN_CONTENT.length - MAIN_CONTENT.length;
            if (index >= this.slimefunItemList.size()) continue;
            SlimefunItem slimefunItem = this.slimefunItemList.get(index);
            ItemStack itemstack = ItemStackUtil.getCleanItem((ItemStack)new CustomItemStack(SlimefunOfficialSupporter.translateItem(player, slimefunItem.getItem()), meta -> {
                ItemGroup itemGroup = slimefunItem.getItemGroup();
                List<CallSite> additionLore = List.of("", String.valueOf(ChatColor.DARK_GRAY) + "\u21e8 " + String.valueOf(ChatColor.WHITE) + LocalHelper.getAddonName(itemGroup, slimefunItem.getId()) + " - " + itemGroup.getDisplayName(player));
                if (meta.hasLore() && meta.getLore() != null) {
                    List lore = meta.getLore();
                    lore.addAll(additionLore);
                    meta.setLore(lore);
                } else {
                    meta.setLore(additionLore);
                }
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ENCHANTS, JEGVersionedItemFlag.HIDE_ADDITIONAL_TOOLTIP});
            }));
            chestMenu.addItem(MAIN_CONTENT[i].intValue(), ItemStackUtil.getCleanItem(SlimefunOfficialSupporter.translateItem(player, itemstack)), (pl, slot, itm, action) -> {
                try {
                    if (this.implementation.getMode() != SlimefunGuideMode.SURVIVAL_MODE && (pl.isOp() || pl.hasPermission("slimefun.cheat.items"))) {
                        pl.getInventory().addItem(new ItemStack[]{slimefunItem.getItem().clone()});
                    } else {
                        this.implementation.displayItem(playerProfile, slimefunItem, true);
                    }
                }
                catch (Exception | LinkageError x) {
                    this.printErrorMessage(pl, slimefunItem, x);
                }
                return false;
            });
        }
        return chestMenu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public SearchGroup getByPage(int page) {
        if (this.pageMap.containsKey(page)) {
            return this.pageMap.get(page);
        }
        SearchGroup searchGroup = this.pageMap.get(1);
        synchronized (searchGroup) {
            if (this.pageMap.containsKey(page)) {
                return this.pageMap.get(page);
            }
            SearchGroup searchGroup2 = new SearchGroup(this, page);
            searchGroup2.pageMap = this.pageMap;
            this.pageMap.put(page, searchGroup2);
            return searchGroup2;
        }
    }

    @Deprecated
    @NotNull
    public List<SlimefunItem> getAllMatchedItems(@NotNull Player p, @NotNull String searchTerm, boolean pinyin) {
        return this.filterItems(p, searchTerm, pinyin);
    }

    @ParametersAreNonnullByDefault
    private void printErrorMessage(Player p, Throwable x) {
        p.sendMessage(Lang.getError("internal-error"));
        JustEnoughGuide.getInstance().getLogger().log(Level.SEVERE, Lang.getError("error-occurred"), x);
        JustEnoughGuide.getInstance().getLogger().warning(Lang.getError("trying-fix-guide", "player_name", p.getName()));
        PlayerProfile profile = PlayerProfile.find((OfflinePlayer)p).orElse(null);
        if (profile == null) {
            return;
        }
        GuideUtil.removeLastEntry(profile.getGuideHistory());
    }

    @ParametersAreNonnullByDefault
    private void printErrorMessage(Player p, SlimefunItem item, Throwable x) {
        p.sendMessage(Lang.getError("internal-error"));
        item.error(Lang.getError("item-error"), x);
        JustEnoughGuide.getInstance().getLogger().warning(Lang.getError("trying-fix-guide", "player_name", p.getName()));
        PlayerProfile profile = PlayerProfile.find((OfflinePlayer)p).orElse(null);
        if (profile == null) {
            return;
        }
        GuideUtil.removeLastEntry(profile.getGuideHistory());
    }

    @NotNull
    public List<SlimefunItem> filterItems(@NotNull Player player, @NotNull String searchTerm, boolean pinyin) {
        StringBuilder actualSearchTermBuilder = new StringBuilder();
        String[] split = searchTerm.split(SPLIT);
        HashMap<FilterType, String> filters = new HashMap<FilterType, String>();
        for (String s : split) {
            boolean isFilter = false;
            for (FilterType filterType : FilterType.values()) {
                if (!s.startsWith(filterType.getFlag()) || s.length() <= filterType.getFlag().length()) continue;
                isFilter = true;
                String filterValue = s.substring(filterType.getFlag().length()).replace(".", SPLIT);
                filters.put(filterType, filterValue);
                break;
            }
            if (isFilter) continue;
            actualSearchTermBuilder.append(s).append(SPLIT);
        }
        String actualSearchTerm = actualSearchTermBuilder.toString().trim();
        for (FilterType filterType : FilterType.values()) {
            String flag = filterType.getFlag();
            actualSearchTerm = actualSearchTerm.replaceAll(Pattern.quote(flag), Matcher.quoteReplacement(flag));
        }
        HashSet<SlimefunItem> merge = new HashSet<SlimefunItem>(144);
        Set<SlimefunItem> items = new HashSet<SlimefunItem>(AVAILABLE_ITEMS.stream().filter(item -> item.getItemGroup().isAccessible(player)).toList());
        if (!actualSearchTerm.isBlank()) {
            int beforeSize = merge.size();
            Debug.debug("Search term: " + actualSearchTerm);
            String[] words = actualSearchTerm.split(SPLIT);
            boolean first = true;
            for (String word : words) {
                String language;
                Debug.debug("Word: " + word);
                List<Object> fixedWords = List.of();
                fixedWords = words.length == 1 ? (SearchGroup.isContinuousScriptLanguage(language = Slimefun.getLocalization().getLanguage(player).getId()) ? List.of(word) : SearchGroup.findMostSimilar(word, EN_THRESHOLD)) : SearchGroup.findMostSimilar(word, EN_THRESHOLD);
                if (fixedWords.isEmpty()) {
                    Debug.debug("No fixed words found.");
                    if (!this.re_search_when_cache_failed) continue;
                    merge.addAll(this.filterItems(FilterType.BY_ITEM_NAME, word, false, new HashSet<SlimefunItem>(items)));
                    merge.addAll(this.filterItems(FilterType.BY_DISPLAY_ITEM_NAME, word, false, new HashSet<SlimefunItem>(items)));
                    continue;
                }
                Debug.debug("Fixed words: " + String.valueOf(fixedWords));
                for (String string : fixedWords) {
                    merge.addAll(this.filterItems(FilterType.BY_ITEM_NAME, string, false, new HashSet<SlimefunItem>(items)));
                    merge.addAll(this.filterItems(FilterType.BY_DISPLAY_ITEM_NAME, string, false, new HashSet<SlimefunItem>(items)));
                }
            }
            int afterSize = merge.size();
            if (beforeSize == afterSize) {
                Debug.debug("Same size, fallback to search by name.");
                merge.addAll(this.filterItems(FilterType.BY_ITEM_NAME, actualSearchTerm, false, new HashSet<SlimefunItem>(items)));
                merge.addAll(this.filterItems(FilterType.BY_DISPLAY_ITEM_NAME, actualSearchTerm, false, new HashSet<SlimefunItem>(items)));
            }
            Debug.debug("Filtered items: " + merge.size());
        }
        if (!filters.isEmpty()) {
            for (Map.Entry entry : filters.entrySet()) {
                items = this.filterItems((FilterType)((Object)entry.getKey()), (String)entry.getValue(), pinyin, items);
            }
            merge.addAll(items);
        }
        return merge.stream().sorted((a, b) -> ENABLED_ITEMS.get(a) < ENABLED_ITEMS.get(b) ? -1 : 1).toList();
    }

    @NotNull
    public List<SlimefunItem> filterItems(@NotNull FilterType filterType, @NotNull String filterValue, boolean pinyin, @NotNull List<SlimefunItem> items) {
        String lowerFilterValue = filterValue.toLowerCase();
        return items.stream().filter(item -> filterType.getFilter().apply(this.player, (SlimefunItem)item, lowerFilterValue, pinyin)).toList();
    }

    @NotNull
    public Set<SlimefunItem> filterItems(@NotNull FilterType filterType, @NotNull String filterValue, boolean pinyin, @NotNull Set<SlimefunItem> items) {
        String lowerFilterValue = filterValue.toLowerCase();
        return items.stream().filter(item -> filterType.getFilter().apply(this.player, (SlimefunItem)item, lowerFilterValue, pinyin)).collect(Collectors.toSet());
    }

    public static int levenshteinDistance(String s1, String s2) {
        int i;
        if (s1.length() > s2.length()) {
            String temp = s1;
            s1 = s2;
            s2 = temp;
        }
        int[] distances = new int[s1.length() + 1];
        for (i = 0; i <= s1.length(); ++i) {
            distances[i] = i;
        }
        for (i = 1; i <= s2.length(); ++i) {
            int[] prevDistances = (int[])distances.clone();
            distances[0] = i;
            for (int j = 1; j <= s1.length(); ++j) {
                int cost = s1.charAt(j - 1) == s2.charAt(i - 1) ? 0 : 1;
                distances[j] = Math.min(Math.min(distances[j - 1] + 1, prevDistances[j] + 1), prevDistances[j - 1] + cost);
            }
        }
        return distances[s1.length()];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> findMostSimilar(String target, int threshold) {
        if (EN_CACHE_ROLLBACK.containsKey(target)) {
            return EN_CACHE_ROLLBACK.get(target);
        }
        PriorityQueue<AbstractMap.SimpleEntry<String, Integer>> minHeap = new PriorityQueue<AbstractMap.SimpleEntry<String, Integer>>(5, (a, b) -> (Integer)b.getValue() - (Integer)a.getValue());
        for (String s : EN_WORDS) {
            int distance = SearchGroup.levenshteinDistance(s, target);
            if (distance == 0) {
                return List.of(s);
            }
            if (distance > threshold) continue;
            AbstractMap.SimpleEntry<String, Integer> entry = new AbstractMap.SimpleEntry<String, Integer>(s, distance);
            if (minHeap.size() < MAX_FIX_TIMES) {
                minHeap.offer(entry);
                continue;
            }
            if (distance >= (Integer)((Map.Entry)minHeap.peek()).getValue()) continue;
            minHeap.poll();
            minHeap.offer(entry);
        }
        ArrayList<String> mostSimilar = new ArrayList<String>();
        while (!minHeap.isEmpty()) {
            mostSimilar.add(0, (String)((Map.Entry)minHeap.poll()).getKey());
        }
        Map<String, List<String>> map = EN_CACHE_ROLLBACK;
        synchronized (map) {
            EN_CACHE_ROLLBACK.put(target, mostSimilar);
        }
        return mostSimilar;
    }

    public static boolean isContinuousScriptLanguage(String language) {
        return language.startsWith("zh") || language.startsWith("ja") || language.startsWith("ko") || language.startsWith("th") || language.startsWith("vi") || language.startsWith("he") || language.startsWith("fa");
    }
}

