/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.core.managers;

import com.balugaq.jeg.api.managers.AbstractManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class ConfigManager
extends AbstractManager {
    private final boolean AUTO_UPDATE;
    private final boolean DEBUG;
    private final boolean SURVIVAL_IMPROVEMENTS;
    private final boolean CHEAT_IMPROVEMENTS;
    private final boolean PINYIN_SEARCH;
    private final boolean BOOKMARK;
    private final boolean RTS_SEARCH;
    @NotNull
    private final String SURVIVAL_GUIDE_TITLE;
    @NotNull
    private final String CHEAT_GUIDE_TITLE;
    @NotNull
    private final String LANGUAGE;
    @NotNull
    private final JavaPlugin plugin;

    public ConfigManager(@NotNull JavaPlugin plugin) {
        this.plugin = plugin;
        this.setupDefaultConfig();
        this.AUTO_UPDATE = plugin.getConfig().getBoolean("auto-update", false);
        this.DEBUG = plugin.getConfig().getBoolean("debug", false);
        this.SURVIVAL_IMPROVEMENTS = plugin.getConfig().getBoolean("guide.survival-improvements", true);
        this.CHEAT_IMPROVEMENTS = plugin.getConfig().getBoolean("guide.cheat-improvements", true);
        this.PINYIN_SEARCH = plugin.getConfig().getBoolean("improvements.pinyin-search", false);
        this.BOOKMARK = plugin.getConfig().getBoolean("improvements.bookmark", true);
        this.SURVIVAL_GUIDE_TITLE = plugin.getConfig().getString("guide.survival-guide-title", "&2&lSlimefun Guide &7(Chest GUI) &8Advanced");
        this.CHEAT_GUIDE_TITLE = plugin.getConfig().getString("guide.cheat-guide-title", "&c&l&cSlimefun Guide &4(Cheat Sheet) &8Advanced");
        this.RTS_SEARCH = plugin.getConfig().getBoolean("improvements.rts-search", true);
        this.LANGUAGE = plugin.getConfig().getString("language", "en-US");
    }

    private void setupDefaultConfig() {
        InputStream inputStream = this.plugin.getResource("config.yml");
        File existingFile = new File(this.plugin.getDataFolder(), "config.yml");
        if (inputStream == null) {
            return;
        }
        InputStreamReader reader = new InputStreamReader(inputStream);
        YamlConfiguration resourceConfig = YamlConfiguration.loadConfiguration((Reader)reader);
        YamlConfiguration existingConfig = YamlConfiguration.loadConfiguration((File)existingFile);
        for (String key : resourceConfig.getKeys(false)) {
            this.checkKey((FileConfiguration)existingConfig, (FileConfiguration)resourceConfig, key);
        }
        try {
            existingConfig.save(existingFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @ParametersAreNonnullByDefault
    private void checkKey(FileConfiguration existingConfig, FileConfiguration resourceConfig, String key) {
        Object currentValue = existingConfig.get(key);
        Object newValue = resourceConfig.get(key);
        if (newValue instanceof ConfigurationSection) {
            ConfigurationSection section = (ConfigurationSection)newValue;
            for (String sectionKey : section.getKeys(false)) {
                this.checkKey(existingConfig, resourceConfig, key + "." + sectionKey);
            }
        } else if (currentValue == null) {
            existingConfig.set(key, newValue);
        }
    }

    public boolean isAutoUpdate() {
        return this.AUTO_UPDATE;
    }

    public boolean isDebug() {
        return this.DEBUG;
    }

    public boolean isSurvivalImprovement() {
        return this.SURVIVAL_IMPROVEMENTS;
    }

    public boolean isCheatImprovement() {
        return this.CHEAT_IMPROVEMENTS;
    }

    public boolean isPinyinSearch() {
        return this.PINYIN_SEARCH;
    }

    public boolean isBookmark() {
        return this.BOOKMARK;
    }

    public String getSurvivalGuideTitle() {
        return this.SURVIVAL_GUIDE_TITLE;
    }

    public String getCheatGuideTitle() {
        return this.CHEAT_GUIDE_TITLE;
    }

    public boolean isRTSSearch() {
        return this.RTS_SEARCH;
    }

    public String getLanguage() {
        return this.LANGUAGE;
    }
}

