/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.core.managers;

import com.balugaq.jeg.api.managers.AbstractManager;
import com.balugaq.jeg.implementation.JustEnoughGuide;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerBackpack;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import java.util.Collection;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class RTSBackpackManager
extends AbstractManager {
    private static final int IDENTIFIER_SLOT = 53;
    @Deprecated
    private static final String BACKPACK_NAME = "JEGRTSBackpack";
    private static final NamespacedKey STATUS_KEY = new NamespacedKey((Plugin)JustEnoughGuide.getInstance(), "status");
    private static final String OPEN_STATUS = "open";
    private static final String CLOSE_STATUS = "close";
    @NotNull
    private final Plugin plugin;
    @NotNull
    private final NamespacedKey SERVER_KEY;
    @NotNull
    private final NamespacedKey OWNER_KEY;

    public RTSBackpackManager(@NotNull Plugin plugin) {
        this.plugin = plugin;
        this.SERVER_KEY = new NamespacedKey(plugin, "server");
        this.OWNER_KEY = new NamespacedKey(plugin, "owner");
    }

    public void saveInventoryBackupFor(Player player) {
        PlayerProfile profile = PlayerProfile.find((OfflinePlayer)player).orElse(null);
        if (profile == null) {
            return;
        }
        PlayerBackpack b = null;
        Collection backpacks = profile.getPlayerData().getBackpacks().values();
        if (backpacks != null && !backpacks.isEmpty()) {
            for (PlayerBackpack backpack : backpacks) {
                ItemStack identifierItem;
                if (backpack.getInventory().getContents().length < 54 || (identifierItem = backpack.getInventory().getItem(53)) == null || identifierItem.getType() == Material.AIR || !this.isIdentifier(identifierItem, player)) continue;
                b = backpack;
                break;
            }
        }
        if (b == null) {
            b = profile.createBackpack(54);
        }
        Inventory inventory = b.getInventory();
        this.setIdentifier(player, inventory, 53, true);
        ItemStack[] contents = RTSBackpackManager.getStorageContents(player.getInventory());
        for (int i = 0; i < contents.length; ++i) {
            ItemStack itemStack = contents[i];
            if (itemStack == null || itemStack.getType() == Material.AIR) continue;
            inventory.setItem(i, itemStack);
        }
        profile.save();
    }

    public void clearInventoryFor(Player player) {
        ItemStack[] newContents = new ItemStack[player.getInventory().getStorageContents().length];
        for (int i = 0; i < newContents.length; ++i) {
            newContents[i] = new ItemStack(Material.AIR);
        }
        player.getInventory().setStorageContents(newContents);
    }

    public void restoreInventoryFor(Player player) {
        PlayerProfile profile = PlayerProfile.find((OfflinePlayer)player).orElse(null);
        if (profile == null) {
            return;
        }
        Collection backpacks = profile.getPlayerData().getBackpacks().values();
        if (backpacks == null || backpacks.isEmpty()) {
            return;
        }
        for (PlayerBackpack backpack : backpacks) {
            int i;
            Inventory inventory = backpack.getInventory();
            ItemStack[] contents = inventory.getContents();
            ItemStack identifierItem = inventory.getItem(53);
            if (identifierItem == null || identifierItem.getType() == Material.AIR || !this.isIdentifier(identifierItem, player)) continue;
            if (!this.isOpenIdentifier(identifierItem)) {
                return;
            }
            for (i = 0; i < 36; ++i) {
                ItemStack itemStack = contents[i];
                if (itemStack == null || itemStack.getType() == Material.AIR) {
                    player.getInventory().setItem(i, new ItemStack(Material.AIR));
                    continue;
                }
                player.getInventory().setItem(i, itemStack.clone());
            }
            for (i = 0; i < contents.length; ++i) {
                if (i == 53) continue;
                backpack.getInventory().setItem(i, new ItemStack(Material.AIR));
            }
            this.setIdentifier(player, backpack.getInventory(), 53, false);
            profile.save();
            break;
        }
    }

    public void setIdentifier(Player player, Inventory inventory, int slot, boolean open) {
        inventory.setItem(slot, this.getIdentifierItem(player, open));
    }

    public ItemStack getIdentifierItem(Player player, boolean open) {
        return new CustomItemStack((ItemStack)new CustomItemStack(Material.DIRT, "[RTS]", new String[]{"[RTS]", "[RTS]", "[RTS]", UUID.randomUUID().toString()}), meta -> {
            meta.getPersistentDataContainer().set(this.OWNER_KEY, PersistentDataType.STRING, (Object)player.getUniqueId().toString());
            meta.getPersistentDataContainer().set(this.SERVER_KEY, PersistentDataType.STRING, (Object)JustEnoughGuide.getServerUUID().toString());
            if (open) {
                meta.getPersistentDataContainer().set(STATUS_KEY, PersistentDataType.STRING, (Object)OPEN_STATUS);
            } else {
                meta.getPersistentDataContainer().set(STATUS_KEY, PersistentDataType.STRING, (Object)CLOSE_STATUS);
            }
        });
    }

    public boolean isIdentifier(ItemStack item, Player player) {
        if (item == null || item.getType() == Material.AIR) {
            return false;
        }
        String owner = (String)item.getItemMeta().getPersistentDataContainer().get(this.OWNER_KEY, PersistentDataType.STRING);
        if (owner == null) {
            return false;
        }
        if (!owner.equals(player.getUniqueId().toString())) {
            return false;
        }
        String serverUUID = (String)item.getItemMeta().getPersistentDataContainer().get(this.SERVER_KEY, PersistentDataType.STRING);
        if (serverUUID == null) {
            return false;
        }
        return serverUUID.equals(JustEnoughGuide.getServerUUID().toString());
    }

    public boolean isOpenIdentifier(ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return false;
        }
        String status = (String)item.getItemMeta().getPersistentDataContainer().get(STATUS_KEY, PersistentDataType.STRING);
        if (status == null) {
            return false;
        }
        return status.equals(OPEN_STATUS);
    }

    public static ItemStack[] getStorageContents(PlayerInventory inventory) {
        ItemStack[] contents = new ItemStack[36];
        for (int i = 0; i < 36; ++i) {
            ItemStack itemStack;
            contents[i] = itemStack = inventory.getItem(i);
        }
        return contents;
    }

    @NotNull
    @Generated
    public Plugin getPlugin() {
        return this.plugin;
    }

    @NotNull
    @Generated
    public NamespacedKey getSERVER_KEY() {
        return this.SERVER_KEY;
    }

    @NotNull
    @Generated
    public NamespacedKey getOWNER_KEY() {
        return this.OWNER_KEY;
    }
}

