/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.api.objects.enums;

import com.balugaq.jeg.api.groups.SearchGroup;
import com.balugaq.jeg.utils.LocalHelper;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.core.multiblocks.MultiBlockMachine;
import java.lang.ref.Reference;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AContainer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public enum FilterType {
    BY_RECIPE_ITEM_NAME("#", (player, item, lowerFilterValue, pinyin) -> {
        ItemStack[] recipe = item.getRecipe();
        if (recipe == null) {
            return false;
        }
        for (ItemStack itemStack : recipe) {
            if (!SearchGroup.isSearchFilterApplicable(itemStack, lowerFilterValue, false)) continue;
            return true;
        }
        return false;
    }),
    BY_RECIPE_TYPE_NAME("$", (player, item, lowerFilterValue, pinyin) -> {
        ItemStack recipeTypeIcon = item.getRecipeType().getItem(player);
        if (recipeTypeIcon == null) {
            return false;
        }
        return SearchGroup.isSearchFilterApplicable(recipeTypeIcon, lowerFilterValue, false);
    }),
    BY_DISPLAY_ITEM_NAME("%", (player, item, lowerFilterValue, pinyin) -> {
        Set<String> cache;
        String id;
        Reference<Set<String>> ref;
        List display = null;
        if (item instanceof AContainer) {
            AContainer ac = (AContainer)item;
            display = ac.getDisplayRecipes();
        } else if (item instanceof MultiBlockMachine) {
            MultiBlockMachine mb = (MultiBlockMachine)item;
            display = mb.getDisplayRecipes();
        }
        if (display != null) {
            try {
                for (ItemStack itemStack : display) {
                    if (!SearchGroup.isSearchFilterApplicable(itemStack, lowerFilterValue, false)) continue;
                    return true;
                }
            }
            catch (Throwable ignored) {
                return false;
            }
        }
        if ((ref = SearchGroup.SPECIAL_CACHE.get(id = item.getId())) != null && (cache = ref.get()) != null) {
            for (String s : cache) {
                if (!SearchGroup.isSearchFilterApplicable(s, lowerFilterValue, false)) continue;
                return true;
            }
        }
        return false;
    }),
    BY_ADDON_NAME("@", (player, item, lowerFilterValue, pinyin) -> {
        SlimefunAddon addon = item.getAddon();
        String localAddonName = LocalHelper.getAddonName(addon, item.getId()).toLowerCase();
        String originModName = (addon == null ? "Slimefun" : addon.getName()).toLowerCase();
        if (localAddonName.contains((CharSequence)lowerFilterValue) || originModName.contains((CharSequence)lowerFilterValue)) {
            return true;
        }
        return false;
    }),
    BY_ITEM_NAME("!", (player, item, lowerFilterValue, pinyin) -> {
        if (SearchGroup.isSearchFilterApplicable(item, lowerFilterValue, (boolean)pinyin)) {
            return true;
        }
        return false;
    }),
    BY_MATERIAL_NAME("~", (player, item, lowerFilterValue, pinyin) -> {
        if (item.getItem().getType().name().toLowerCase().contains((CharSequence)lowerFilterValue)) {
            return true;
        }
        return false;
    });

    private final String flag;
    private final DiFunction<Player, SlimefunItem, String, Boolean, Boolean> filter;

    private FilterType(String flag, DiFunction<Player, SlimefunItem, String, Boolean, Boolean> filter) {
        this.flag = flag;
        this.filter = filter;
    }

    @Generated
    public String getFlag() {
        return this.flag;
    }

    @Generated
    public DiFunction<Player, SlimefunItem, String, Boolean, Boolean> getFilter() {
        return this.filter;
    }

    public static interface DiFunction<A, B, C, D, R> {
        public R apply(A var1, B var2, C var3, D var4);
    }
}

