/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.core.commands;

import com.balugaq.jeg.api.groups.SearchGroup;
import com.balugaq.jeg.api.interfaces.JEGCommand;
import com.balugaq.jeg.utils.Lang;
import java.util.List;
import lombok.Generated;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class ReloadCommand
implements JEGCommand {
    private final Plugin plugin;

    public ReloadCommand(Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    @NotNull
    public List<String> onTabCompleteRaw(@NotNull CommandSender sender, @NotNull @NotNull String @NotNull [] args) {
        switch (args.length) {
            case 1: {
                return List.of("reload");
            }
        }
        return List.of();
    }

    @Override
    public boolean canCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull @NotNull String @NotNull [] args) {
        return sender.isOp() && args.length == 1 && "reload".equalsIgnoreCase(args[0]);
    }

    @Override
    public void onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        this.onReload(sender);
    }

    private void onReload(@NotNull CommandSender sender) {
        sender.sendMessage(Lang.getCommandMessage("reload", "start"));
        try {
            if (this.plugin == null) {
                sender.sendMessage(Lang.getCommandMessage("reload", "precheck-failed"));
                return;
            }
            this.plugin.onDisable();
            this.plugin.onEnable();
            this.plugin.reloadConfig();
            SearchGroup.LOADED = false;
            SearchGroup.init();
            sender.sendMessage(Lang.getCommandMessage("reload", "success"));
        }
        catch (Throwable e) {
            sender.sendMessage(Lang.getCommandMessage("reload", "failed"));
            e.printStackTrace();
            return;
        }
    }

    @Generated
    public Plugin getPlugin() {
        return this.plugin;
    }
}

