/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.implementation.guide;

import com.balugaq.jeg.api.groups.RTSSearchGroup;
import com.balugaq.jeg.api.groups.SearchGroup;
import com.balugaq.jeg.api.interfaces.BookmarkRelocation;
import com.balugaq.jeg.api.interfaces.DisplayInSurvivalMode;
import com.balugaq.jeg.api.interfaces.JEGSlimefunGuideImplementation;
import com.balugaq.jeg.api.interfaces.NotDisplayInSurvivalMode;
import com.balugaq.jeg.api.objects.events.RTSEvents;
import com.balugaq.jeg.core.listeners.GuideListener;
import com.balugaq.jeg.core.listeners.RTSListener;
import com.balugaq.jeg.implementation.JustEnoughGuide;
import com.balugaq.jeg.utils.GuideUtil;
import com.balugaq.jeg.utils.ItemStackUtil;
import com.balugaq.jeg.utils.Lang;
import com.balugaq.jeg.utils.LocalHelper;
import com.balugaq.jeg.utils.SlimefunOfficialSupporter;
import com.balugaq.jeg.utils.SpecialMenuProvider;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.events.PlayerPreResearchEvent;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.groups.FlexItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.groups.LockedItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.groups.NestedItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.groups.SeasonalItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.groups.SubItemGroup;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.api.researches.Research;
import io.github.thebusybiscuit.slimefun4.core.attributes.RecipeDisplayItem;
import io.github.thebusybiscuit.slimefun4.core.guide.GuideHistory;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuide;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideImplementation;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideMode;
import io.github.thebusybiscuit.slimefun4.core.guide.options.SlimefunGuideSettings;
import io.github.thebusybiscuit.slimefun4.core.multiblocks.MultiBlock;
import io.github.thebusybiscuit.slimefun4.core.multiblocks.MultiBlockMachine;
import io.github.thebusybiscuit.slimefun4.core.services.sounds.SoundEffect;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.guide.SurvivalSlimefunGuide;
import io.github.thebusybiscuit.slimefun4.implementation.tasks.AsyncRecipeChoiceTask;
import io.github.thebusybiscuit.slimefun4.libraries.dough.chat.ChatInput;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.ItemUtils;
import io.github.thebusybiscuit.slimefun4.libraries.dough.recipes.MinecraftRecipe;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.github.thebusybiscuit.slimefun4.utils.itemstack.SlimefunGuideItem;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Tag;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.permissions.Permissible;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class SurvivalGuideImplementation
extends SurvivalSlimefunGuide
implements JEGSlimefunGuideImplementation {
    private static final int RTS_SLOT = 6;
    private static final ItemStack RTS_ITEM = Lang.getIcon("guide.real-time-search", Material.ANVIL);
    private static final NamespacedKey UNLOCK_ITEM_KEY = new NamespacedKey((Plugin)JustEnoughGuide.getInstance(), "unlock_item");
    private static final int MAX_ITEM_GROUPS = 36;
    private static final int SPECIAL_MENU_SLOT = 26;
    private static final ItemStack SPECIAL_MENU_ITEM = Lang.getIcon("guide.special-menu", Material.COMPASS);
    private final int[] recipeSlots = new int[]{3, 4, 5, 12, 13, 14, 21, 22, 23};
    @NotNull
    private final ItemStack item;

    public SurvivalGuideImplementation() {
        super(SlimefunOfficialSupporter.isShowVanillaRecipes(), SlimefunOfficialSupporter.isShowHiddenItemGroups());
        ItemMeta meta = SlimefunGuide.getItem((SlimefunGuideMode)this.getMode()).getItemMeta();
        String name = "";
        if (meta != null) {
            name = meta.getDisplayName();
        }
        this.item = new SlimefunGuideItem((SlimefunGuideImplementation)this, name);
    }

    @Deprecated
    public SurvivalGuideImplementation(boolean v1, boolean v2) {
        super(v1, v2);
        ItemMeta meta = SlimefunGuide.getItem((SlimefunGuideMode)this.getMode()).getItemMeta();
        String name = "";
        if (meta != null) {
            name = meta.getDisplayName();
        }
        this.item = new SlimefunGuideItem((SlimefunGuideImplementation)this, name);
    }

    @ParametersAreNonnullByDefault
    @NotNull
    private static ItemStack getDisplayItem(Player p, boolean isSlimefunRecipe, ItemStack item) {
        if (isSlimefunRecipe) {
            SlimefunItem slimefunItem = SlimefunItem.getByItem((ItemStack)item);
            if (slimefunItem == null) {
                return item;
            }
            ItemGroup itemGroup = slimefunItem.getItemGroup();
            if (slimefunItem.isDisabledIn(p.getWorld())) {
                return ItemStackUtil.getCleanItem((ItemStack)new CustomItemStack(Material.BARRIER, ItemUtils.getItemName((ItemStack)item), new String[]{Lang.getGuideMessage("disabled-item")}));
            }
            String lore = SurvivalGuideImplementation.hasPermission(p, slimefunItem) ? Lang.getGuideMessage("locked-item", "addon_name", LocalHelper.getAddonName(itemGroup, slimefunItem.getId()), "category_name", itemGroup.getDisplayName(p)) : Lang.getGuideMessage("no-permission");
            Research research = slimefunItem.getResearch();
            if (research == null) {
                return ItemStackUtil.getCleanItem((ItemStack)(slimefunItem.canUse(p, false) ? item : new CustomItemStack((ItemStack)new CustomItemStack(Material.BARRIER, ItemUtils.getItemName((ItemStack)item), new String[]{"&4&l" + Slimefun.getLocalization().getMessage(p, "guide.locked"), "", lore}), meta -> meta.getPersistentDataContainer().set(UNLOCK_ITEM_KEY, PersistentDataType.STRING, (Object)slimefunItem.getId()))));
            }
            return ItemStackUtil.getCleanItem((ItemStack)(slimefunItem.canUse(p, false) ? item : new CustomItemStack((ItemStack)new CustomItemStack(Material.BARRIER, ItemUtils.getItemName((ItemStack)item), new String[]{"&4&l" + Slimefun.getLocalization().getMessage(p, "guide.locked"), "", lore, "", Lang.getGuideMessage("click-to-unlock"), "", Lang.getGuideMessage("cost", "cost", research.getCost())}), meta -> meta.getPersistentDataContainer().set(UNLOCK_ITEM_KEY, PersistentDataType.STRING, (Object)slimefunItem.getId()))));
        }
        return item;
    }

    @ParametersAreNonnullByDefault
    private static boolean hasPermission(Player p, SlimefunItem item) {
        return Slimefun.getPermissionsService().hasPermission((Permissible)p, item);
    }

    @NotNull
    public SlimefunGuideMode getMode() {
        return SlimefunGuideMode.SURVIVAL_MODE;
    }

    @NotNull
    public ItemStack getItem() {
        return this.item;
    }

    @NotNull
    protected List<ItemGroup> getVisibleItemGroups(@NotNull Player p, @NotNull PlayerProfile profile) {
        LinkedList<ItemGroup> groups = new LinkedList<ItemGroup>();
        for (ItemGroup group : Slimefun.getRegistry().getAllItemGroups()) {
            try {
                if (group.getClass().isAnnotationPresent(NotDisplayInSurvivalMode.class)) continue;
                if (group.getClass().isAnnotationPresent(DisplayInSurvivalMode.class)) {
                    groups.add(group);
                }
                if (group instanceof FlexItemGroup) {
                    FlexItemGroup flexItemGroup = (FlexItemGroup)group;
                    if (!flexItemGroup.isVisible(p, profile, this.getMode())) continue;
                    groups.add(group);
                    continue;
                }
                if (group.isHidden(p)) continue;
                groups.add(group);
            }
            catch (Exception | LinkageError x) {
                SlimefunAddon addon = group.getAddon();
                if (addon != null) {
                    addon.getLogger().log(Level.SEVERE, x, () -> Lang.getError("could-not-display-item-group", "group", group));
                    continue;
                }
                JustEnoughGuide.getInstance().getLogger().log(Level.SEVERE, x, () -> Lang.getError("could-not-display-item-group", "group", group));
            }
        }
        return groups;
    }

    public void openMainMenu(@NotNull PlayerProfile profile, int page) {
        Player p = profile.getPlayer();
        if (p == null) {
            return;
        }
        GuideHistory history = profile.getGuideHistory();
        history.clear();
        history.setMainMenuPage(page);
        ChestMenu menu = this.create(p);
        List<ItemGroup> itemGroups = this.getVisibleItemGroups(p, profile);
        this.createHeader(p, profile, menu);
        int target = 36 * (page - 1) - 1;
        for (int index = 9; target < itemGroups.size() - 1 && index < 45; ++index) {
            ItemGroup group = itemGroups.get(++target);
            this.showItemGroup(menu, p, profile, group, index);
        }
        int pages = target == itemGroups.size() - 1 ? page : (itemGroups.size() - 1) / 36 + 1;
        menu.addItem(46, ItemStackUtil.getCleanItem(ChestMenuUtils.getPreviousButton((Player)p, (int)page, (int)pages)));
        menu.addMenuClickHandler(46, (pl, slot, item, action) -> {
            int next = page - 1;
            if (next != page && next > 0) {
                this.openMainMenu(profile, next);
            }
            return false;
        });
        menu.addItem(52, ItemStackUtil.getCleanItem(ChestMenuUtils.getNextButton((Player)p, (int)page, (int)pages)));
        menu.addMenuClickHandler(52, (pl, slot, item, action) -> {
            int next = page + 1;
            if (next != page && next <= pages) {
                this.openMainMenu(profile, next);
            }
            return false;
        });
        if (JustEnoughGuide.getConfigManager().isBookmark()) {
            menu.addItem(49, ItemStackUtil.getCleanItem(GuideUtil.getBookMarkMenuButton()), (pl, slot, itemstack, action) -> {
                this.openBookMarkGroup(pl, profile);
                return false;
            });
        }
        GuideListener.guideModeMap.put(p, this.getMode());
        menu.open(new Player[]{p});
    }

    private void showItemGroup(@NotNull ChestMenu menu, @NotNull Player p, @NotNull PlayerProfile profile, ItemGroup group, int index) {
        if (!(group instanceof LockedItemGroup) || !this.isSurvivalMode() || ((LockedItemGroup)group).hasUnlocked(p, profile)) {
            menu.addItem(index, ItemStackUtil.getCleanItem(group.getItem(p)));
            menu.addMenuClickHandler(index, (pl, slot, item, action) -> {
                this.openItemGroup(profile, group, 1);
                return false;
            });
        } else {
            ArrayList<Object> lore = new ArrayList<Object>();
            lore.add("");
            for (String line : Slimefun.getLocalization().getMessages(p, "guide.locked-itemgroup")) {
                lore.add(String.valueOf(ChatColor.WHITE) + line);
            }
            lore.add("");
            for (ItemGroup parent : ((LockedItemGroup)group).getParents()) {
                ItemMeta meta = parent.getItem(p).getItemMeta();
                if (meta == null) continue;
                lore.add(meta.getDisplayName());
            }
            ItemMeta meta = group.getItem(p).getItemMeta();
            if (meta == null) {
                return;
            }
            menu.addItem(index, ItemStackUtil.getCleanItem((ItemStack)new CustomItemStack(Material.BARRIER, "&4" + Slimefun.getLocalization().getMessage(p, "guide.locked") + " &7- &f" + meta.getDisplayName(), lore.toArray(new String[0]))));
            menu.addMenuClickHandler(index, ChestMenuUtils.getEmptyClickHandler());
        }
    }

    @ParametersAreNonnullByDefault
    public void openItemGroup(PlayerProfile profile, ItemGroup itemGroup, int page) {
        int target;
        Player p = profile.getPlayer();
        if (p == null) {
            return;
        }
        if (itemGroup instanceof FlexItemGroup) {
            FlexItemGroup flexItemGroup = (FlexItemGroup)itemGroup;
            flexItemGroup.open(p, profile, this.getMode());
            return;
        }
        if (this.isSurvivalMode()) {
            profile.getGuideHistory().add(itemGroup, page);
        }
        ChestMenu menu = this.create(p);
        this.createHeader(p, profile, menu, itemGroup);
        this.addBackButton(menu, 1, p, profile);
        int pages = (itemGroup.getItems().size() - 1) / 36 + 1;
        menu.addItem(46, ItemStackUtil.getCleanItem(ChestMenuUtils.getPreviousButton((Player)p, (int)page, (int)pages)));
        menu.addMenuClickHandler(46, (pl, slot, item, action) -> {
            int next = page - 1;
            if (next != page && next > 0) {
                this.openItemGroup(profile, itemGroup, next);
            }
            return false;
        });
        menu.addItem(52, ItemStackUtil.getCleanItem(ChestMenuUtils.getNextButton((Player)p, (int)page, (int)pages)));
        menu.addMenuClickHandler(52, (pl, slot, item, action) -> {
            int next = page + 1;
            if (next != page && next <= pages) {
                this.openItemGroup(profile, itemGroup, next);
            }
            return false;
        });
        int index = 9;
        int itemGroupIndex = 36 * (page - 1);
        for (int i = 0; i < 36 && (target = itemGroupIndex + i) < itemGroup.getItems().size(); ++i) {
            SlimefunItem sfitem = (SlimefunItem)itemGroup.getItems().get(target);
            if (sfitem.isDisabledIn(p.getWorld())) continue;
            this.displaySlimefunItem(menu, itemGroup, p, profile, sfitem, page, index);
            ++index;
        }
        menu.open(new Player[]{p});
    }

    private void displaySlimefunItem(@NotNull ChestMenu menu, @NotNull ItemGroup itemGroup, @NotNull Player p, @NotNull PlayerProfile profile, @NotNull SlimefunItem sfitem, int page, int index) {
        Research research = sfitem.getResearch();
        if (this.isSurvivalMode() && !SurvivalGuideImplementation.hasPermission(p, sfitem)) {
            List message = Slimefun.getPermissionsService().getLore(sfitem);
            menu.addItem(index, ItemStackUtil.getCleanItem((ItemStack)new CustomItemStack(ChestMenuUtils.getNoPermissionItem(), sfitem.getItemName(), message.toArray(new String[0]))));
            menu.addMenuClickHandler(index, ChestMenuUtils.getEmptyClickHandler());
        } else if (this.isSurvivalMode() && research != null && !profile.hasUnlocked(research)) {
            menu.addItem(index, ItemStackUtil.getCleanItem((ItemStack)new CustomItemStack(ChestMenuUtils.getNoPermissionItem(), "&f" + ItemUtils.getItemName((ItemStack)sfitem.getItem()), new String[]{"&7" + sfitem.getId(), "&4&l" + Slimefun.getLocalization().getMessage(p, "guide.locked"), "", Lang.getGuideMessage("click-to-unlock"), "", Lang.getGuideMessage("cost", "cost", research.getCost())})));
            menu.addMenuClickHandler(index, (pl, slot, item, action) -> {
                research.unlockFromGuide((SlimefunGuideImplementation)this, p, profile, sfitem, itemGroup, page);
                return false;
            });
        } else {
            menu.addItem(index, ItemStackUtil.getCleanItem(sfitem.getItem()));
            menu.addMenuClickHandler(index, (pl, slot, item, action) -> {
                try {
                    if (this.isSurvivalMode()) {
                        this.displayItem(profile, sfitem, true);
                    } else if (pl.isOp() || pl.hasPermission("slimefun.cheat.items")) {
                        if (sfitem instanceof MultiBlockMachine) {
                            Slimefun.getLocalization().sendMessage((CommandSender)pl, "guide.cheat.no-multiblocks");
                        } else {
                            ItemStack clonedItem = sfitem.getItem().clone();
                            if (action.isShiftClicked()) {
                                clonedItem.setAmount(clonedItem.getMaxStackSize());
                            }
                            pl.getInventory().addItem(new ItemStack[]{clonedItem});
                        }
                    } else {
                        Slimefun.getLocalization().sendMessage((CommandSender)pl, "messages.no-permission", true);
                    }
                }
                catch (Exception | LinkageError x) {
                    this.printErrorMessage(pl, sfitem, x);
                }
                return false;
            });
        }
    }

    @ParametersAreNonnullByDefault
    public void openSearch(PlayerProfile profile, String input, boolean addToHistory) {
        this.openSearch(profile, input, 0, addToHistory);
    }

    @ParametersAreNonnullByDefault
    public void openSearch(PlayerProfile profile, String input, int page, boolean addToHistory) {
        Player p = profile.getPlayer();
        if (p == null) {
            return;
        }
        String searchTerm = ChatColor.stripColor((String)input.toLowerCase(Locale.ROOT));
        SearchGroup group = new SearchGroup(this, p, searchTerm, false, true);
        group.open(p, profile, this.getMode());
    }

    @ParametersAreNonnullByDefault
    public void displayItem(PlayerProfile profile, ItemStack item, int index, boolean addToHistory) {
        Player p = profile.getPlayer();
        if (p == null || item == null || item.getType() == Material.AIR) {
            return;
        }
        SlimefunItem sfItem = SlimefunItem.getByItem((ItemStack)item);
        if (sfItem != null) {
            this.displayItem(profile, sfItem, addToHistory);
            return;
        }
        if (!SlimefunOfficialSupporter.isShowVanillaRecipes()) {
            return;
        }
        Recipe[] recipes = Slimefun.getMinecraftRecipeService().getRecipesFor(item);
        if (recipes.length == 0) {
            return;
        }
        this.showMinecraftRecipe(recipes, index, item, profile, p, addToHistory);
    }

    private void showMinecraftRecipe(Recipe @NotNull [] recipes, int index, @NotNull ItemStack item, @NotNull PlayerProfile profile, @NotNull Player p, boolean addToHistory) {
        Recipe recipe = recipes[index];
        ItemStack[] recipeItems = new ItemStack[9];
        RecipeType recipeType = RecipeType.NULL;
        ItemStack result = null;
        Optional optional = MinecraftRecipe.of((Recipe)recipe);
        AsyncRecipeChoiceTask task = new AsyncRecipeChoiceTask();
        if (optional.isPresent()) {
            this.showRecipeChoices(recipe, recipeItems, task);
            recipeType = new RecipeType((MinecraftRecipe)optional.get());
            result = recipe.getResult();
        } else {
            recipeItems = new ItemStack[]{null, null, null, null, ItemStackUtil.getCleanItem((ItemStack)new CustomItemStack(Material.BARRIER, Lang.getError("unknown-recipe"), new String[0])), null, null, null, null};
        }
        ChestMenu menu = this.create(p);
        if (addToHistory) {
            profile.getGuideHistory().add(item, index);
        }
        this.displayItem(menu, profile, p, item, result, recipeType, recipeItems, task);
        if (recipes.length > 1) {
            for (int i = 27; i < 36; ++i) {
                menu.addItem(i, ItemStackUtil.getCleanItem(ChestMenuUtils.getBackground()), ChestMenuUtils.getEmptyClickHandler());
            }
            menu.addItem(28, ItemStackUtil.getCleanItem(ChestMenuUtils.getPreviousButton((Player)p, (int)(index + 1), (int)recipes.length)), (pl, slot, action, stack) -> {
                if (index > 0) {
                    this.showMinecraftRecipe(recipes, index - 1, item, profile, p, true);
                }
                return false;
            });
            menu.addItem(34, ItemStackUtil.getCleanItem(ChestMenuUtils.getNextButton((Player)p, (int)(index + 1), (int)recipes.length)), (pl, slot, action, stack) -> {
                if (index < recipes.length - 1) {
                    this.showMinecraftRecipe(recipes, index + 1, item, profile, p, true);
                }
                return false;
            });
        }
        menu.open(new Player[]{p});
        if (!task.isEmpty()) {
            task.start(menu.toInventory());
        }
    }

    private <T extends Recipe> void showRecipeChoices(@NotNull T recipe, ItemStack[] recipeItems, @NotNull AsyncRecipeChoiceTask task) {
        RecipeChoice recipeChoice;
        RecipeChoice[] choices = Slimefun.getMinecraftRecipeService().getRecipeShape(recipe);
        if (choices.length == 1 && (recipeChoice = choices[0]) instanceof RecipeChoice.MaterialChoice) {
            RecipeChoice.MaterialChoice materialChoice = (RecipeChoice.MaterialChoice)recipeChoice;
            recipeItems[4] = new ItemStack((Material)materialChoice.getChoices().get(0));
            if (materialChoice.getChoices().size() > 1) {
                task.add(this.recipeSlots[4], materialChoice);
            }
        } else {
            for (int i = 0; i < choices.length; ++i) {
                RecipeChoice recipeChoice2 = choices[i];
                if (!(recipeChoice2 instanceof RecipeChoice.MaterialChoice)) continue;
                RecipeChoice.MaterialChoice materialChoice = (RecipeChoice.MaterialChoice)recipeChoice2;
                recipeItems[i] = new ItemStack((Material)materialChoice.getChoices().get(0));
                if (materialChoice.getChoices().size() <= 1) continue;
                task.add(this.recipeSlots[i], materialChoice);
            }
        }
    }

    @ParametersAreNonnullByDefault
    public void displayItem(PlayerProfile profile, SlimefunItem item, boolean addToHistory) {
        this.displayItem(profile, item, addToHistory, true);
    }

    @Override
    @ParametersAreNonnullByDefault
    public void displayItem(PlayerProfile profile, SlimefunItem item, boolean addToHistory, boolean maybeSpecial) {
        Player p = profile.getPlayer();
        if (p == null) {
            return;
        }
        ChestMenu menu = this.create(p);
        Optional wiki = item.getWikipage();
        if (wiki.isPresent()) {
            menu.addItem(8, ItemStackUtil.getCleanItem((ItemStack)new CustomItemStack(Material.KNOWLEDGE_BOOK, String.valueOf(ChatColor.WHITE) + Slimefun.getLocalization().getMessage(p, "guide.tooltips.wiki"), new String[]{"", String.valueOf(ChatColor.GRAY) + "\u21e8 " + String.valueOf(ChatColor.GREEN) + Slimefun.getLocalization().getMessage(p, "guide.tooltips.open-itemgroup")})));
            menu.addMenuClickHandler(8, (pl, slot, itemstack, action) -> {
                pl.closeInventory();
                ChatUtils.sendURL((CommandSender)pl, (String)((String)wiki.get()));
                return false;
            });
        }
        AsyncRecipeChoiceTask task = new AsyncRecipeChoiceTask();
        if (addToHistory) {
            profile.getGuideHistory().add(item);
        }
        ItemStack result = item.getRecipeOutput();
        RecipeType recipeType = item.getRecipeType();
        ItemStack[] recipe = item.getRecipe();
        this.displayItem(menu, profile, p, item, result, recipeType, recipe, task);
        if (item instanceof RecipeDisplayItem) {
            RecipeDisplayItem recipeDisplayItem = (RecipeDisplayItem)item;
            this.displayRecipes(p, profile, menu, recipeDisplayItem, 0);
        }
        if (maybeSpecial && SpecialMenuProvider.isSpecialItem(item)) {
            menu.addItem(26, SPECIAL_MENU_ITEM, (pl, slot, itemstack, action) -> {
                try {
                    SpecialMenuProvider.open(profile.getPlayer(), profile, this.getMode(), item);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    e.printStackTrace();
                }
                return false;
            });
        }
        menu.open(new Player[]{p});
        if (!task.isEmpty()) {
            task.start(menu.toInventory());
        }
    }

    private void displayItem(@NotNull ChestMenu menu, @NotNull PlayerProfile profile, @NotNull Player p, Object item, ItemStack output, @NotNull RecipeType recipeType, ItemStack[] recipe, @NotNull AsyncRecipeChoiceTask task) {
        this.addBackButton(menu, 0, p, profile);
        ChestMenu.MenuClickHandler clickHandler = (pl, slot, itemstack, action) -> {
            try {
                ItemGroup itemGroup;
                SlimefunItem sfItem;
                if (!action.isRightClicked() && action.isShiftClicked() && (sfItem = SlimefunItem.getByItem((ItemStack)itemstack)) != null && (itemGroup = sfItem.getItemGroup()) != null) {
                    int page = 1;
                    if (this.isTaggedGroupType(itemGroup)) {
                        page = itemGroup.getItems().indexOf(sfItem) / 36 + 1;
                    }
                    this.openItemGroup(profile, itemGroup, page);
                    return false;
                }
                if (itemstack != null && itemstack.getType() != Material.AIR) {
                    String id = (String)itemstack.getItemMeta().getPersistentDataContainer().get(UNLOCK_ITEM_KEY, PersistentDataType.STRING);
                    if (id != null) {
                        Research research;
                        SlimefunItem sfItem2 = SlimefunItem.getById((String)id);
                        if (sfItem2 != null && !sfItem2.isDisabledIn(p.getWorld()) && (research = sfItem2.getResearch()) != null && !Slimefun.getRegistry().getCurrentlyResearchingPlayers().contains(p.getUniqueId())) {
                            if (profile.hasUnlocked(research)) {
                                GuideUtil.removeLastEntry(profile.getGuideHistory());
                                if (item instanceof SlimefunItem) {
                                    SlimefunItem slimefunItem = (SlimefunItem)item;
                                    this.displayItem(profile, slimefunItem, true, true);
                                } else if (item instanceof ItemStack) {
                                    ItemStack itemStack = (ItemStack)item;
                                    this.displayItem(profile, itemStack, 0, true);
                                }
                            } else {
                                PlayerPreResearchEvent event = new PlayerPreResearchEvent(p, research, sfItem2);
                                Bukkit.getPluginManager().callEvent((Event)event);
                                if (!event.isCancelled()) {
                                    if (research.canUnlock(p)) {
                                        this.unlockItem(p, sfItem2, p2 -> {
                                            GuideUtil.removeLastEntry(profile.getGuideHistory());
                                            if (item instanceof SlimefunItem) {
                                                SlimefunItem slimefunItem = (SlimefunItem)item;
                                                this.displayItem(profile, slimefunItem, true, true);
                                            } else if (item instanceof ItemStack) {
                                                ItemStack itemStack = (ItemStack)item;
                                                this.displayItem(profile, itemStack, 0, true);
                                            }
                                        });
                                    } else {
                                        Slimefun.getLocalization().sendMessage((CommandSender)p, "messages.not-enough-xp", true);
                                    }
                                }
                            }
                        }
                    } else {
                        this.displayItem(profile, itemstack, 0, true);
                    }
                }
            }
            catch (Exception | LinkageError x) {
                this.printErrorMessage(pl, x);
            }
            return false;
        };
        boolean isSlimefunRecipe = item instanceof SlimefunItem;
        block0: for (int i = 0; i < 9; ++i) {
            ItemStack recipeItem = SurvivalGuideImplementation.getDisplayItem(p, isSlimefunRecipe, recipe[i]);
            menu.addItem(this.recipeSlots[i], ItemStackUtil.getCleanItem(recipeItem), clickHandler);
            if (recipeItem == null || !(item instanceof MultiBlockMachine)) continue;
            for (Tag tag : MultiBlock.getSupportedTags()) {
                if (!tag.isTagged((Keyed)recipeItem.getType())) continue;
                task.add(this.recipeSlots[i], tag);
                continue block0;
            }
        }
        menu.addItem(10, ItemStackUtil.getCleanItem(recipeType.getItem(p)), ChestMenuUtils.getEmptyClickHandler());
        menu.addItem(16, ItemStackUtil.getCleanItem(output), ChestMenuUtils.getEmptyClickHandler());
    }

    @Override
    @ParametersAreNonnullByDefault
    public void createHeader(Player p, PlayerProfile profile, ChestMenu menu) {
        int i;
        for (i = 0; i < 9; ++i) {
            menu.addItem(i, ItemStackUtil.getCleanItem(ChestMenuUtils.getBackground()), ChestMenuUtils.getEmptyClickHandler());
        }
        menu.addItem(1, ItemStackUtil.getCleanItem(ChestMenuUtils.getMenuButton((Player)p)));
        menu.addMenuClickHandler(1, (pl, slot, item, action) -> {
            SlimefunGuideSettings.openSettings((Player)pl, (ItemStack)pl.getInventory().getItemInMainHand());
            return false;
        });
        if (JustEnoughGuide.getConfigManager().isRTSSearch()) {
            menu.addItem(6, ItemStackUtil.getCleanItem(RTS_ITEM), (pl, slot, itemstack, action) -> {
                RTSSearchGroup.newRTSInventoryFor(pl, this.getMode(), (s, stateSnapshot) -> {
                    SearchGroup rts;
                    if (s == 0) {
                        GuideHistory history = profile.getGuideHistory();
                        if (action.isShiftClicked()) {
                            this.openMainMenu(profile, profile.getGuideHistory().getMainMenuPage());
                        } else {
                            history.goBack((SlimefunGuideImplementation)this);
                        }
                        return;
                    }
                    if (s == 1) {
                        SearchGroup rts2 = RTSSearchGroup.RTS_SEARCH_GROUPS.get(pl);
                        if (rts2 != null) {
                            int oldPage = RTSSearchGroup.RTS_PAGES.getOrDefault(pl, 1);
                            int newPage = Math.max(1, oldPage - 1);
                            RTSEvents.PageChangeEvent event = new RTSEvents.PageChangeEvent(pl, RTSSearchGroup.RTS_PLAYERS.get(pl), oldPage, newPage, this.getMode());
                            Bukkit.getPluginManager().callEvent((Event)event);
                            if (!event.isCancelled()) {
                                Map<Player, Integer> map = RTSSearchGroup.RTS_PAGES;
                                synchronized (map) {
                                    RTSSearchGroup.RTS_PAGES.put(pl, newPage);
                                }
                            }
                        }
                    } else if (s == 2 && (rts = RTSSearchGroup.RTS_SEARCH_GROUPS.get(pl)) != null) {
                        int oldPage = RTSSearchGroup.RTS_PAGES.getOrDefault(pl, 1);
                        int newPage = Math.min((rts.slimefunItemList.size() - 1) / RTSListener.FILL_ORDER.length + 1, oldPage + 1);
                        RTSEvents.PageChangeEvent event = new RTSEvents.PageChangeEvent(pl, RTSSearchGroup.RTS_PLAYERS.get(pl), oldPage, newPage, this.getMode());
                        Bukkit.getPluginManager().callEvent((Event)event);
                        if (!event.isCancelled()) {
                            Map<Player, Integer> map = RTSSearchGroup.RTS_PAGES;
                            synchronized (map) {
                                RTSSearchGroup.RTS_PAGES.put(pl, newPage);
                            }
                        }
                    }
                }, new int[]{0, 1, 2}, null);
                return false;
            });
        }
        menu.addItem(7, ItemStackUtil.getCleanItem(ChestMenuUtils.getSearchButton((Player)p)));
        menu.addMenuClickHandler(7, (pl, slot, item, action) -> {
            pl.closeInventory();
            Slimefun.getLocalization().sendMessage((CommandSender)pl, "guide.search.message");
            ChatInput.waitForPlayer((Plugin)JustEnoughGuide.getInstance(), (Player)pl, msg -> this.openSearch(profile, (String)msg, this.isSurvivalMode()));
            return false;
        });
        for (i = 45; i < 54; ++i) {
            menu.addItem(i, ItemStackUtil.getCleanItem(ChestMenuUtils.getBackground()), ChestMenuUtils.getEmptyClickHandler());
        }
        if (JustEnoughGuide.getConfigManager().isBookmark()) {
            menu.addItem(49, ItemStackUtil.getCleanItem(GuideUtil.getBookMarkMenuButton()), (pl, slot, itemstack, action) -> {
                this.openBookMarkGroup(pl, profile);
                return false;
            });
        }
    }

    @ParametersAreNonnullByDefault
    public void createHeader(Player p, PlayerProfile profile, ChestMenu menu, ItemGroup itemGroup) {
        int i;
        for (i = 0; i < 9; ++i) {
            menu.addItem(i, ItemStackUtil.getCleanItem(ChestMenuUtils.getBackground()), ChestMenuUtils.getEmptyClickHandler());
        }
        menu.addItem(1, ItemStackUtil.getCleanItem(ChestMenuUtils.getMenuButton((Player)p)));
        menu.addMenuClickHandler(1, (pl, slot, item, action) -> {
            SlimefunGuideSettings.openSettings((Player)pl, (ItemStack)pl.getInventory().getItemInMainHand());
            return false;
        });
        menu.addItem(7, ItemStackUtil.getCleanItem(ChestMenuUtils.getSearchButton((Player)p)));
        menu.addMenuClickHandler(7, (pl, slot, item, action) -> {
            pl.closeInventory();
            Slimefun.getLocalization().sendMessage((CommandSender)pl, "guide.search.message");
            ChatInput.waitForPlayer((Plugin)JustEnoughGuide.getInstance(), (Player)pl, msg -> this.openSearch(profile, (String)msg, this.isSurvivalMode()));
            return false;
        });
        for (i = 45; i < 54; ++i) {
            menu.addItem(i, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
        }
        if (JustEnoughGuide.getConfigManager().isBookmark()) {
            BookmarkRelocation b = null;
            if (itemGroup instanceof BookmarkRelocation) {
                BookmarkRelocation bookmarkRelocation;
                b = bookmarkRelocation = (BookmarkRelocation)itemGroup;
            }
            menu.addItem(b != null ? b.getBookMark(this, p) : 49, ItemStackUtil.getCleanItem(GuideUtil.getBookMarkMenuButton()), (pl, slot, itemstack, action) -> {
                this.openBookMarkGroup(pl, profile);
                return false;
            });
            if (this.isTaggedGroupType(itemGroup)) {
                menu.addItem(b != null ? b.getItemMark(this, p) : 48, ItemStackUtil.getCleanItem(GuideUtil.getItemMarkMenuButton()), (pl, slot, itemstack, action) -> {
                    this.openItemMarkGroup(itemGroup, pl, profile);
                    return false;
                });
            }
        }
    }

    private boolean isTaggedGroupType(@NotNull ItemGroup itemGroup) {
        Class<?> clazz = itemGroup.getClass();
        return clazz == ItemGroup.class || clazz == SubItemGroup.class || clazz == NestedItemGroup.class || clazz == LockedItemGroup.class || clazz == SeasonalItemGroup.class || clazz == SearchGroup.class || itemGroup instanceof BookmarkRelocation || clazz.getName().equalsIgnoreCase("me.voper.slimeframe.implementation.groups.ChildGroup") || clazz.getName().endsWith("DummyItemGroup") || clazz.getName().endsWith("SubGroup");
    }

    private void addBackButton(@NotNull ChestMenu menu, int slot, @NotNull Player p, @NotNull PlayerProfile profile) {
        GuideHistory history = profile.getGuideHistory();
        if (this.isSurvivalMode() && history.size() > 1) {
            menu.addItem(slot, SlimefunOfficialSupporter.getBackButton(p));
            menu.addMenuClickHandler(slot, (pl, s, is, action) -> {
                if (action.isShiftClicked()) {
                    this.openMainMenu(profile, profile.getGuideHistory().getMainMenuPage());
                } else {
                    history.goBack((SlimefunGuideImplementation)this);
                }
                return false;
            });
        } else {
            menu.addItem(slot, ItemStackUtil.getCleanItem(ChestMenuUtils.getBackButton((Player)p, (String[])new String[]{"", String.valueOf(ChatColor.GRAY) + Slimefun.getLocalization().getMessage(p, "guide.back.guide")})));
            menu.addMenuClickHandler(slot, (pl, s, is, action) -> {
                this.openMainMenu(profile, profile.getGuideHistory().getMainMenuPage());
                return false;
            });
        }
    }

    @ParametersAreNonnullByDefault
    private void displayRecipes(Player p, PlayerProfile profile, ChestMenu menu, RecipeDisplayItem sfItem, int page) {
        List recipes = sfItem.getDisplayRecipes();
        if (!recipes.isEmpty()) {
            menu.addItem(53, ItemStackUtil.getCleanItem(null));
            if (page == 0) {
                for (int i = 27; i < 36; ++i) {
                    menu.replaceExistingItem(i, ItemStackUtil.getCleanItem((ItemStack)new CustomItemStack(ChestMenuUtils.getBackground(), sfItem.getRecipeSectionLabel(p), new String[0])));
                    menu.addMenuClickHandler(i, ChestMenuUtils.getEmptyClickHandler());
                }
            }
            int pages = (recipes.size() - 1) / 18 + 1;
            menu.replaceExistingItem(28, ItemStackUtil.getCleanItem(ChestMenuUtils.getPreviousButton((Player)p, (int)(page + 1), (int)pages)));
            menu.addMenuClickHandler(28, (pl, slot, itemstack, action) -> {
                if (page > 0) {
                    this.displayRecipes(pl, profile, menu, sfItem, page - 1);
                    SoundEffect.GUIDE_BUTTON_CLICK_SOUND.playFor(pl);
                }
                return false;
            });
            menu.replaceExistingItem(34, ItemStackUtil.getCleanItem(ChestMenuUtils.getNextButton((Player)p, (int)(page + 1), (int)pages)));
            menu.addMenuClickHandler(34, (pl, slot, itemstack, action) -> {
                if (recipes.size() > 18 * (page + 1)) {
                    this.displayRecipes(pl, profile, menu, sfItem, page + 1);
                    SoundEffect.GUIDE_BUTTON_CLICK_SOUND.playFor(pl);
                }
                return false;
            });
            int inputs = 36;
            int outputs = 45;
            for (int i = 0; i < 18; ++i) {
                int slot2 = i % 2 == 0 ? inputs++ : outputs++;
                this.addDisplayRecipe(menu, profile, recipes, slot2, i, page);
            }
        }
    }

    private void addDisplayRecipe(@NotNull ChestMenu menu, @NotNull PlayerProfile profile, @NotNull List<ItemStack> recipes, int slot, int i, int page) {
        if (i + page * 18 < recipes.size()) {
            ItemStack displayItem = recipes.get(i + page * 18);
            if (displayItem != null) {
                displayItem = displayItem.clone();
            }
            menu.replaceExistingItem(slot, ItemStackUtil.getCleanItem(displayItem));
            if (page == 0) {
                menu.addMenuClickHandler(slot, (pl, s, itemstack, action) -> {
                    this.displayItem(profile, itemstack, 0, true);
                    return false;
                });
            }
        } else {
            menu.replaceExistingItem(slot, ItemStackUtil.getCleanItem(null));
            menu.addMenuClickHandler(slot, ChestMenuUtils.getEmptyClickHandler());
        }
    }

    @Override
    @NotNull
    public ChestMenu create(@NotNull Player p) {
        ChestMenu menu = new ChestMenu(JustEnoughGuide.getConfigManager().getSurvivalGuideTitle());
        menu.setEmptySlotsClickable(false);
        menu.addMenuOpeningHandler(arg_0 -> ((SoundEffect)SoundEffect.GUIDE_BUTTON_CLICK_SOUND).playFor(arg_0));
        return menu;
    }

    @ParametersAreNonnullByDefault
    private void printErrorMessage(Player p, Throwable x) {
        p.sendMessage(Lang.getError("internal-error"));
        JustEnoughGuide.getInstance().getLogger().log(Level.SEVERE, Lang.getError("error-occurred"), x);
        JustEnoughGuide.getInstance().getLogger().warning(Lang.getError("trying-fix-guide", "player_name", p.getName()));
        PlayerProfile profile = PlayerProfile.find((OfflinePlayer)p).orElse(null);
        if (profile == null) {
            return;
        }
        GuideUtil.removeLastEntry(profile.getGuideHistory());
    }

    @ParametersAreNonnullByDefault
    private void printErrorMessage(Player p, SlimefunItem item, Throwable x) {
        p.sendMessage(Lang.getError("internal-error"));
        item.error(Lang.getError("item-error"), x);
        JustEnoughGuide.getInstance().getLogger().warning(Lang.getError("trying-fix-guide", "player_name", p.getName()));
        PlayerProfile profile = PlayerProfile.find((OfflinePlayer)p).orElse(null);
        if (profile == null) {
            return;
        }
        GuideUtil.removeLastEntry(profile.getGuideHistory());
    }
}

