/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.utils;

import com.balugaq.jeg.api.interfaces.JEGSlimefunGuideImplementation;
import com.balugaq.jeg.utils.Debug;
import com.balugaq.jeg.utils.ReflectionUtil;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.groups.FlexItemGroup;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.api.researches.Research;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideImplementation;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideMode;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import me.matl114.logitech.Utils.UtilClass.MenuClass.CustomMenu;
import me.matl114.logitech.Utils.UtilClass.MenuClass.CustomMenuHandler;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class SpecialMenuProvider {
    public static final String PLACEHOLDER_SEARCH_TERM = "undefined";
    public static final int COMMON_RECIPE_LENGTH = 9;
    public static final boolean ENABLED_FinalTECH;
    public static final boolean ENABLED_Nexcavate;
    public static final boolean ENABLED_LogiTech;
    public static final boolean ENABLED_InfinityExpansion;
    public static final boolean ENABLED_ObsidianExpansion;
    @Nullable
    public static Method methodRecipeItemGroup_getBySlimefunItem;
    @Nullable
    public static Method methodPlayerProgress_get;
    @Nullable
    public static Method methodNEGUI_openRecipe;
    @Nullable
    public static Method methodNEGUI_openResearchScreen;
    @Nullable
    public static Method methodNexcavateRegistry_getResearchMap;
    @Nullable
    public static Object objectNexcavate_registry;
    @Nullable
    public static Method methodMenuUtils_createItemRecipeDisplay;
    @Nullable
    public static Method methodMenuFactory_buildGuide;
    @Nullable
    public static Method methodCustomMenu_open;
    @Nullable
    public static Method methodInfinityGroup_openInfinityRecipe;
    @Nullable
    public static Object objectInfinityExpansion_INFINITY;
    @Nullable
    public static Constructor<?> constructorInfinityExpansion_BackEntry;
    @Nullable
    public static Class<?> classInfinityExpansion_Singularity;
    @Nullable
    public static Method methodObsidianExpansion_openFORGERecipe;
    @Nullable
    public static Constructor<?> constructorObsidianExpansion_BackEntry;

    public static boolean isSpecialItem(@Nonnull SlimefunItem slimefunItem) {
        return SpecialMenuProvider.isFinalTECHItem(slimefunItem) || SpecialMenuProvider.isNexcavateItem(slimefunItem) || SpecialMenuProvider.isLogiTechItem(slimefunItem) || SpecialMenuProvider.isInfinityItem(slimefunItem) || SpecialMenuProvider.isObsidianForgeItem(slimefunItem);
    }

    @Nullable
    public static FlexItemGroup getFinalTECHRecipeItemGroup(@Nonnull Player player, @Nonnull PlayerProfile playerProfile, @Nonnull SlimefunGuideMode slimefunGuideMode, @Nonnull SlimefunItem slimefunItem) throws InvocationTargetException, IllegalAccessException {
        if (!ENABLED_FinalTECH) {
            return null;
        }
        if (methodRecipeItemGroup_getBySlimefunItem == null) {
            return null;
        }
        methodRecipeItemGroup_getBySlimefunItem.setAccessible(true);
        return (FlexItemGroup)methodRecipeItemGroup_getBySlimefunItem.invoke(null, player, playerProfile, slimefunGuideMode, slimefunItem, 1);
    }

    public static boolean isFinalTECHItem(@Nonnull SlimefunItem slimefunItem) {
        if (!ENABLED_FinalTECH) {
            return false;
        }
        String addonName = slimefunItem.getAddon().getName();
        return ("FinalTECH".equals(addonName) || "FinalTECH-Changed".equals(addonName)) && slimefunItem.getRecipe().length > 9;
    }

    public static void openNexcavateGuide(@Nonnull Player player, @Nonnull SlimefunItem slimefunItem) throws IllegalAccessException, InvocationTargetException {
        if (!SpecialMenuProvider.isNexcavateItem(slimefunItem)) {
            return;
        }
        ItemStack item = slimefunItem.getItem();
        if (methodNexcavateRegistry_getResearchMap == null) {
            return;
        }
        Object research = null;
        if (objectNexcavate_registry == null) {
            return;
        }
        Map researchMap = (Map)methodNexcavateRegistry_getResearchMap.invoke(objectNexcavate_registry, new Object[0]);
        for (Object lresearch : researchMap.values()) {
            SlimefunItem NEItem = (SlimefunItem)ReflectionUtil.getValue(lresearch, "item");
            if (NEItem == null || NEItem.getItem().getType() != item.getType()) continue;
            research = lresearch;
            break;
        }
        if (research == null) {
            return;
        }
        if (SpecialMenuProvider.isPlayerResearchedNexcavate(player, research)) {
            if (methodNEGUI_openRecipe == null) {
                return;
            }
            methodNEGUI_openRecipe.invoke(null, player, research);
        } else {
            if (methodNEGUI_openResearchScreen == null) {
                return;
            }
            methodNEGUI_openResearchScreen.invoke(null, player);
        }
    }

    public static boolean isPlayerResearchedNexcavate(@Nonnull Player player, @Nonnull Object research) throws InvocationTargetException, IllegalAccessException {
        if (!ENABLED_Nexcavate) {
            return false;
        }
        if (methodPlayerProgress_get == null) {
            return false;
        }
        methodPlayerProgress_get.setAccessible(true);
        Object playerProgress = methodPlayerProgress_get.invoke(null, player);
        if (playerProgress == null) {
            return false;
        }
        Method method = ReflectionUtil.getMethod(playerProgress.getClass(), "isResearched", NamespacedKey.class);
        if (method == null) {
            return false;
        }
        method.setAccessible(true);
        NamespacedKey key = (NamespacedKey)ReflectionUtil.getValue(research, "key");
        return (Boolean)method.invoke(playerProgress, key);
    }

    public static boolean isNexcavateItem(@Nonnull SlimefunItem slimefunItem) {
        if (!ENABLED_Nexcavate) {
            return false;
        }
        String addonName = slimefunItem.getAddon().getName();
        if ("Nexcavate".equals(addonName)) {
            for (ItemStack itemStack : slimefunItem.getRecipe()) {
                if (itemStack == null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static void openLogiTechMenu(@Nonnull Player player, @Nonnull PlayerProfile playerProfile, @Nonnull SlimefunItem slimefunItem) throws InvocationTargetException, IllegalAccessException {
        if (methodMenuUtils_createItemRecipeDisplay == null) {
            return;
        }
        Object menuFactory = methodMenuUtils_createItemRecipeDisplay.invoke(null, slimefunItem, new CustomMenuHandlerImpl(), null);
        if (menuFactory == null) {
            return;
        }
        if (methodMenuFactory_buildGuide == null) {
            return;
        }
        Object menu = methodMenuFactory_buildGuide.invoke(menuFactory, new Object[]{null, null});
        if (menu == null) {
            return;
        }
        if (methodCustomMenu_open == null) {
            return;
        }
        methodCustomMenu_open.invoke(menu, player);
        SpecialMenuProvider.insertUselessHistory(playerProfile);
    }

    public static boolean isLogiTechItem(@Nonnull SlimefunItem slimefunItem) {
        if (!ENABLED_LogiTech) {
            return false;
        }
        String addonName = slimefunItem.getAddon().getName();
        return "LogiTech".equals(addonName) && slimefunItem.getRecipe().length > 9;
    }

    public static void openInfinityMenu(@Nonnull Player player, @Nonnull PlayerProfile playerProfile, @Nonnull SlimefunItem slimefunItem, @Nonnull SlimefunGuideMode slimefunGuideMode) throws InvocationTargetException, InstantiationException, IllegalAccessException {
        if (!ENABLED_InfinityExpansion) {
            return;
        }
        if (SpecialMenuProvider.isInfinityItem(slimefunItem)) {
            if (SpecialMenuProvider.isPlayerResearchedInfinity(player, playerProfile, slimefunItem)) {
                if (constructorInfinityExpansion_BackEntry == null || methodInfinityGroup_openInfinityRecipe == null) {
                    return;
                }
                Object backEntry = constructorInfinityExpansion_BackEntry.newInstance(null, playerProfile, Slimefun.getRegistry().getSlimefunGuide(slimefunGuideMode));
                methodInfinityGroup_openInfinityRecipe.invoke(null, player, slimefunItem.getId(), backEntry);
                SpecialMenuProvider.insertUselessHistory(playerProfile);
                SpecialMenuProvider.insertUselessHistory(playerProfile);
            } else {
                Object object = objectInfinityExpansion_INFINITY;
                if (object instanceof FlexItemGroup) {
                    FlexItemGroup flexItemGroup = (FlexItemGroup)object;
                    flexItemGroup.open(player, playerProfile, slimefunGuideMode);
                }
            }
        }
    }

    public static boolean isPlayerResearchedInfinity(@Nonnull Player player, @Nonnull PlayerProfile playerProfile, @Nonnull SlimefunItem slimefunItem) {
        if (!ENABLED_InfinityExpansion) {
            return false;
        }
        if (SpecialMenuProvider.isInfinityItem(slimefunItem)) {
            Research research = slimefunItem.getResearch();
            if (research == null) {
                return true;
            }
            return playerProfile.hasUnlocked(research);
        }
        return false;
    }

    public static boolean isInfinityItem(@Nonnull SlimefunItem slimefunItem) {
        if (!ENABLED_InfinityExpansion) {
            return false;
        }
        String addonName = slimefunItem.getAddon().getName();
        return "InfinityExpansion".equals(addonName) && slimefunItem.getRecipe().length > 9;
    }

    public static void openObsidianForgeMenu(@Nonnull Player player, @Nonnull PlayerProfile playerProfile, @Nonnull SlimefunItem slimefunItem, @Nonnull SlimefunGuideMode slimefunGuideMode) throws InvocationTargetException, InstantiationException, IllegalAccessException {
        if (!ENABLED_ObsidianExpansion) {
            return;
        }
        if (SpecialMenuProvider.isObsidianForgeItem(slimefunItem)) {
            if (constructorObsidianExpansion_BackEntry == null || methodObsidianExpansion_openFORGERecipe == null) {
                return;
            }
            Object backEntry = constructorObsidianExpansion_BackEntry.newInstance(null, playerProfile, Slimefun.getRegistry().getSlimefunGuide(slimefunGuideMode));
            methodObsidianExpansion_openFORGERecipe.invoke(null, player, slimefunItem.getId(), backEntry);
            SpecialMenuProvider.insertUselessHistory(playerProfile);
        }
    }

    public static boolean isObsidianForgeItem(@Nonnull SlimefunItem slimefunItem) {
        if (!ENABLED_ObsidianExpansion) {
            return false;
        }
        String addonName = slimefunItem.getAddon().getName();
        return "ObsidianExpansion".equals(addonName) && slimefunItem.getRecipe().length > 9;
    }

    public static boolean isInfinityExpansionSingularityItem(@Nonnull SlimefunItem slimefunItem) {
        return classInfinityExpansion_Singularity != null && slimefunItem.getClass() == classInfinityExpansion_Singularity;
    }

    public static void openInfinityExpansionSingularityMenu(@Nonnull Player player, @Nonnull PlayerProfile playerProfile, @Nonnull SlimefunItem slimefunItem) throws InvocationTargetException, IllegalAccessException {
        if (!ENABLED_InfinityExpansion || !ENABLED_LogiTech) {
            return;
        }
        if (SpecialMenuProvider.isInfinityExpansionSingularityItem(slimefunItem)) {
            SpecialMenuProvider.openLogiTechMenu(player, playerProfile, slimefunItem);
        }
    }

    public static boolean open(@Nonnull Player player, @Nonnull PlayerProfile playerProfile, @Nonnull SlimefunGuideMode slimefunGuideMode, @Nonnull SlimefunItem slimefunItem) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        if (player == null) {
            return false;
        }
        if (SpecialMenuProvider.isFinalTECHItem(slimefunItem)) {
            FlexItemGroup flexItemGroup = SpecialMenuProvider.getFinalTECHRecipeItemGroup(player, playerProfile, slimefunGuideMode, slimefunItem);
            if (flexItemGroup != null) {
                flexItemGroup.open(player, playerProfile, slimefunGuideMode);
                Debug.debug("Opened FinalTECH special menu");
                return true;
            }
        } else {
            if (SpecialMenuProvider.isNexcavateItem(slimefunItem)) {
                SpecialMenuProvider.openNexcavateGuide(player, slimefunItem);
                Debug.debug("Opened Nexcavate special menu");
                return true;
            }
            if (SpecialMenuProvider.isLogiTechItem(slimefunItem)) {
                SpecialMenuProvider.openLogiTechMenu(player, playerProfile, slimefunItem);
                Debug.debug("Opened LogiTech special menu");
                return true;
            }
            if (SpecialMenuProvider.isInfinityExpansionSingularityItem(slimefunItem)) {
                SpecialMenuProvider.openInfinityExpansionSingularityMenu(player, playerProfile, slimefunItem);
                Debug.debug("Opened InfinityExpansion Singularity special menu");
                return true;
            }
            if (SpecialMenuProvider.isInfinityItem(slimefunItem)) {
                SpecialMenuProvider.openInfinityMenu(player, playerProfile, slimefunItem, slimefunGuideMode);
                Debug.debug("Opened InfinityExpansion special menu");
                return true;
            }
            if (SpecialMenuProvider.isObsidianForgeItem(slimefunItem)) {
                SpecialMenuProvider.openObsidianForgeMenu(player, playerProfile, slimefunItem, slimefunGuideMode);
                Debug.debug("Opened ObsidianExpansion special menu");
                return true;
            }
        }
        return false;
    }

    public static void fallbackOpen(@Nonnull Player player, @Nonnull PlayerProfile playerProfile, @Nonnull SlimefunGuideMode slimefunGuideMode, @Nonnull SlimefunItem slimefunItem) {
        SlimefunGuideImplementation implementation = Slimefun.getRegistry().getSlimefunGuide(slimefunGuideMode);
        if (implementation instanceof JEGSlimefunGuideImplementation) {
            JEGSlimefunGuideImplementation jeg = (JEGSlimefunGuideImplementation)implementation;
            jeg.displayItem(playerProfile, slimefunItem, true, false);
        } else {
            implementation.displayItem(playerProfile, slimefunItem, true);
        }
    }

    public static void insertUselessHistory(@NotNull PlayerProfile playerProfile) {
        playerProfile.getGuideHistory().add(PLACEHOLDER_SEARCH_TERM);
    }

    @Generated
    private SpecialMenuProvider() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        Constructor<?> constructor2;
        Method method4;
        methodRecipeItemGroup_getBySlimefunItem = null;
        methodPlayerProgress_get = null;
        methodNEGUI_openRecipe = null;
        methodNEGUI_openResearchScreen = null;
        methodNexcavateRegistry_getResearchMap = null;
        objectNexcavate_registry = null;
        methodMenuUtils_createItemRecipeDisplay = null;
        methodMenuFactory_buildGuide = null;
        methodCustomMenu_open = null;
        methodInfinityGroup_openInfinityRecipe = null;
        objectInfinityExpansion_INFINITY = null;
        constructorInfinityExpansion_BackEntry = null;
        classInfinityExpansion_Singularity = null;
        methodObsidianExpansion_openFORGERecipe = null;
        constructorObsidianExpansion_BackEntry = null;
        ENABLED_FinalTECH = Bukkit.getPluginManager().isPluginEnabled("FinalTECH") || Bukkit.getPluginManager().isPluginEnabled("FinalTECH-Changed");
        ENABLED_Nexcavate = Bukkit.getPluginManager().isPluginEnabled("Nexcavate");
        ENABLED_LogiTech = Bukkit.getPluginManager().isPluginEnabled("LogiTech");
        ENABLED_InfinityExpansion = Bukkit.getPluginManager().isPluginEnabled("InfinityExpansion");
        ENABLED_ObsidianExpansion = Bukkit.getPluginManager().isPluginEnabled("ObsidianExpansion");
        try {
            method4 = ReflectionUtil.getMethod(Class.forName("io.taraxacum.finaltech.core.group.RecipeItemGroup"), "getBySlimefunItem", Player.class, PlayerProfile.class, SlimefunGuideMode.class, SlimefunItem.class, Integer.TYPE);
            if (method4 != null) {
                method4.setAccessible(true);
                methodRecipeItemGroup_getBySlimefunItem = method4;
            }
        }
        catch (ClassNotFoundException method2) {
            // empty catch block
        }
        try {
            method4 = ReflectionUtil.getMethod(Class.forName("me.char321.nexcavate.research.progress.PlayerProgress"), "get", Player.class);
            if (method4 != null) {
                method4.setAccessible(true);
                methodPlayerProgress_get = method4;
            }
        }
        catch (ClassNotFoundException method3) {
            // empty catch block
        }
        try {
            method4 = ReflectionUtil.getMethod(Class.forName("me.char321.nexcavate.gui.NEGUI"), "openRecipe");
            if (method4 != null) {
                method4.setAccessible(true);
                methodNEGUI_openRecipe = method4;
            }
        }
        catch (ClassNotFoundException method4) {
            // empty catch block
        }
        try {
            method4 = ReflectionUtil.getMethod(Class.forName("me.char321.nexcavate.gui.NEGUI"), "openResearchScreen");
            if (method4 != null) {
                method4.setAccessible(true);
                methodNEGUI_openResearchScreen = method4;
            }
        }
        catch (ClassNotFoundException method5) {
            // empty catch block
        }
        try {
            method4 = ReflectionUtil.getMethod(Class.forName("me.char321.nexcavate.NexcavateRegistry"), "getResearchMap");
            if (method4 != null) {
                method4.setAccessible(true);
                methodNexcavateRegistry_getResearchMap = method4;
            }
        }
        catch (ClassNotFoundException method6) {
            // empty catch block
        }
        try {
            Object instance = ReflectionUtil.getStaticValue(Class.forName("me.char321.nexcavate.Nexcavate"), "instance");
            if (instance != null) {
                objectNexcavate_registry = ReflectionUtil.getValue(instance, "registry");
            }
        }
        catch (ClassNotFoundException instance) {
            // empty catch block
        }
        try {
            method4 = ReflectionUtil.getMethod(Class.forName("me.matl114.logitech.Utils.MenuUtils"), "createItemRecipeDisplay", 3);
            if (method4 != null) {
                method4.setAccessible(true);
                methodMenuUtils_createItemRecipeDisplay = method4;
            }
        }
        catch (ClassNotFoundException method7) {
            // empty catch block
        }
        try {
            method4 = ReflectionUtil.getMethod(Class.forName("me.matl114.logitech.Utils.UtilClass.MenuClass.MenuFactory"), "buildGuide");
            if (method4 != null) {
                method4.setAccessible(true);
                methodMenuFactory_buildGuide = method4;
            }
        }
        catch (ClassNotFoundException method8) {
            // empty catch block
        }
        try {
            method4 = ReflectionUtil.getMethod(Class.forName("me.matl114.logitech.Utils.UtilClass.MenuClass.CustomMenu"), "open");
            if (method4 != null) {
                method4.setAccessible(true);
                methodCustomMenu_open = method4;
            }
        }
        catch (ClassNotFoundException method9) {
            // empty catch block
        }
        try {
            constructor2 = ReflectionUtil.getConstructor(Class.forName("io.github.mooy1.infinityexpansion.categories.InfinityGroup$BackEntry"), BlockMenu.class, PlayerProfile.class, SlimefunGuideImplementation.class);
            if (constructor2 != null) {
                constructor2.setAccessible(true);
                constructorInfinityExpansion_BackEntry = constructor2;
            }
        }
        catch (ClassNotFoundException constructor2) {
            // empty catch block
        }
        try {
            Object object = ReflectionUtil.getStaticValue(Class.forName("io.github.mooy1.infinityexpansion.categories.Groups"), "INFINITY");
            if (object != null) {
                objectInfinityExpansion_INFINITY = object;
            }
        }
        catch (ClassNotFoundException object) {
            // empty catch block
        }
        try {
            method4 = ReflectionUtil.getMethod(Class.forName("io.github.mooy1.infinityexpansion.categories.InfinityGroup"), "openInfinityRecipe");
            if (method4 != null) {
                method4.setAccessible(true);
                methodInfinityGroup_openInfinityRecipe = method4;
            }
        }
        catch (ClassNotFoundException method10) {
            // empty catch block
        }
        try {
            Class<?> clazz = Class.forName("io.github.mooy1.infinityexpansion.items.materials.Singularity");
            if (clazz != null) {
                classInfinityExpansion_Singularity = clazz;
            }
        }
        catch (ClassNotFoundException ignored) {
            classInfinityExpansion_Singularity = null;
        }
        try {
            constructor2 = ReflectionUtil.getConstructor(Class.forName("me.lucasgithuber.obsidianexpansion.utils.ObsidianForgeGroup$BackEntry"), BlockMenu.class, PlayerProfile.class, SlimefunGuideImplementation.class);
            if (constructor2 != null) {
                constructor2.setAccessible(true);
                constructorObsidianExpansion_BackEntry = constructor2;
            }
        }
        catch (ClassNotFoundException constructor3) {
            // empty catch block
        }
        try {
            method4 = ReflectionUtil.getMethod(Class.forName("me.lucasgithuber.obsidianexpansion.utils.ObsidianForgeGroup"), "openFORGERecipe");
            if (method4 != null) {
                method4.setAccessible(true);
                methodObsidianExpansion_openFORGERecipe = method4;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        Debug.debug("SpecialMenuProvider initialized");
        Debug.debug("ENABLED_FinalTECH: " + ENABLED_FinalTECH);
        Debug.debug("ENABLED_Nexcavate: " + ENABLED_Nexcavate);
        Debug.debug("ENABLED_LogiTech: " + ENABLED_LogiTech);
        Debug.debug("ENABLED_InfinityExpansion: " + ENABLED_InfinityExpansion);
        Debug.debug("ENABLED_ObsidianExpansion: " + ENABLED_ObsidianExpansion);
        Debug.debug("-------------FinalTECH | FinalTECH-Changed-------------");
        Debug.debug("methodRecipeItemGroup_getBySlimefunItem: " + (methodRecipeItemGroup_getBySlimefunItem != null));
        Debug.debug("-------------Nexcavate------------");
        Debug.debug("methodPlayerProgress_get: " + (methodPlayerProgress_get != null));
        Debug.debug("methodNEGUI_openRecipe: " + (methodNEGUI_openRecipe != null));
        Debug.debug("methodNEGUI_openResearchScreen: " + (methodNEGUI_openResearchScreen != null));
        Debug.debug("-------------LogiTech-------------");
        Debug.debug("methodMenuUtils_createItemRecipeDisplay: " + (methodMenuUtils_createItemRecipeDisplay != null));
        Debug.debug("methodMenuFactory_build: " + (methodMenuFactory_buildGuide != null));
        Debug.debug("methodCustomMenu_open: " + (methodCustomMenu_open != null));
        Debug.debug("-------------InfinityExpansion----------");
        Debug.debug("methodInfinityGroup_openInfinityRecipe: " + (methodInfinityGroup_openInfinityRecipe != null));
        Debug.debug("constructorInfinityExpansion_BackEntry: " + (constructorInfinityExpansion_BackEntry != null));
        Debug.debug("-------------ObsidianExpansion----------");
        Debug.debug("methodObsidianExpansion_openFORGERecipe: " + (methodObsidianExpansion_openFORGERecipe != null));
        Debug.debug("constructorObsidianExpansion_BackEntry: " + (constructorObsidianExpansion_BackEntry != null));
    }

    public static class CustomMenuHandlerImpl
    implements CustomMenuHandler {
        public // Could not load outer class - annotation placement on inner may be incorrect
         @NotNull ChestMenu.MenuClickHandler getInstance(CustomMenu menu) {
            return (p, s, i, a) -> {
                PlayerProfile.find((OfflinePlayer)p).ifPresent(playerProfile -> playerProfile.getGuideHistory().goBack(Slimefun.getRegistry().getSlimefunGuide(SlimefunGuideMode.SURVIVAL_MODE)));
                return false;
            };
        }
    }
}

