/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.utils.platform.scheduler;

import com.balugaq.jeg.implementation.JustEnoughGuide;
import com.balugaq.jeg.utils.platform.PlatformUtil;
import com.balugaq.jeg.utils.platform.scheduler.BukkitTaskScheduler;
import com.balugaq.jeg.utils.platform.scheduler.FoliaTaskScheduler;
import com.balugaq.jeg.utils.platform.scheduler.LeafTaskScheduler;
import com.balugaq.jeg.utils.platform.scheduler.LeavesTaskScheduler;
import com.balugaq.jeg.utils.platform.scheduler.PaperTaskScheduler;
import com.balugaq.jeg.utils.platform.scheduler.PufferfishTaskScheduler;
import com.balugaq.jeg.utils.platform.scheduler.PurpurTaskScheduler;
import com.balugaq.jeg.utils.platform.scheduler.SpigotTaskScheduler;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public interface TaskScheduler {
    @NotNull
    public static Server getServer() {
        return Bukkit.getServer();
    }

    @NotNull
    public static TaskScheduler create() {
        if (PlatformUtil.isLeaves()) {
            return new LeavesTaskScheduler();
        }
        if (PlatformUtil.isLeaf()) {
            return new LeafTaskScheduler();
        }
        if (PlatformUtil.isFolia()) {
            return new FoliaTaskScheduler();
        }
        if (PlatformUtil.isPurpur()) {
            return new PurpurTaskScheduler();
        }
        if (PlatformUtil.isPufferfish()) {
            return new PufferfishTaskScheduler();
        }
        if (PlatformUtil.isPaper()) {
            return new PaperTaskScheduler();
        }
        if (PlatformUtil.isSpigot()) {
            return new SpigotTaskScheduler();
        }
        if (PlatformUtil.isBukkit()) {
            return new BukkitTaskScheduler();
        }
        throw new IllegalStateException("Unknown Platform, unable to create TaskScheduler");
    }

    @NotNull
    default public Plugin getPlugin() {
        return JustEnoughGuide.getInstance();
    }

    public void runNextTick(@NotNull Runnable var1);

    public void runLater(@NotNull Runnable var1, long var2);

    public void runLaterAsync(@NotNull Runnable var1, long var2);

    public void runTimer(@NotNull Runnable var1, long var2, long var4);

    public void runTimerAsync(@NotNull Runnable var1, long var2, long var4);
}

