/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.api.patches;

import com.balugaq.jeg.api.objects.enums.PatchScope;
import com.balugaq.jeg.api.patches.JEGContributorsMenu;
import com.balugaq.jeg.implementation.option.delegate.FireworksOption;
import com.balugaq.jeg.implementation.option.delegate.GuideModeOption;
import com.balugaq.jeg.implementation.option.delegate.LearningAnimationOption;
import com.balugaq.jeg.implementation.option.delegate.PlayerLanguageOption;
import com.balugaq.jeg.utils.ReflectionUtil;
import com.balugaq.jeg.utils.compatibility.Converter;
import com.balugaq.jeg.utils.formatter.Formats;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuide;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideMode;
import io.github.thebusybiscuit.slimefun4.core.guide.options.SlimefunGuideOption;
import io.github.thebusybiscuit.slimefun4.core.guide.options.SlimefunGuideSettings;
import io.github.thebusybiscuit.slimefun4.core.services.LocalizationService;
import io.github.thebusybiscuit.slimefun4.core.services.github.GitHubService;
import io.github.thebusybiscuit.slimefun4.core.services.sounds.SoundEffect;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.github.thebusybiscuit.slimefun4.utils.NumberUtils;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public class JEGGuideSettings {
    private static final List<SlimefunGuideOption<?>> patched = new ArrayList();

    public static void openSettings(@NotNull Player p, @NotNull ItemStack guide) {
        JEGGuideSettings.openSettings(p, guide, 1);
    }

    public static void openSettings(@NotNull Player p, @NotNull ItemStack guide, @Range(from=1L, to=0x7FFFFFFFL) int page) {
        ChestMenu menu = new ChestMenu(Slimefun.getLocalization().getMessage(p, "guide.title.settings"));
        menu.setEmptySlotsClickable(false);
        menu.addMenuOpeningHandler(arg_0 -> ((SoundEffect)SoundEffect.GUIDE_OPEN_SETTING_SOUND).playFor(arg_0));
        ChestMenuUtils.drawBackground((ChestMenu)menu, (int[])Formats.settings.getChars('B').stream().mapToInt(i -> i).toArray());
        JEGGuideSettings.addHeader(p, menu, guide);
        JEGGuideSettings.addConfigurableOptions(p, menu, guide, page);
        Formats.settings.renderCustom(menu);
        menu.open(new Player[]{p});
    }

    private static void addHeader(@NotNull Player p, @NotNull ChestMenu menu, @NotNull ItemStack guide) {
        LocalizationService locale = Slimefun.getLocalization();
        ItemStack b = PatchScope.Background.patch(p, Converter.getItem(SlimefunGuide.getItem((SlimefunGuideMode)SlimefunGuideMode.SURVIVAL_MODE), "&e\u21e6 " + locale.getMessage(p, "guide.back.title"), "", "&7" + locale.getMessage(p, "guide.back.guide")));
        for (int ss : Formats.settings.getChars('b')) {
            menu.addItem(ss, b, (pl, slot, item, action) -> {
                SlimefunGuide.openGuide((Player)pl, (ItemStack)guide);
                return false;
            });
        }
        GitHubService github = Slimefun.getGitHubService();
        ArrayList<Object> contributorsLore = new ArrayList<Object>();
        contributorsLore.add("");
        contributorsLore.addAll(locale.getMessages(p, "guide.credits.description", msg -> msg.replace("%contributors%", String.valueOf(github.getContributors().size()))));
        contributorsLore.add("");
        contributorsLore.add("&7\u21e8 &e" + locale.getMessage(p, "guide.credits.open"));
        ItemStack s = PatchScope.SettingsContributors.patch(p, Converter.getItem(SlimefunUtils.getCustomHead((String)"e952d2b3f351a6b0487cc59db31bf5f2641133e5ba0006b18576e996a0293e52"), "&c" + locale.getMessage(p, "guide.title.credits"), contributorsLore.toArray(new String[0])));
        for (int ss : Formats.settings.getChars('s')) {
            menu.addItem(ss, s, (pl, slot, action, item) -> {
                JEGContributorsMenu.open(pl, 0);
                return false;
            });
        }
        ItemStack v = PatchScope.SlimefunVersion.patch(p, Converter.getItem(Material.WRITABLE_BOOK, String.valueOf(ChatColor.GREEN) + locale.getMessage(p, "guide.title.versions"), "&7&o" + locale.getMessage(p, "guide.tooltips.versions-notice"), "", "&fMinecraft: &a" + Bukkit.getBukkitVersion(), "&fSlimefun: &a" + Slimefun.getVersion()));
        for (int ss : Formats.settings.getChars('v')) {
            menu.addItem(ss, v, ChestMenuUtils.getEmptyClickHandler());
        }
        ItemStack u = PatchScope.SlimefunSourceCode.patch(p, Converter.getItem(Material.COMPARATOR, "&e" + locale.getMessage(p, "guide.title.source"), "", "&7Last Activity: &a" + NumberUtils.getElapsedTime((LocalDateTime)github.getLastUpdate()) + " ago", "&7Forks: &e" + github.getForks(), "&7Stars: &e" + github.getStars(), "", "&7&oSlimefun 4 is a community project,", "&7&othe source code is available on GitHub", "&7&oand if you want to keep this Plugin alive,", "&7&othen please consider contributing to it", "", "&7\u21e8 &eClick to go to GitHub"));
        for (int ss : Formats.settings.getChars('u')) {
            menu.addItem(ss, u, (pl, slot, item, action) -> {
                pl.closeInventory();
                ChatUtils.sendURL((CommandSender)pl, (String)"https://github.com/SlimefunGuguProject/Slimefun4");
                return false;
            });
        }
        ItemStack W = PatchScope.SlimefunWiki.patch(p, Converter.getItem(Material.KNOWLEDGE_BOOK, "&3" + locale.getMessage(p, "guide.title.wiki"), "", "&7Do you need help with an Item or machine?", "&7You cannot figure out what to do?", "&7Check out our community-maintained Wiki", "&7and become one of our Editors!", "", "&7\u21e8 &eClick to go to the official Slimefun Wiki"));
        for (int ss : Formats.settings.getChars('W')) {
            menu.addItem(ss, W, (pl, slot, item, action) -> {
                pl.closeInventory();
                ChatUtils.sendURL((CommandSender)pl, (String)"https://slimefun-wiki.guizhanss.cn/");
                return false;
            });
        }
        ItemStack l = PatchScope.AddonCount.patch(p, Converter.getItem(Material.BOOKSHELF, "&3" + locale.getMessage(p, "guide.title.addons"), "", "&7Slimefun is huge. But its addons are what makes", "&7this plugin truly shine. Go check them out, some", "&7of them may be exactly what you were missing out on!", "", "&7Installed on this Server: &b" + Slimefun.getInstalledAddons().size(), "", "&7\u21e8 &eClick to see all available addons for Slimefun4"));
        for (int ss : Formats.settings.getChars('l')) {
            menu.addItem(ss, l, (pl, slot, item, action) -> {
                pl.closeInventory();
                ChatUtils.sendURL((CommandSender)pl, (String)"https://slimefun-wiki.guizhanss.cn/Addons");
                return false;
            });
        }
        for (int ss : Formats.settings.getChars('z')) {
            if (Slimefun.getUpdater().getBranch().isOfficial()) {
                menu.addItem(ss, PatchScope.UnofficialTips.patch(p, Converter.getItem(Material.REDSTONE_TORCH, "&4" + locale.getMessage(p, "guide.title.bugs"), "", "&7&oBug reports have to be made in English!", "", "&7Open Issues: &a" + github.getOpenIssues(), "&7Pending Pull Requests: &a" + github.getPendingPullRequests(), "", "&7\u21e8 &eClick to go to the Slimefun4 Bug Tracker")));
                menu.addMenuClickHandler(ss, (pl, slot, item, action) -> {
                    pl.closeInventory();
                    ChatUtils.sendURL((CommandSender)pl, (String)"https://github.com/Slimefun/Slimefun4/issues");
                    return false;
                });
                continue;
            }
            menu.addItem(ss, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
        }
        for (int ss : Formats.settings.getChars('U')) {
            menu.addItem(ss, PatchScope.UnknownFeature.patch(p, Converter.getItem(Material.TOTEM_OF_UNDYING, String.valueOf(ChatColor.RED) + locale.getMessage(p, "guide.work-in-progress"), new String[0])), (pl, slot, item, action) -> false);
        }
    }

    private static void addConfigurableOptions(@NotNull Player p, @NotNull ChestMenu menu, @NotNull ItemStack guide, @Range(from=1L, to=0x7FFFFFFFL) int page) {
        List<Integer> slots = Formats.settings.getChars('o');
        ArrayList options = new ArrayList(JEGGuideSettings.getOptions());
        options.removeIf(option -> {
            String sm = option.getClass().getSimpleName();
            return option.getAddon() instanceof Slimefun && (sm.equals("FireworksOption") || sm.equals("LearningAnimationOption"));
        });
        int maxPage = (int)Math.ceil((double)options.size() / (double)slots.size());
        List split = options.stream().skip((long)(page - 1) * (long)slots.size()).limit(slots.size()).toList();
        int fail = 0;
        for (int i = 0; i < split.size(); ++i) {
            SlimefunGuideOption option2 = (SlimefunGuideOption)split.get(i);
            if (fail > i) {
                fail = i;
            }
            int slot2 = slots.get(i - fail);
            Optional item2 = option2.getDisplayItem(p, guide);
            if (item2.isPresent()) {
                menu.addItem(slot2, PatchScope.GuideOption.patch(p, (ItemStack)item2.get()));
                menu.addMenuClickHandler(slot2, (pl, s, stack, action) -> {
                    option2.onClick(p, guide);
                    return false;
                });
                continue;
            }
            ++fail;
        }
        for (int ss : Formats.settings.getChars('P')) {
            menu.addItem(ss, ChestMenuUtils.getPreviousButton((Player)p, (int)page, (int)maxPage));
            menu.addMenuClickHandler(ss, (pl, slot, item, action) -> {
                if (page > 1) {
                    JEGGuideSettings.openSettings(pl, guide, page - 1);
                }
                return false;
            });
        }
        for (int ss : Formats.settings.getChars('N')) {
            menu.addItem(ss, ChestMenuUtils.getNextButton((Player)p, (int)page, (int)maxPage));
            menu.addMenuClickHandler(ss, (pl, slot, item, action) -> {
                if (page + 1 < maxPage) {
                    JEGGuideSettings.openSettings(pl, guide, page + 1);
                }
                return false;
            });
        }
    }

    @NotNull
    public static List<SlimefunGuideOption<?>> getOptions() {
        return ReflectionUtil.getStaticValue(SlimefunGuideSettings.class, "options", List.class);
    }

    public static void addOption(@NotNull SlimefunGuideOption<?> option) {
        SlimefunGuideSettings.addOption(option);
    }

    public static void patchSlimefun() {
        for (SlimefunGuideOption<?> option : JEGGuideSettings.getOptions()) {
            String sm;
            if (!(option.getAddon() instanceof Slimefun) || (sm = option.getClass().getSimpleName()).equals("FireworksOption") || sm.equals("LearningAnimationOption")) continue;
            patched.add(option);
        }
        for (SlimefunGuideOption<?> po : patched) {
            JEGGuideSettings.getOptions().remove(po);
        }
        JEGGuideSettings.addOption(new GuideModeOption());
        JEGGuideSettings.addOption(new FireworksOption());
        JEGGuideSettings.addOption(new LearningAnimationOption());
        JEGGuideSettings.addOption(new PlayerLanguageOption());
    }

    public static void unpatchSlimefun() {
        for (SlimefunGuideOption<?> po : patched) {
            JEGGuideSettings.getOptions().add(po);
        }
    }

    public static boolean hasFireworksEnabled(@NotNull Player p) {
        return JEGGuideSettings.getOptionValue(p, FireworksOption.class, true);
    }

    public static boolean hasLearningAnimationEnabled(@NotNull Player p) {
        return JEGGuideSettings.getOptionValue(p, LearningAnimationOption.class, true);
    }

    @NotNull
    public static <T extends SlimefunGuideOption<V>, V> V getOptionValue(@NotNull Player p, @NotNull Class<T> optionsClass, @NotNull V defaultValue) {
        for (SlimefunGuideOption<?> option : JEGGuideSettings.getOptions()) {
            if (!optionsClass.isInstance(option)) continue;
            SlimefunGuideOption o = (SlimefunGuideOption)optionsClass.cast(option);
            ItemStack guide = SlimefunGuide.getItem((SlimefunGuideMode)SlimefunGuideMode.SURVIVAL_MODE);
            return o.getSelectedOption(p, guide).orElse(defaultValue);
        }
        return defaultValue;
    }

    @Generated
    public static List<SlimefunGuideOption<?>> getPatched() {
        return patched;
    }
}

