/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.utils;

import com.balugaq.jeg.utils.Debug;
import io.github.thebusybiscuit.slimefun4.libraries.dough.collections.Pair;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public final class ReflectionUtil {
    public static boolean setValue(@NotNull Object object, @NotNull String field, @Nullable Object value) {
        try {
            Field declaredField = ReflectionUtil.getField(object.getClass(), field);
            if (declaredField == null) {
                throw new NoSuchFieldException(field);
            }
            declaredField.setAccessible(true);
            declaredField.set(object, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            Debug.trace(e);
            return false;
        }
        return true;
    }

    public static <T> boolean setStaticValue(@NotNull Class<T> clazz, @NotNull String field, @Nullable Object value) {
        try {
            Field declaredField = ReflectionUtil.getField(clazz, field);
            if (declaredField == null) {
                throw new NoSuchFieldException(field);
            }
            declaredField.setAccessible(true);
            declaredField.set(null, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            Debug.trace(e);
            return false;
        }
        return true;
    }

    @Nullable
    public static Object getStaticValue(@NotNull Class<?> clazz, @NotNull String field) {
        try {
            Field declaredField = ReflectionUtil.getField(clazz, field);
            if (declaredField == null) {
                throw new NoSuchFieldException(field);
            }
            declaredField.setAccessible(true);
            return declaredField.get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            Debug.trace(e);
            return null;
        }
    }

    @Nullable
    public static <T> T getStaticValue(@NotNull Class<?> clazz, @NotNull String field, @NotNull Class<T> cast) {
        try {
            Field declaredField = ReflectionUtil.getField(clazz, field);
            if (declaredField == null) {
                throw new NoSuchFieldException(field);
            }
            declaredField.setAccessible(true);
            return (T)declaredField.get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            Debug.trace(e);
            return null;
        }
    }

    @Nullable
    public static Method getMethod(@NotNull Class<?> clazz, @NotNull String methodName, boolean noargs) {
        while (clazz != Object.class) {
            for (Method method : clazz.getDeclaredMethods()) {
                if (!method.getName().equals(methodName) || noargs && method.getParameterTypes().length != 0) continue;
                return method;
            }
            clazz = clazz.getSuperclass();
        }
        return ReflectionUtil.getMethod(clazz, methodName);
    }

    @Nullable
    public static Method getMethod(@NotNull Class<?> clazz, @NotNull String methodName) {
        while (clazz != Object.class) {
            for (Method method : clazz.getDeclaredMethods()) {
                if (!method.getName().equals(methodName)) continue;
                return method;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    @Nullable
    public static Method getMethod(@NotNull Class<?> clazz, @NotNull String methodName, @Range(from=0L, to=32767L) int parameterCount) {
        while (clazz != Object.class) {
            for (Method method : clazz.getDeclaredMethods()) {
                if (!method.getName().equals(methodName) || method.getParameterTypes().length != parameterCount) continue;
                return method;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    @Nullable
    public static Method getMethod(@NotNull Class<?> clazz, @NotNull String methodName, Class<?> ... parameterTypes) {
        while (clazz != Object.class) {
            for (Method method : clazz.getDeclaredMethods()) {
                int i;
                if (!method.getName().equals(methodName) || method.getParameterTypes().length != parameterTypes.length) continue;
                boolean match = true;
                for (i = 0; i < parameterTypes.length; ++i) {
                    if (method.getParameterTypes()[i] == parameterTypes[i]) continue;
                    match = false;
                    break;
                }
                if (!match) {
                    match = true;
                    for (i = 0; i < parameterTypes.length; ++i) {
                        if (method.getParameterTypes()[i].isAssignableFrom(parameterTypes[i])) continue;
                        match = false;
                        break;
                    }
                }
                if (!match) continue;
                return method;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    @Nullable
    public static Field getField(@NotNull Class<?> clazz, @NotNull String fieldName) {
        while (clazz != Object.class) {
            for (Field field : clazz.getDeclaredFields()) {
                if (!field.getName().equals(fieldName)) continue;
                return field;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    @Nullable
    public static Class<?> getClass(@NotNull Class<?> clazz, @NotNull String className) {
        while (clazz != Object.class) {
            if (clazz.getSimpleName().equals(className)) {
                return clazz;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    @Nullable
    public static <T> T getValue(@NotNull Object object, @NotNull String fieldName, @NotNull Class<T> cast) {
        try {
            Field field = ReflectionUtil.getField(object.getClass(), fieldName);
            if (field != null) {
                field.setAccessible(true);
                return (T)field.get(object);
            }
        }
        catch (IllegalAccessException e) {
            Debug.trace(e);
            return null;
        }
        return null;
    }

    @Nullable
    public static Object getValue(@NotNull Object object, @NotNull String fieldName) {
        try {
            Field field = ReflectionUtil.getField(object.getClass(), fieldName);
            if (field != null) {
                field.setAccessible(true);
                return field.get(object);
            }
        }
        catch (IllegalAccessException e) {
            Debug.trace(e);
            return null;
        }
        return null;
    }

    @Nullable
    public static <T, V> T getProperty(Object o, @NotNull Class<V> clazz, @NotNull String fieldName) throws IllegalAccessException {
        Field field = ReflectionUtil.getField(clazz, fieldName);
        if (field != null) {
            boolean b = field.canAccess(o);
            field.setAccessible(true);
            Object result = field.get(o);
            field.setAccessible(b);
            return (T)result;
        }
        return null;
    }

    @Nullable
    public static Pair<Field, Class<?>> getDeclaredFieldsRecursively(@NotNull Class<?> clazz, @NotNull String fieldName) {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            return new Pair((Object)field, clazz);
        }
        catch (Exception e) {
            clazz = clazz.getSuperclass();
            if (clazz == null) {
                return null;
            }
            return ReflectionUtil.getDeclaredFieldsRecursively(clazz, fieldName);
        }
    }

    @Nullable
    public static Constructor<?> getConstructor(@NotNull Class<?> clazz, Class<?> ... parameterTypes) {
        try {
            return clazz.getDeclaredConstructor(parameterTypes);
        }
        catch (NoSuchMethodException e) {
            Debug.trace(e);
            return null;
        }
    }

    @Nullable
    public static Object invokeMethod(@NotNull Object object, @NotNull String methodName, Object ... args) {
        try {
            Method method;
            if (args == null) {
                method = ReflectionUtil.getMethod(object.getClass(), methodName, 1);
            } else {
                boolean containsNull = false;
                for (Object arg : args) {
                    if (arg != null) continue;
                    containsNull = true;
                    break;
                }
                method = containsNull ? ReflectionUtil.getMethod(object.getClass(), methodName, args.length) : ReflectionUtil.getMethod(object.getClass(), methodName, (Class[])Arrays.stream(args).filter(Objects::nonNull).map(Object::getClass).toArray(Class[]::new));
            }
            if (method != null) {
                method.setAccessible(true);
                return method.invoke(object, args);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            Debug.trace(e);
        }
        return null;
    }

    @Nullable
    public static Object invokeStaticMethod(@NotNull Class<?> clazz, @NotNull String methodName, Object ... args) {
        try {
            Method method;
            if (args == null) {
                method = ReflectionUtil.getMethod(clazz, methodName, 1);
            } else {
                boolean containsNull = false;
                for (Object arg : args) {
                    if (arg != null) continue;
                    containsNull = true;
                    break;
                }
                method = containsNull ? ReflectionUtil.getMethod(clazz, methodName, args.length) : ReflectionUtil.getMethod(clazz, methodName, (Class[])Arrays.stream(args).filter(Objects::nonNull).map(Object::getClass).toArray(Class[]::new));
            }
            if (method != null) {
                method.setAccessible(true);
                return method.invoke(null, args);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            Debug.trace(e);
        }
        return null;
    }

    @Generated
    private ReflectionUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

