/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.utils;

import com.balugaq.jeg.utils.ItemStackUtil;
import com.balugaq.jeg.utils.StackUtils;
import com.balugaq.jeg.utils.compatibility.Converter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public final class BlockMenuUtil {
    @Nullable
    public static ItemStack pushItem(@NotNull BlockMenu blockMenu, @Nullable ItemStack item, int ... slots) {
        if (item == null || item.getType() == Material.AIR) {
            return null;
        }
        int leftAmount = item.getAmount();
        for (int slot : slots) {
            if (leftAmount <= 0) break;
            ItemStack existing = blockMenu.getItemInSlot(slot);
            if (existing == null || existing.getType() == Material.AIR) {
                int received = Math.min(leftAmount, item.getMaxStackSize());
                blockMenu.replaceExistingItem(slot, ItemStackUtil.getAsQuantity(item, received));
                item.setAmount(Math.max(0, leftAmount -= received));
                continue;
            }
            int existingAmount = existing.getAmount();
            if (existingAmount >= item.getMaxStackSize() || !StackUtils.itemsMatch(item, existing)) continue;
            int received = Math.max(0, Math.min(item.getMaxStackSize() - existingAmount, leftAmount));
            existing.setAmount(existingAmount + received);
            item.setAmount(leftAmount -= received);
        }
        if (leftAmount > 0) {
            return Converter.getItem(item, leftAmount);
        }
        return null;
    }

    @NotNull
    public static Map<ItemStack, Integer> pushItem(@NotNull BlockMenu blockMenu, @Nullable ItemStack @NotNull [] items, int ... slots) {
        if (items == null || items.length == 0) {
            return new HashMap<ItemStack, Integer>();
        }
        ArrayList<ItemStack> listItems = new ArrayList<ItemStack>();
        for (ItemStack item : items) {
            if (item == null || item.getType() == Material.AIR) continue;
            listItems.add(item);
        }
        return BlockMenuUtil.pushItem(blockMenu, listItems, slots);
    }

    @NotNull
    public static Map<ItemStack, Integer> pushItem(@NotNull BlockMenu blockMenu, @Nullable List<ItemStack> items, int ... slots) {
        if (items == null || items.isEmpty()) {
            return new HashMap<ItemStack, Integer>();
        }
        HashMap<ItemStack, Integer> itemMap = new HashMap<ItemStack, Integer>();
        for (ItemStack item : items) {
            ItemStack leftOver;
            if (item == null || item.getType() == Material.AIR || (leftOver = BlockMenuUtil.pushItem(blockMenu, item, slots)) == null) continue;
            itemMap.put(leftOver, itemMap.getOrDefault(leftOver, 0) + leftOver.getAmount());
        }
        return itemMap;
    }

    public static boolean fits(@NotNull BlockMenu blockMenu, @Nullable ItemStack item, int ... slots) {
        if (item == null || item.getType() == Material.AIR) {
            return true;
        }
        int incoming = item.getAmount();
        for (int slot : slots) {
            ItemStack stack = blockMenu.getItemInSlot(slot);
            if (stack == null || stack.getType() == Material.AIR) {
                incoming -= item.getMaxStackSize();
            } else if (stack.getMaxStackSize() > stack.getAmount() && StackUtils.itemsMatch(item, stack)) {
                incoming -= stack.getMaxStackSize() - stack.getAmount();
            }
            if (incoming > 0) continue;
            return true;
        }
        return false;
    }

    public static boolean fits(@NotNull BlockMenu blockMenu, @Nullable @Nullable ItemStack @Nullable [] items, int ... slots) {
        if (items == null || items.length == 0) {
            return false;
        }
        ArrayList<ItemStack> listItems = new ArrayList<ItemStack>();
        for (ItemStack item : items) {
            if (item == null || item.getType() == Material.AIR) continue;
            listItems.add(item.clone());
        }
        return BlockMenuUtil.fits(blockMenu, listItems, slots);
    }

    public static boolean fits(@NotNull BlockMenu blockMenu, @Nullable List<ItemStack> items, int ... slots) {
        if (items == null || items.isEmpty()) {
            return false;
        }
        ArrayList<ItemStack> cloneMenu = new ArrayList<ItemStack>();
        for (int i = 0; i < 54; ++i) {
            cloneMenu.add(null);
        }
        for (int slot : slots) {
            ItemStack stack = blockMenu.getItemInSlot(slot);
            if (stack != null && stack.getType() != Material.AIR) {
                cloneMenu.set(slot, stack.clone());
                continue;
            }
            cloneMenu.set(slot, null);
        }
        Object object = items.iterator();
        while (object.hasNext()) {
            ItemStack rawItem = (ItemStack)object.next();
            ItemStack item = rawItem.clone();
            int leftAmount = item.getAmount();
            for (int slot : slots) {
                if (leftAmount <= 0) break;
                ItemStack existing = (ItemStack)cloneMenu.get(slot);
                if (existing == null || existing.getType() == Material.AIR) {
                    int received = Math.min(leftAmount, item.getMaxStackSize());
                    cloneMenu.set(slot, ItemStackUtil.getAsQuantity(item, leftAmount));
                    item.setAmount(Math.max(0, leftAmount -= received));
                    continue;
                }
                int existingAmount = existing.getAmount();
                if (existingAmount >= item.getMaxStackSize() || !StackUtils.itemsMatch(item, existing)) continue;
                int received = Math.max(0, Math.min(item.getMaxStackSize() - existingAmount, leftAmount));
                existing.setAmount(existingAmount + received);
                item.setAmount(leftAmount -= received);
            }
            if (leftAmount <= 0) continue;
            return false;
        }
        return true;
    }

    public static void consumeItem(@NotNull BlockMenu blockMenu, @Range(from=0L, to=64L) int slot) {
        BlockMenuUtil.consumeItem(blockMenu, slot, 1);
    }

    public static void consumeItem(@NotNull BlockMenu blockMenu, @Range(from=0L, to=53L) int slot, boolean replaceConsumables) {
        BlockMenuUtil.consumeItem(blockMenu, slot, 1, replaceConsumables);
    }

    public static void consumeItem(@NotNull BlockMenu blockMenu, @Range(from=0L, to=53L) int slot, @Range(from=0L, to=64L) int amount) {
        BlockMenuUtil.consumeItem(blockMenu, slot, amount, false);
    }

    public static void consumeItem(@NotNull BlockMenu blockMenu, @Range(from=0L, to=53L) int slot, @Range(from=0L, to=64L) int amount, boolean replaceConsumables) {
        if (amount == 0) {
            return;
        }
        ItemStack item = blockMenu.getItemInSlot(slot);
        if (item != null && item.getType() != Material.AIR) {
            if (replaceConsumables && item.getAmount() == 1 && StackUtils.itemsMatch(item, new ItemStack(item.getType()))) {
                switch (item.getType()) {
                    case WATER_BUCKET: 
                    case LAVA_BUCKET: 
                    case MILK_BUCKET: 
                    case COD_BUCKET: 
                    case SALMON_BUCKET: 
                    case PUFFERFISH_BUCKET: 
                    case TROPICAL_FISH_BUCKET: 
                    case AXOLOTL_BUCKET: 
                    case POWDER_SNOW_BUCKET: 
                    case TADPOLE_BUCKET: {
                        item.setType(Material.BUCKET);
                        break;
                    }
                    case POTION: 
                    case SPLASH_POTION: 
                    case LINGERING_POTION: 
                    case HONEY_BOTTLE: 
                    case DRAGON_BREATH: {
                        item.setType(Material.GLASS_BOTTLE);
                        break;
                    }
                    case MUSHROOM_STEW: 
                    case BEETROOT_SOUP: 
                    case RABBIT_STEW: 
                    case SUSPICIOUS_STEW: {
                        item.setType(Material.BOWL);
                        break;
                    }
                    default: {
                        item.setAmount(0);
                        break;
                    }
                }
            } else if (item.getAmount() <= amount) {
                item.setAmount(0);
            } else {
                item.setAmount(item.getAmount() - amount);
            }
        }
    }

    @Generated
    private BlockMenuUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

