/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.api.recipe_complete.source.base;

import com.balugaq.jeg.api.objects.SimpleRecipeChoice;
import com.balugaq.jeg.core.listeners.RecipeCompletableListener;
import com.balugaq.jeg.implementation.option.NoticeMissingMaterialGuideOption;
import com.balugaq.jeg.implementation.option.RecursiveRecipeFillingGuideOption;
import com.balugaq.jeg.utils.StackUtils;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Source {
    public static final int RECIPE_DEPTH_THRESHOLD = 8;

    @NotNull
    public JavaPlugin plugin();

    @Nullable
    default public List<RecipeChoice> getRecipe(@NotNull ItemStack itemStack) {
        Recipe[] recipes;
        SlimefunItem sf = SlimefunItem.getByItem((ItemStack)itemStack);
        if (sf != null) {
            ArrayList<RecipeChoice> raw = new ArrayList<RecipeChoice>(Arrays.stream(sf.getRecipe()).map(item -> item == null ? null : new SimpleRecipeChoice((ItemStack)item)).toList());
            for (int i = raw.size(); i < 9; ++i) {
                raw.add(null);
            }
            return raw;
        }
        for (Recipe recipe : recipes = Slimefun.getMinecraftRecipeService().getRecipesFor(itemStack)) {
            if (recipe instanceof ShapedRecipe) {
                int i;
                ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
                ArrayList<RecipeChoice> choices = new ArrayList<RecipeChoice>(9);
                String[] shape = shapedRecipe.getShape();
                for (i = 0; i < 3; ++i) {
                    String line = i < shape.length ? shape[i] : "   ";
                    for (int j = 0; j < 3; ++j) {
                        if (j >= line.length()) {
                            choices.add(null);
                            continue;
                        }
                        choices.add((RecipeChoice)shapedRecipe.getChoiceMap().get(Character.valueOf(line.charAt(j))));
                    }
                }
                for (i = choices.size(); i < 9; ++i) {
                    choices.add(null);
                }
                return choices;
            }
            if (!(recipe instanceof ShapelessRecipe)) continue;
            ShapelessRecipe shapelessRecipe = (ShapelessRecipe)recipe;
            ArrayList<RecipeChoice> raw = new ArrayList<RecipeChoice>(shapelessRecipe.getChoiceList());
            for (int i = raw.size(); i < 9; ++i) {
                raw.add(null);
            }
            return raw;
        }
        return null;
    }

    @ParametersAreNonnullByDefault
    @Nullable
    default public ItemStack getItemStackFromPlayerInventory(Player player, ItemStack itemStack) {
        return this.getItemStackFromPlayerInventory(player, itemStack, 1);
    }

    @ParametersAreNonnullByDefault
    @Nullable
    default public ItemStack getItemStackFromPlayerInventory(Player player, ItemStack itemStack, int amount) {
        int total = amount;
        for (int i = 0; i < player.getInventory().getSize(); ++i) {
            ItemStack itemStack1 = player.getInventory().getItem(i);
            if (itemStack1 == null || itemStack1.getType() == Material.AIR || !StackUtils.itemsMatch(itemStack1, itemStack)) continue;
            int existing = itemStack1.getAmount();
            if (existing <= amount) {
                amount -= existing;
                player.getInventory().clear(i);
            } else {
                itemStack1.setAmount(existing - amount);
                player.getInventory().setItem(i, itemStack1);
                amount = 0;
            }
            if (amount > 0) continue;
            ItemStack clone = itemStack.clone();
            clone.setAmount(total);
            return clone;
        }
        return null;
    }

    default public boolean depthInRange(@NotNull Player player, int depth) {
        return depth <= RecursiveRecipeFillingGuideOption.getDepth(player) && depth <= 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void sendMissingMaterial(@NotNull Player player, @NotNull ItemStack itemStack) {
        if (NoticeMissingMaterialGuideOption.isEnabled(player)) {
            ArrayList<ItemStack> v;
            UUID k = player.getUniqueId();
            if (!RecipeCompletableListener.missingMaterials.containsKey(k)) {
                RecipeCompletableListener.missingMaterials.put(k, new ArrayList());
            }
            ArrayList<ItemStack> arrayList = v = RecipeCompletableListener.missingMaterials.get(k);
            synchronized (arrayList) {
                v.add(itemStack);
            }
        }
    }
}

