/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.api.patches;

import com.balugaq.jeg.api.objects.enums.PatchScope;
import com.balugaq.jeg.api.patches.JEGGuideSettings;
import com.balugaq.jeg.utils.compatibility.Converter;
import com.balugaq.jeg.utils.formatter.Formats;
import io.github.thebusybiscuit.slimefun4.core.services.github.Contributor;
import io.github.thebusybiscuit.slimefun4.core.services.sounds.SoundEffect;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.common.ChatColors;
import io.github.thebusybiscuit.slimefun4.libraries.dough.common.CommonPatterns;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.NotNull;

public class JEGContributorsMenu {
    public static void open(@NotNull Player p, int page) {
        ChestMenu menu = new ChestMenu(Slimefun.getLocalization().getMessage(p, "guide.title.credits"));
        menu.setEmptySlotsClickable(false);
        menu.addMenuOpeningHandler(arg_0 -> ((SoundEffect)SoundEffect.GUIDE_CONTRIBUTORS_OPEN_SOUND).playFor(arg_0));
        ChestMenuUtils.drawBackground((ChestMenu)menu, (int[])Formats.contributors.getChars('B').stream().mapToInt(i -> i).toArray());
        for (int ss : Formats.contributors.getChars('b')) {
            menu.addItem(ss, PatchScope.Back.patch(p, Converter.getItem(ChestMenuUtils.getBackButton((Player)p, (String[])new String[]{"", "&7" + Slimefun.getLocalization().getMessage(p, "guide.back.settings")}))));
            menu.addMenuClickHandler(ss, (pl, slot, item, action) -> {
                JEGGuideSettings.openSettings(pl, p.getInventory().getItemInMainHand());
                return false;
            });
        }
        ArrayList contributors = new ArrayList(Slimefun.getGitHubService().getContributors().values());
        contributors.sort(Comparator.comparingInt(Contributor::getPosition));
        List<Integer> slots = Formats.contributors.getChars('p');
        int sizePerPage = slots.size();
        for (int i2 = page * sizePerPage; i2 < contributors.size() && i2 < (page + 1) * sizePerPage; ++i2) {
            Contributor contributor = (Contributor)contributors.get(i2);
            ItemStack skull = JEGContributorsMenu.getContributorHead(p, contributor);
            int ss = slots.get(i2 - page * sizePerPage);
            menu.addItem(ss, PatchScope.Contributor.patch(p, skull));
            menu.addMenuClickHandler(ss, (pl, slot, item, action) -> {
                if (contributor.getProfile() != null) {
                    pl.closeInventory();
                    ChatUtils.sendURL((CommandSender)pl, (String)contributor.getProfile());
                }
                return false;
            });
        }
        int pages = (contributors.size() - 1) / sizePerPage + 1;
        for (int ss : Formats.contributors.getChars('P')) {
            menu.addItem(ss, PatchScope.PreviousPage.patch(p, ChestMenuUtils.getPreviousButton((Player)p, (int)(page + 1), (int)pages)));
            menu.addMenuClickHandler(ss, (pl, slot, item, action) -> {
                if (page > 0) {
                    JEGContributorsMenu.open(pl, page - 1);
                }
                return false;
            });
        }
        for (int ss : Formats.contributors.getChars('N')) {
            menu.addItem(ss, PatchScope.NextPage.patch(p, ChestMenuUtils.getNextButton((Player)p, (int)(page + 1), (int)pages)));
            menu.addMenuClickHandler(ss, (pl, slot, item, action) -> {
                if (page + 1 < pages) {
                    JEGContributorsMenu.open(pl, page + 1);
                }
                return false;
            });
        }
        Formats.contributors.renderCustom(menu);
        menu.open(new Player[]{p});
    }

    @NotNull
    private static ItemStack getContributorHead(@NotNull Player p, @NotNull Contributor contributor) {
        ItemStack skull = SlimefunUtils.getCustomHead((String)contributor.getTexture());
        SkullMeta meta = (SkullMeta)skull.getItemMeta();
        meta.setDisplayName(contributor.getDisplayName());
        LinkedList<Object> lore = new LinkedList<Object>();
        lore.add("");
        for (Map.Entry entry : contributor.getContributions()) {
            Object info = (String)entry.getKey();
            if (!((String)info).startsWith("&")) {
                String[] segments = CommonPatterns.COMMA.split((CharSequence)info);
                info = Slimefun.getLocalization().getMessage(p, "guide.credits.roles." + segments[0]);
                if (segments.length == 2) {
                    info = (String)info + " &7(" + Slimefun.getLocalization().getMessage(p, "languages." + segments[1]) + ")";
                }
            }
            if ((Integer)entry.getValue() > 0) {
                String commits = Slimefun.getLocalization().getMessage(p, "guide.credits." + ((Integer)entry.getValue() > 1 ? "commits" : "commit"));
                info = (String)info + " &7(" + String.valueOf(entry.getValue()) + " " + commits + ")";
            }
            lore.add(ChatColors.color((String)info));
        }
        if (contributor.getProfile() != null) {
            lore.add("");
            lore.add(ChatColors.color((String)"&7\u21e8 &e") + Slimefun.getLocalization().getMessage(p, "guide.credits.profile-link"));
        }
        meta.setLore(lore);
        skull.setItemMeta((ItemMeta)meta);
        return skull;
    }
}

