/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.implementation.option;

import com.balugaq.jeg.api.patches.JEGGuideSettings;
import com.balugaq.jeg.implementation.JustEnoughGuide;
import com.balugaq.jeg.utils.Lang;
import com.balugaq.jeg.utils.compatibility.Converter;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.core.guide.options.SlimefunGuideOption;
import io.github.thebusybiscuit.slimefun4.libraries.dough.chat.ChatInput;
import io.github.thebusybiscuit.slimefun4.libraries.dough.common.ChatColors;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import java.util.ArrayList;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class RecursiveRecipeFillingGuideOption
implements SlimefunGuideOption<Integer> {
    @NotNull
    public static final RecursiveRecipeFillingGuideOption instance = new RecursiveRecipeFillingGuideOption();

    @NotNull
    public static RecursiveRecipeFillingGuideOption instance() {
        return instance;
    }

    @NotNull
    public static NamespacedKey key0() {
        return new NamespacedKey((Plugin)JustEnoughGuide.getInstance(), "recursive_recipe_filling");
    }

    public static int getDepth(@NotNull Player p) {
        return PersistentDataAPI.getInt((PersistentDataHolder)p, (NamespacedKey)RecursiveRecipeFillingGuideOption.key0(), (int)1);
    }

    @NotNull
    public SlimefunAddon getAddon() {
        return JustEnoughGuide.getInstance();
    }

    @NotNull
    public NamespacedKey getKey() {
        return RecursiveRecipeFillingGuideOption.key0();
    }

    @NotNull
    public Optional<ItemStack> getDisplayItem(@NotNull Player p, ItemStack guide) {
        int value = this.getSelectedOption(p, guide).orElse(1);
        if (value > 8) {
            value = 8;
            PersistentDataAPI.setInt((PersistentDataHolder)p, (NamespacedKey)RecursiveRecipeFillingGuideOption.key0(), (int)value);
        }
        String lk = "icon.options.recursive-recipe-filling.";
        ArrayList<String> lore = new ArrayList<String>(Lang.getStringList(lk + "lore-1"));
        String currentDepthText = Lang.getString(lk + "lore-2").replace("{depth}", String.valueOf(value)).replace("{max_depth}", String.valueOf(8));
        String c = Lang.getString(lk + "lore-3");
        lore.add(currentDepthText);
        lore.add(c);
        ItemStack item = Converter.getItem(Material.FURNACE, Lang.getString(lk + "name"), lore);
        return Optional.of(item);
    }

    public void onClick(@NotNull Player p, @NotNull ItemStack guide) {
        p.closeInventory();
        p.sendMessage(ChatColors.color((String)"&aPlease enter the recipe completion depth"));
        ChatInput.waitForPlayer((Plugin)JustEnoughGuide.getInstance(), (Player)p, s -> {
            try {
                int value = Integer.parseInt(s);
                if (value < 1 || value > 8) {
                    p.sendMessage("Please enter a positive integer between 1 ~ 8");
                    return;
                }
                this.setSelectedOption(p, guide, value);
                JEGGuideSettings.openSettings(p, guide);
            }
            catch (NumberFormatException ignored) {
                p.sendMessage("Please enter a positive integer between 1 ~ 8");
            }
        });
    }

    @NotNull
    public Optional<Integer> getSelectedOption(@NotNull Player p, ItemStack guide) {
        return Optional.of(RecursiveRecipeFillingGuideOption.getDepth(p));
    }

    public void setSelectedOption(@NotNull Player p, ItemStack guide, Integer value) {
        PersistentDataAPI.setInt((PersistentDataHolder)p, (NamespacedKey)this.getKey(), (int)value);
    }
}

