/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.implementation.option;

import com.balugaq.jeg.api.patches.JEGGuideSettings;
import com.balugaq.jeg.implementation.JustEnoughGuide;
import com.balugaq.jeg.utils.Lang;
import com.balugaq.jeg.utils.compatibility.Converter;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.core.guide.options.SlimefunGuideOption;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import java.util.ArrayList;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class BeginnersGuideOption
implements SlimefunGuideOption<Boolean> {
    @NotNull
    public static final BeginnersGuideOption instance = new BeginnersGuideOption();

    @NotNull
    public static BeginnersGuideOption instance() {
        return instance;
    }

    @NotNull
    public static NamespacedKey key0() {
        return new NamespacedKey((Plugin)JustEnoughGuide.getInstance(), "beginners_guide");
    }

    public static boolean isEnabled(@NotNull Player p) {
        return BeginnersGuideOption.getSelectedOption(p);
    }

    public static boolean getSelectedOption(@NotNull Player p) {
        return !PersistentDataAPI.hasByte((PersistentDataHolder)p, (NamespacedKey)BeginnersGuideOption.key0()) || PersistentDataAPI.getByte((PersistentDataHolder)p, (NamespacedKey)BeginnersGuideOption.key0()) == 1;
    }

    @NotNull
    public SlimefunAddon getAddon() {
        return JustEnoughGuide.getInstance();
    }

    @NotNull
    public NamespacedKey getKey() {
        return BeginnersGuideOption.key0();
    }

    @NotNull
    public Optional<ItemStack> getDisplayItem(@NotNull Player p, ItemStack guide) {
        boolean enabled = this.getSelectedOption(p, guide).orElse(true);
        ItemStack item = this.getIcon(enabled);
        return Optional.of(item);
    }

    @NotNull
    public ItemStack getIcon(boolean enabled) {
        String lk = "icon.options.beginners-guide.";
        ArrayList<String> lore = new ArrayList<String>(Lang.getStringList(lk + "lore-1"));
        lore.add(Lang.getString(lk + "last-lore-1") + Lang.getString(lk + "last-lore-" + (enabled ? "disable" : "enable")) + Lang.getString(lk + "last-lore-last"));
        return Converter.getItem(enabled ? Material.KNOWLEDGE_BOOK : Material.BOOK, Lang.getString(lk + "name-1") + Lang.getString(lk + "name-" + (enabled ? "enabled" : "disabled")), lore);
    }

    public void onClick(@NotNull Player p, @NotNull ItemStack guide) {
        this.setSelectedOption(p, guide, this.getSelectedOption(p, guide).orElse(true) == false);
        JEGGuideSettings.openSettings(p, guide);
    }

    @NotNull
    public Optional<Boolean> getSelectedOption(@NotNull Player p, ItemStack guide) {
        NamespacedKey key = this.getKey();
        boolean value = !PersistentDataAPI.hasByte((PersistentDataHolder)p, (NamespacedKey)key) || PersistentDataAPI.getByte((PersistentDataHolder)p, (NamespacedKey)key) == 1;
        return Optional.of(value);
    }

    public void setSelectedOption(@NotNull Player p, ItemStack guide, Boolean value) {
        PersistentDataAPI.setByte((PersistentDataHolder)p, (NamespacedKey)this.getKey(), (byte)(value != false ? (byte)1 : 0));
    }
}

