/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.core.managers;

import com.balugaq.jeg.api.managers.AbstractManager;
import com.balugaq.jeg.api.recipe_complete.source.base.RecipeCompleteProvider;
import com.balugaq.jeg.core.integrations.Integration;
import com.balugaq.jeg.core.integrations.alchimiavitae.AlchimiaVitaeIntegrationMain;
import com.balugaq.jeg.core.integrations.bedrocktechnology.BedrockTechnologyIntegrationMain;
import com.balugaq.jeg.core.integrations.claytech.ClayTechIntegrationMain;
import com.balugaq.jeg.core.integrations.cultivation.CultivationIntegrationMain;
import com.balugaq.jeg.core.integrations.danktech2.DankTech2IntegrationMain;
import com.balugaq.jeg.core.integrations.def.DefaultPlayerInventoryRecipeCompleteSlimefunSource;
import com.balugaq.jeg.core.integrations.def.DefaultPlayerInventoryRecipeCompleteVanillaSource;
import com.balugaq.jeg.core.integrations.elementmanipulation.ElementManipulationIntegrationMain;
import com.balugaq.jeg.core.integrations.emctech.EMCTechIntegrationMain;
import com.balugaq.jeg.core.integrations.fastmachines.FastMachinesIntegrationMain;
import com.balugaq.jeg.core.integrations.finaltechs.finalTECHChangedv3.FinalTECHChangedIntegrationMain;
import com.balugaq.jeg.core.integrations.finaltechs.finalTECHv2.FinalTECHIntegrationMain;
import com.balugaq.jeg.core.integrations.finaltechs.finaltechv1.FinalTechIntegrationMain;
import com.balugaq.jeg.core.integrations.fluffymachines.FluffyMachinesIntegrationMain;
import com.balugaq.jeg.core.integrations.galacitfun.GalactifunIntegrationMain;
import com.balugaq.jeg.core.integrations.gastronomicon.GastronomiconIntegrationMain;
import com.balugaq.jeg.core.integrations.infinitycompress.InfinityCompressIntegrationMain;
import com.balugaq.jeg.core.integrations.infinityexpansion.InfinityExpansionIntegrationMain;
import com.balugaq.jeg.core.integrations.infinityexpansion2.InfinityExpansion2IntegrationMain;
import com.balugaq.jeg.core.integrations.logitech.LogitechIntegrationMain;
import com.balugaq.jeg.core.integrations.magicexpansion.MagicExpansionIntegrationMain;
import com.balugaq.jeg.core.integrations.networks.NetworksIntegrationMain;
import com.balugaq.jeg.core.integrations.networksexpansion.NetworksExpansionIntegrationMain;
import com.balugaq.jeg.core.integrations.nexcavate.NexcavateIntegrationMain;
import com.balugaq.jeg.core.integrations.obsidianexpansion.ObsidianExpansionIntegrationMain;
import com.balugaq.jeg.core.integrations.rykenslimefuncustomizer.RykenSlimefunCustomizerIntegrationMain;
import com.balugaq.jeg.core.integrations.simpleutils.SimpleUtilsIntegrationMain;
import com.balugaq.jeg.core.integrations.slimeaeplugin.SlimeAEPluginIntegrationMain;
import com.balugaq.jeg.core.integrations.slimefuntranslation.SlimefunTranslationPluginIntegrationMain;
import com.balugaq.jeg.core.integrations.slimehud.SlimeHUDIntegrationMain;
import com.balugaq.jeg.core.integrations.slimetinker.SlimeTinkerIntegrationMain;
import com.balugaq.jeg.core.integrations.tsingshantechnology.TsingshanTechnologyIntegrationMain;
import com.balugaq.jeg.core.integrations.wildernether.WilderNetherIntegrationMain;
import com.balugaq.jeg.implementation.JustEnoughGuide;
import com.balugaq.jeg.utils.Debug;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class IntegrationManager
extends AbstractManager {
    @NotNull
    private final List<Integration> integrations = new ArrayList<Integration>();
    @NotNull
    private final JavaPlugin plugin;
    @Deprecated
    private final boolean hasRecipeCompletableWithGuide = false;
    private boolean enabledAlchimiaVitae;
    private boolean enabledBedrockTechnology;
    private boolean enabledClayTech;
    private boolean enabledClayTechFixed;
    private boolean enabledCultivation;
    private boolean enabledCMILib;
    private boolean enabledDankTech2;
    private boolean enabledElementManipulation;
    private boolean enabledEMCTech;
    private boolean enabledFastMachines;
    private boolean enabledFinalTech;
    private boolean enabledFinalTECH;
    private boolean enabledFinalTECH_Changed;
    private boolean enabledFluffyMachines;
    private boolean enabledGalactifun;
    private boolean enabledGastronomicon;
    private boolean enabledGuguSlimefunLib;
    private boolean enabledInfinityCompress;
    private boolean enabledInfinityExpansion;
    private boolean enabledInfinityExpansion2;
    private boolean enabledInfinityExpansion_Changed;
    private boolean enabledLogiTech;
    private boolean enabledMagicExpansion;
    private boolean enabledNetworks;
    private boolean enabledNetworksExpansion;
    private boolean enabledNexcavate;
    private boolean enabledObsidianExpansion;
    private boolean enabledOreWorkshop;
    private boolean enabledRykenSlimefunCustomizer;
    private boolean enabledSimpleUtils;
    private boolean enabledSlimeAEPlugin;
    private boolean enabledSlimeFrame;
    private boolean enabledSlimefunTranslation;
    private boolean enabledSlimeHUD;
    private boolean enabledSlimeHUDPlus;
    private boolean enabledSlimeTinker;
    private boolean enabledTsingshanTechnology;
    private boolean enabledTsingshanTechnology_Fixed;
    private boolean enabledWilderNether;

    public IntegrationManager(@NotNull JavaPlugin plugin) {
        this.plugin = plugin;
        JustEnoughGuide.runLater(() -> {
            PluginManager pm = Bukkit.getPluginManager();
            try {
                Class.forName("com.ytdd9527.networksexpansion.implementation.ExpansionItems");
                this.enabledNetworksExpansion = true;
            }
            catch (ClassNotFoundException e) {
                this.enabledNetworksExpansion = false;
            }
            this.enabledAlchimiaVitae = pm.isPluginEnabled("AlchimiaVitae");
            this.enabledBedrockTechnology = pm.isPluginEnabled("BedrockTechnology");
            this.enabledClayTechFixed = pm.isPluginEnabled("ClayTech-Fixed");
            this.enabledClayTech = this.enabledClayTechFixed || pm.isPluginEnabled("ClayTech");
            this.enabledCMILib = pm.isPluginEnabled("CMILib");
            this.enabledCultivation = pm.isPluginEnabled("Cultivation");
            this.enabledDankTech2 = pm.isPluginEnabled("DankTech2");
            this.enabledElementManipulation = pm.isPluginEnabled("ElementManipulation");
            this.enabledEMCTech = pm.isPluginEnabled("EMCTech");
            this.enabledFastMachines = pm.isPluginEnabled("FastMachines");
            this.enabledFinalTech = pm.isPluginEnabled("FinalTech") && IntegrationManager.classExists("io.taraxacum.finaltech.api.factory.ItemValueTable");
            this.enabledFinalTECH_Changed = pm.isPluginEnabled("FinalTECH-Changed");
            this.enabledFinalTECH = this.enabledFinalTECH_Changed || pm.isPluginEnabled("FinalTECH") && IntegrationManager.classExists("io.taraxacum.libs.slimefun.dto.ItemValueTable");
            this.enabledFluffyMachines = pm.isPluginEnabled("FluffyMachines");
            this.enabledGalactifun = pm.isPluginEnabled("Galactifun");
            this.enabledGastronomicon = pm.isPluginEnabled("Gastronomicon");
            this.enabledGuguSlimefunLib = pm.isPluginEnabled("GuguSlimefunLib");
            this.enabledInfinityCompress = pm.isPluginEnabled("InfinityCompress");
            this.enabledInfinityExpansion_Changed = pm.isPluginEnabled("InfinityExpansion-Changed");
            this.enabledInfinityExpansion = this.enabledInfinityExpansion_Changed || pm.isPluginEnabled("InfinityExpansion");
            this.enabledInfinityExpansion2 = pm.isPluginEnabled("InfinityExpansion2");
            this.enabledLogiTech = pm.isPluginEnabled("LogiTech");
            this.enabledMagicExpansion = pm.isPluginEnabled("magicexpansion");
            this.enabledNetworks = this.enabledNetworksExpansion || pm.isPluginEnabled("Networks");
            this.enabledNexcavate = pm.isPluginEnabled("Nexcavate");
            this.enabledObsidianExpansion = pm.isPluginEnabled("ObsidianExpansion");
            this.enabledOreWorkshop = pm.isPluginEnabled("OreWorkshop");
            this.enabledRykenSlimefunCustomizer = pm.isPluginEnabled("RykenSlimefunCustomizer");
            this.enabledSimpleUtils = pm.isPluginEnabled("SimpleUtils");
            this.enabledSlimeAEPlugin = pm.isPluginEnabled("SlimeAEPlugin");
            this.enabledSlimeHUDPlus = pm.isPluginEnabled("SlimeHUDPlus");
            this.enabledSlimeHUD = this.enabledSlimeHUD || pm.isPluginEnabled("SlimeHUD");
            this.enabledSlimeFrame = pm.isPluginEnabled("SlimeFrame");
            this.enabledSlimefunTranslation = pm.isPluginEnabled("SlimefunTranslation");
            this.enabledSlimeTinker = pm.isPluginEnabled("SlimeTinker");
            this.enabledTsingshanTechnology_Fixed = pm.isPluginEnabled("TsingshanTechnology-Fixed");
            this.enabledTsingshanTechnology = this.enabledTsingshanTechnology_Fixed || pm.isPluginEnabled("TsingshanTechnology");
            this.enabledWilderNether = pm.isPluginEnabled("WilderNether");
            this.addIntegration(this.enabledAlchimiaVitae, AlchimiaVitaeIntegrationMain::new);
            this.addIntegration(this.enabledBedrockTechnology, BedrockTechnologyIntegrationMain::new);
            this.addIntegration(this.enabledClayTech, ClayTechIntegrationMain::new);
            this.addIntegration(this.enabledCultivation, CultivationIntegrationMain::new);
            this.addIntegration(this.enabledDankTech2, DankTech2IntegrationMain::new);
            this.addIntegration(this.enabledElementManipulation, ElementManipulationIntegrationMain::new);
            this.addIntegration(this.enabledEMCTech, EMCTechIntegrationMain::new);
            this.addIntegration(this.enabledFastMachines, FastMachinesIntegrationMain::new);
            this.addIntegration(this.enabledFinalTech, FinalTechIntegrationMain::new);
            this.addIntegration(this.enabledFinalTECH, FinalTECHIntegrationMain::new);
            this.addIntegration(this.enabledFinalTECH_Changed, FinalTECHChangedIntegrationMain::new);
            this.addIntegration(this.enabledFluffyMachines, FluffyMachinesIntegrationMain::new);
            this.addIntegration(this.enabledGalactifun, GalactifunIntegrationMain::new);
            this.addIntegration(this.enabledGastronomicon, GastronomiconIntegrationMain::new);
            this.addIntegration(this.enabledInfinityCompress, InfinityCompressIntegrationMain::new);
            this.addIntegration(this.enabledInfinityExpansion, InfinityExpansionIntegrationMain::new);
            this.addIntegration(this.enabledInfinityExpansion2, InfinityExpansion2IntegrationMain::new);
            this.addIntegration(this.enabledLogiTech, LogitechIntegrationMain::new);
            this.addIntegration(this.enabledMagicExpansion, MagicExpansionIntegrationMain::new);
            this.addIntegration(this.enabledNexcavate, NexcavateIntegrationMain::new);
            this.addIntegration(this.enabledNetworks, NetworksIntegrationMain::new);
            this.addIntegration(this.enabledNetworksExpansion, NetworksExpansionIntegrationMain::new);
            this.addIntegration(this.enabledObsidianExpansion, ObsidianExpansionIntegrationMain::new);
            this.addIntegration(this.enabledRykenSlimefunCustomizer, RykenSlimefunCustomizerIntegrationMain::new);
            this.addIntegration(this.enabledSimpleUtils, SimpleUtilsIntegrationMain::new);
            this.addIntegration(this.enabledSlimeAEPlugin, SlimeAEPluginIntegrationMain::new);
            this.addIntegration(this.enabledSlimefunTranslation, SlimefunTranslationPluginIntegrationMain::new);
            this.addIntegration(this.enabledSlimeHUD, SlimeHUDIntegrationMain::new);
            this.addIntegration(this.enabledSlimeTinker, SlimeTinkerIntegrationMain::new);
            this.addIntegration(this.enabledTsingshanTechnology, TsingshanTechnologyIntegrationMain::new);
            this.addIntegration(this.enabledWilderNether, WilderNetherIntegrationMain::new);
            this.startupIntegrations();
            RecipeCompleteProvider.addSource(new DefaultPlayerInventoryRecipeCompleteSlimefunSource());
            RecipeCompleteProvider.addSource(new DefaultPlayerInventoryRecipeCompleteVanillaSource());
        }, 1L);
    }

    public static boolean classExists(@NotNull String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static void scheduleRun(@NotNull Runnable runnable) {
        JustEnoughGuide.runLater(runnable, 2L);
    }

    public static void scheduleRunAsync(@NotNull Runnable runnable) {
        JustEnoughGuide.runLaterAsync(runnable, 2L);
    }

    @Deprecated
    public boolean hasRecipeCompletableWithGuide() {
        return false;
    }

    private void startupIntegrations() {
        for (Integration integration : this.integrations) {
            this.plugin.getLogger().info("Hooking " + integration.getHookPlugin());
            try {
                integration.onEnable();
            }
            catch (Throwable e) {
                Debug.trace(e);
            }
        }
    }

    public void shutdownIntegrations() {
        for (Integration integration : this.integrations) {
            this.plugin.getLogger().info("Unhooking " + integration.getHookPlugin());
            try {
                integration.onDisable();
            }
            catch (Throwable e) {
                Debug.trace(e);
            }
        }
    }

    public boolean isEnabledFinalTech() {
        return this.enabledFinalTech;
    }

    public boolean isEnabledFinalTECH() {
        return this.enabledFinalTECH;
    }

    public boolean isEnabledFinalTECH_Changed() {
        return this.enabledFinalTECH_Changed;
    }

    public Run addIntegration(boolean enabled, @NotNull Supplier<Integration> supplier) {
        if (enabled) {
            Integration integration = supplier.get();
            this.integrations.add(integration);
            return Run.success();
        }
        return Run.failure();
    }

    @NotNull
    @Generated
    public List<Integration> getIntegrations() {
        return this.integrations;
    }

    @NotNull
    @Generated
    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    @Deprecated
    @Generated
    public boolean isHasRecipeCompletableWithGuide() {
        return this.hasRecipeCompletableWithGuide;
    }

    @Generated
    public boolean isEnabledAlchimiaVitae() {
        return this.enabledAlchimiaVitae;
    }

    @Generated
    public boolean isEnabledBedrockTechnology() {
        return this.enabledBedrockTechnology;
    }

    @Generated
    public boolean isEnabledClayTech() {
        return this.enabledClayTech;
    }

    @Generated
    public boolean isEnabledClayTechFixed() {
        return this.enabledClayTechFixed;
    }

    @Generated
    public boolean isEnabledCultivation() {
        return this.enabledCultivation;
    }

    @Generated
    public boolean isEnabledCMILib() {
        return this.enabledCMILib;
    }

    @Generated
    public boolean isEnabledDankTech2() {
        return this.enabledDankTech2;
    }

    @Generated
    public boolean isEnabledElementManipulation() {
        return this.enabledElementManipulation;
    }

    @Generated
    public boolean isEnabledEMCTech() {
        return this.enabledEMCTech;
    }

    @Generated
    public boolean isEnabledFastMachines() {
        return this.enabledFastMachines;
    }

    @Generated
    public boolean isEnabledFluffyMachines() {
        return this.enabledFluffyMachines;
    }

    @Generated
    public boolean isEnabledGalactifun() {
        return this.enabledGalactifun;
    }

    @Generated
    public boolean isEnabledGastronomicon() {
        return this.enabledGastronomicon;
    }

    @Generated
    public boolean isEnabledGuguSlimefunLib() {
        return this.enabledGuguSlimefunLib;
    }

    @Generated
    public boolean isEnabledInfinityCompress() {
        return this.enabledInfinityCompress;
    }

    @Generated
    public boolean isEnabledInfinityExpansion() {
        return this.enabledInfinityExpansion;
    }

    @Generated
    public boolean isEnabledInfinityExpansion2() {
        return this.enabledInfinityExpansion2;
    }

    @Generated
    public boolean isEnabledInfinityExpansion_Changed() {
        return this.enabledInfinityExpansion_Changed;
    }

    @Generated
    public boolean isEnabledLogiTech() {
        return this.enabledLogiTech;
    }

    @Generated
    public boolean isEnabledMagicExpansion() {
        return this.enabledMagicExpansion;
    }

    @Generated
    public boolean isEnabledNetworks() {
        return this.enabledNetworks;
    }

    @Generated
    public boolean isEnabledNetworksExpansion() {
        return this.enabledNetworksExpansion;
    }

    @Generated
    public boolean isEnabledNexcavate() {
        return this.enabledNexcavate;
    }

    @Generated
    public boolean isEnabledObsidianExpansion() {
        return this.enabledObsidianExpansion;
    }

    @Generated
    public boolean isEnabledOreWorkshop() {
        return this.enabledOreWorkshop;
    }

    @Generated
    public boolean isEnabledRykenSlimefunCustomizer() {
        return this.enabledRykenSlimefunCustomizer;
    }

    @Generated
    public boolean isEnabledSimpleUtils() {
        return this.enabledSimpleUtils;
    }

    @Generated
    public boolean isEnabledSlimeAEPlugin() {
        return this.enabledSlimeAEPlugin;
    }

    @Generated
    public boolean isEnabledSlimeFrame() {
        return this.enabledSlimeFrame;
    }

    @Generated
    public boolean isEnabledSlimefunTranslation() {
        return this.enabledSlimefunTranslation;
    }

    @Generated
    public boolean isEnabledSlimeHUD() {
        return this.enabledSlimeHUD;
    }

    @Generated
    public boolean isEnabledSlimeHUDPlus() {
        return this.enabledSlimeHUDPlus;
    }

    @Generated
    public boolean isEnabledSlimeTinker() {
        return this.enabledSlimeTinker;
    }

    @Generated
    public boolean isEnabledTsingshanTechnology() {
        return this.enabledTsingshanTechnology;
    }

    @Generated
    public boolean isEnabledTsingshanTechnology_Fixed() {
        return this.enabledTsingshanTechnology_Fixed;
    }

    @Generated
    public boolean isEnabledWilderNether() {
        return this.enabledWilderNether;
    }

    public static class Run
    implements Cloneable {
        public static final Run SUCCESS = new Run(true);
        public static final Run FAILURE = new Run(false);
        private final boolean success;

        public static Run success() {
            return SUCCESS.clone();
        }

        public static Run failure() {
            return FAILURE.clone();
        }

        public Run or(@NotNull Supplier<Run> callable) {
            if (!this.success) {
                return callable.get();
            }
            return this;
        }

        public Run clone() {
            try {
                return (Run)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError();
            }
        }

        @Generated
        public boolean isSuccess() {
            return this.success;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Run)) {
                return false;
            }
            Run other = (Run)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.isSuccess() == other.isSuccess();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Run;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isSuccess() ? 79 : 97);
            return result;
        }

        @Generated
        public String toString() {
            return "IntegrationManager.Run(success=" + this.isSuccess() + ")";
        }

        @Generated
        public Run(boolean success) {
            this.success = success;
        }
    }
}

