/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.core.integrations.slimehud;

import com.balugaq.jeg.api.objects.enums.HUDLocation;
import com.balugaq.jeg.core.integrations.slimehud.HUDMachineInfoLocationGuideOption;
import com.balugaq.jeg.implementation.JustEnoughGuide;
import com.balugaq.jeg.utils.MinecraftVersion;
import com.balugaq.jeg.utils.ReflectionUtil;
import com.balugaq.jeg.utils.platform.PlatformUtil;
import io.github.schntgaispock.slimehud.SlimeHUD;
import io.github.schntgaispock.slimehud.util.Util;
import io.github.schntgaispock.slimehud.waila.HudRequest;
import io.github.schntgaispock.slimehud.waila.PlayerWAILA;
import io.github.schntgaispock.slimehud.waila.WAILAManager;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.logging.Level;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.bossbar.BossBarViewer;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.boss.BarColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JEGPlayerWAILA
extends PlayerWAILA {
    public static final boolean IS_1_20_1 = JustEnoughGuide.getMinecraftVersion().isAtLeast(MinecraftVersion.MINECRAFT_1_20_1);
    public static final long TICK_RATE = SlimeHUD.getInstance().getConfig().getLong("waila.tick-rate");
    @NotNull
    public final Supplier<BossBar> kyoriBossBarSupplier;
    public boolean visible;
    @Nullable
    public BossBar kyoriBossBar = null;

    public JEGPlayerWAILA(@NotNull Player player, @Nullable PlayerWAILA waila) {
        super(player);
        this.getWAILABar().removePlayer(player);
        this.kyoriBossBarSupplier = () -> {
            if (this.kyoriBossBar == null) {
                if (PlatformUtil.isPaper() && IS_1_20_1) {
                    String bossbarColor = SlimeHUD.getInstance().getConfig().getString("waila.bossbar-color").trim().toLowerCase();
                    this.kyoriBossBar = BossBar.bossBar((Component)Component.text((String)""), (float)1.0f, (BossBar.Color)JEGPlayerWAILA.toBossBarColor(bossbarColor), (BossBar.Overlay)BossBar.Overlay.PROGRESS, new HashSet());
                    return this.kyoriBossBar;
                }
                return null;
            }
            return this.kyoriBossBar;
        };
        if (waila != null) {
            this.setVisible(this.getWAILABar().isVisible());
            this.setColor(this.getWAILABar().getColor());
            this.setTitle((Component)Component.text((String)this.getWAILABar().getTitle()));
            this.setPaused(waila.isPaused());
        }
    }

    @NotNull
    public static JEGPlayerWAILA wrap(@NotNull Player player, @Nullable PlayerWAILA waila) {
        boolean f;
        boolean bl = f = waila != null && !waila.getClass().getSimpleName().equals("JEGPlayerWAILA");
        if (waila instanceof JEGPlayerWAILA) {
            JEGPlayerWAILA jpw = (JEGPlayerWAILA)waila;
            return jpw;
        }
        JEGPlayerWAILA v2 = new JEGPlayerWAILA(player, waila);
        if (f) {
            waila.setVisible(false);
            waila.setPaused(true);
        }
        return v2;
    }

    @NotNull
    public static BarColor toBarColor(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull BossBar.Color color) {
        return BarColor.valueOf((String)color.name());
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull BossBar.Color toBossBarColor(@NotNull String color) {
        return switch (color.trim().toLowerCase()) {
            case "red", "yellow", "green", "blue", "purple", "pink", "white" -> BossBar.Color.valueOf((String)color.toUpperCase());
            case "default", "inherit" -> BossBar.Color.WHITE;
            default -> {
                SlimeHUD.log((Level)Level.WARNING, (String[])new String[]{"[SlimeHUD] Invalid bossbar color: " + color, "[SlimeHUD] Setting color to white..."});
                yield BossBar.Color.WHITE;
            }
        };
    }

    public static PlayerWAILA unwrap(@Nullable PlayerWAILA waila) {
        if (waila == null) {
            return null;
        }
        if (waila.getClass().getSimpleName().equals("JEGPlayerWAILA")) {
            Supplier kyoriBossBarSupplier = ReflectionUtil.getValue(waila, "kyoriBossBarSupplier", Supplier.class);
            for (BossBarViewer bbv : ((BossBar)kyoriBossBarSupplier.get()).viewers()) {
                if (!(bbv instanceof Audience)) continue;
                Audience adn = (Audience)bbv;
                ((BossBar)kyoriBossBarSupplier.get()).removeViewer(adn);
            }
            PlayerWAILA v2 = (PlayerWAILA)ReflectionUtil.invokeMethod(waila, "toOrigin", new Object[0]);
            waila.cancel();
            return v2;
        }
        return waila;
    }

    @NotNull
    public static Map<UUID, PlayerWAILA> getWailaMap() {
        return WAILAManager.getInstance().getWailas();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void wrap(@NotNull Player player) {
        Map<UUID, PlayerWAILA> map = JEGPlayerWAILA.getWailaMap();
        synchronized (map) {
            JEGPlayerWAILA.getWailaMap().compute(player.getUniqueId(), (k, waila) -> JEGPlayerWAILA.runTaskAsync((Plugin)JustEnoughGuide.getInstance(), JEGPlayerWAILA.wrap(player, waila)));
        }
    }

    public static <T extends BukkitRunnable> T runTaskAsync(@NotNull Plugin plugin, @Nullable T runnable) {
        if (runnable == null) {
            return null;
        }
        runnable.runTaskTimerAsynchronously(plugin, 0L, TICK_RATE);
        return runnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onDisable() {
        Map<UUID, PlayerWAILA> map = JEGPlayerWAILA.getWailaMap();
        synchronized (map) {
            for (Map.Entry<UUID, PlayerWAILA> entry : JEGPlayerWAILA.getWailaMap().entrySet()) {
                JEGPlayerWAILA.getWailaMap().compute(entry.getKey(), (k, waila) -> JEGPlayerWAILA.runTaskAsync((Plugin)SlimeHUD.getInstance(), JEGPlayerWAILA.unwrap(waila)));
            }
        }
    }

    @Nullable
    public String WAILALocation0() {
        return ReflectionUtil.getValue((Object)this, "WAILALocation", String.class);
    }

    public boolean keepTextColors0() {
        return ReflectionUtil.getValue((Object)this, "keepTextColors", Boolean.TYPE);
    }

    public boolean useAutoBossBarColor0() {
        return ReflectionUtil.getValue((Object)this, "useAutoBossBarColor", Boolean.TYPE);
    }

    public void clearFacing0() {
        ReflectionUtil.setValue((Object)this, "facingBlock", "");
        ReflectionUtil.setValue((Object)this, "facingBlockInfo", null);
        ReflectionUtil.setValue((Object)this, "facing", "");
    }

    public void updateFacing0() {
        Block targetBlock = this.getPlayer().getTargetBlockExact(5);
        if (targetBlock == null) {
            this.clearFacing0();
            return;
        }
        SlimefunItem item = BlockStorage.check((Location)targetBlock.getLocation());
        if (item == null) {
            this.clearFacing0();
            return;
        }
        Location target = targetBlock.getLocation();
        HudRequest request = new HudRequest(item, target, this.getPlayer());
        ReflectionUtil.setValue((Object)this, "facingBlock", SlimeHUD.getTranslationManager().getItemName(this.getPlayer(), item));
        ReflectionUtil.setValue((Object)this, "facingBlockInfo", SlimeHUD.getHudController().processRequest(request));
        ReflectionUtil.setValue((Object)this, "facing", ChatColor.translateAlternateColorCodes((char)'&', (String)(this.getFacingBlock() + (String)(this.getFacingBlockInfo().isEmpty() ? "" : " &7| " + this.getFacingBlockInfo()))));
    }

    public void run() {
        this.updateFacing0();
        if (this.isPaused()) {
            return;
        }
        String facing = this.getFacing();
        ReflectionUtil.setValue((Object)this, "previousFacing", facing);
        HUDLocation hudLocation = HUDMachineInfoLocationGuideOption.getSelectedOption(this.getPlayer());
        if (hudLocation == HUDLocation.DEFAULT) {
            switch (this.WAILALocation0()) {
                case "bossbar": {
                    this.bossbar(facing);
                    break;
                }
                case "hotbar": 
                case "actionbar": {
                    this.setVisible(false);
                    this.actionbar(facing);
                }
            }
        } else if (hudLocation == HUDLocation.BOSSBAR) {
            this.bossbar(facing);
        } else if (hudLocation == HUDLocation.ACTION_BAR) {
            this.actionbar(facing);
        }
    }

    public void bossbar(@NotNull String facing) {
        if (facing.isEmpty()) {
            this.setVisible(false);
        } else {
            this.setVisible(true);
            this.setTitle((Component)(this.keepTextColors0() ? LegacyComponentSerializer.legacySection().deserialize(facing) : Component.text((String)ChatColor.stripColor((String)facing))));
            if (this.useAutoBossBarColor0()) {
                this.setColor(Util.pickBarColorFromName((String)facing));
            }
        }
    }

    public void actionbar(@NotNull String facing) {
        if (PlatformUtil.isPaper()) {
            this.getPlayer().sendActionBar((Component)LegacyComponentSerializer.legacySection().deserialize(facing));
        } else {
            this.getPlayer().spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new net.md_5.bungee.api.chat.TextComponent(facing));
        }
    }

    @NotNull
    public PlayerWAILA setVisible(boolean visible) {
        this.visible = visible;
        if (this.kyoriBossBarSupplier.get() != null) {
            this.getWAILABar().setVisible(false);
            if (visible) {
                for (BossBar bar : this.getPlayer().activeBossBars()) {
                    if (bar != this.kyoriBossBarSupplier.get()) continue;
                    return this;
                }
                this.kyoriBossBarSupplier.get().addViewer((Audience)this.getPlayer());
            } else {
                this.kyoriBossBarSupplier.get().removeViewer((Audience)this.getPlayer());
            }
        } else {
            this.getWAILABar().setVisible(visible);
        }
        return this;
    }

    public void setTitle(Component title) {
        if (title instanceof TextComponent) {
            TextComponent tc = (TextComponent)title;
            this.getWAILABar().setTitle(tc.content());
        }
        if (this.kyoriBossBarSupplier.get() != null) {
            this.kyoriBossBarSupplier.get().name(title);
        }
    }

    public void setColor(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull BossBar.Color color) {
        this.getWAILABar().setColor(JEGPlayerWAILA.toBarColor(color));
        if (this.kyoriBossBarSupplier.get() != null) {
            this.kyoriBossBarSupplier.get().color(BossBar.Color.valueOf((String)color.name()));
        }
    }

    public void setColor(@NotNull BarColor color) {
        this.getWAILABar().setColor(color);
        if (this.kyoriBossBarSupplier.get() != null) {
            this.kyoriBossBarSupplier.get().color(BossBar.Color.valueOf((String)color.name()));
        }
    }

    @NotNull
    public PlayerWAILA toOrigin() {
        PlayerWAILA waila = new PlayerWAILA(this.getPlayer());
        waila.setPaused(this.isPaused());
        org.bukkit.boss.BossBar bukkit = this.getWAILABar();
        BossBar kyori = this.kyoriBossBarSupplier.get();
        if (kyori != null) {
            bukkit.setTitle(((TextComponent)kyori.name()).content());
            bukkit.setColor(JEGPlayerWAILA.toBarColor(kyori.color()));
        }
        bukkit.setVisible(this.visible);
        return waila;
    }

    public void cancel() {
        this.setVisible(false);
    }
}

