/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.core.integrations.slimeaeplugin;

import com.balugaq.jeg.api.recipe_complete.RecipeCompletableRegistry;
import com.balugaq.jeg.api.recipe_complete.source.base.RecipeCompleteProvider;
import com.balugaq.jeg.core.integrations.Integration;
import com.balugaq.jeg.core.integrations.slimeaeplugin.SlimeAEPluginRecipeCompleteSlimefunSource;
import com.balugaq.jeg.core.integrations.slimeaeplugin.SlimeAEPluginRecipeCompleteVanillaSource;
import com.balugaq.jeg.implementation.JustEnoughGuide;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import java.util.ArrayList;
import java.util.List;
import me.ddggdd135.slimeae.SlimeAEPlugin;
import me.ddggdd135.slimeae.api.interfaces.IStorage;
import me.ddggdd135.slimeae.core.NetworkInfo;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SlimeAEPluginIntegrationMain
implements Integration {
    public static final int[] CRAFTING_TERMINAL_INPUT_SLOTS = new int[]{6, 7, 8, 15, 16, 17, 24, 25, 26};
    public static final int[] PATTERN_TERMINAL_INPUT_SLOTS = new int[]{6, 7, 8, 15, 16, 17, 24, 25, 26};
    public static final int[] PATTERN_WORKBENCH_INPUT_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26};
    public static final List<SlimefunItem> handledSlimefunItems = new ArrayList<SlimefunItem>();
    public static final BlockFace[] VALID_FACES = new BlockFace[]{BlockFace.UP, BlockFace.DOWN, BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST};
    public static JavaPlugin plugin = null;

    @NotNull
    public static JavaPlugin getPlugin() {
        if (plugin == null) {
            plugin = (JavaPlugin)Bukkit.getPluginManager().getPlugin("SlimeAEPlugin");
        }
        return plugin;
    }

    public static void rrc(@NotNull String id, int @NotNull [] slots, boolean unordered) {
        SlimefunItem slimefunItem = SlimefunItem.getById((String)id);
        if (slimefunItem != null) {
            SlimeAEPluginIntegrationMain.rrc(slimefunItem, slots, unordered);
        }
    }

    public static void rrc(@NotNull SlimefunItem slimefunItem, int @NotNull [] slots, boolean unordered) {
        handledSlimefunItems.add(slimefunItem);
        RecipeCompletableRegistry.registerRecipeCompletable(slimefunItem, slots, unordered);
    }

    @Nullable
    public static IStorage findNearbyIStorage(@NotNull Location location) {
        IStorage networkStorage = null;
        for (BlockFace blockFace : VALID_FACES) {
            Location clone = location.clone();
            switch (blockFace) {
                case NORTH: {
                    clone.set((double)clone.getBlockX(), (double)clone.getBlockY(), (double)(clone.getBlockZ() - 1));
                    break;
                }
                case EAST: {
                    clone.set((double)(clone.getBlockX() + 1), (double)clone.getBlockY(), (double)clone.getBlockZ());
                    break;
                }
                case SOUTH: {
                    clone.set((double)clone.getBlockX(), (double)clone.getBlockY(), (double)(clone.getBlockZ() + 1));
                    break;
                }
                case WEST: {
                    clone.set((double)(clone.getBlockX() - 1), (double)clone.getBlockY(), (double)clone.getBlockZ());
                    break;
                }
                case UP: {
                    clone.set((double)clone.getBlockX(), (double)(clone.getBlockY() + 1), (double)clone.getBlockZ());
                    break;
                }
                case DOWN: {
                    clone.set((double)clone.getBlockX(), (double)(clone.getBlockY() - 1), (double)clone.getBlockZ());
                }
            }
            NetworkInfo def2 = SlimeAEPlugin.getNetworkData().getNetworkInfo(clone);
            if (def2 == null) continue;
            networkStorage = def2.getStorage();
            break;
        }
        return networkStorage;
    }

    @Override
    @NotNull
    public String getHookPlugin() {
        return "SlimeAEPlugin";
    }

    @Override
    public void onEnable() {
        if (JustEnoughGuide.getIntegrationManager().isEnabledGuguSlimefunLib()) {
            RecipeCompleteProvider.addSource(new SlimeAEPluginRecipeCompleteSlimefunSource());
            RecipeCompleteProvider.addSource(new SlimeAEPluginRecipeCompleteVanillaSource());
        }
        SlimeAEPluginIntegrationMain.rrc("ME_CRAFTING_TERMINAL", CRAFTING_TERMINAL_INPUT_SLOTS, false);
        SlimeAEPluginIntegrationMain.rrc("ME_PATTERN_TERMINAL", PATTERN_TERMINAL_INPUT_SLOTS, false);
        SlimeAEPluginIntegrationMain.rrc("PATTERN_WORKBENCH", PATTERN_WORKBENCH_INPUT_SLOTS, true);
    }

    @Override
    public void onDisable() {
        for (SlimefunItem slimefunItem : handledSlimefunItems) {
            RecipeCompletableRegistry.unregisterRecipeCompletable(slimefunItem);
        }
    }
}

