/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.jeg.api.cost;

import com.balugaq.jeg.api.cost.ValueTable;
import com.balugaq.jeg.api.objects.annotations.CallTimeSensitive;
import com.balugaq.jeg.api.objects.collection.data.MachineData;
import com.balugaq.jeg.api.objects.collection.data.dynatech.AbstractElectricMachineData;
import com.balugaq.jeg.api.objects.collection.data.infinityexpansion.GrowingMachineData;
import com.balugaq.jeg.api.objects.collection.data.infinityexpansion.MaterialGeneratorData;
import com.balugaq.jeg.api.objects.collection.data.infinityexpansion.MobDataCardData;
import com.balugaq.jeg.api.objects.collection.data.infinityexpansion.QuarryData;
import com.balugaq.jeg.api.objects.collection.data.infinityexpansion.ResourceSynthesizerData;
import com.balugaq.jeg.api.objects.collection.data.infinityexpansion.SingularityConstructorData;
import com.balugaq.jeg.api.objects.collection.data.infinityexpansion.StoneworksFactoryData;
import com.balugaq.jeg.api.objects.collection.data.infinityexpansion.StrainerBaseData;
import com.balugaq.jeg.api.objects.collection.data.infinityexpansion.VoidHarvesterData;
import com.balugaq.jeg.api.objects.collection.data.infinitylib.MachineBlockData;
import com.balugaq.jeg.api.objects.collection.data.infinitylib.MachineBlockRecipe;
import com.balugaq.jeg.api.objects.collection.data.logitech.AbstractMachineData;
import com.balugaq.jeg.api.objects.collection.data.rsc.RSCCustomLinkedMachineRecipe;
import com.balugaq.jeg.api.objects.collection.data.rsc.RSCCustomLinkedRecipeMachineData;
import com.balugaq.jeg.api.objects.collection.data.rsc.RSCCustomMachineRecipe;
import com.balugaq.jeg.api.objects.collection.data.rsc.RSCCustomMaterialGeneratorData;
import com.balugaq.jeg.api.objects.collection.data.rsc.RSCCustomRecipeMachineData;
import com.balugaq.jeg.api.objects.collection.data.rsc.RSCCustomTemplateMachineData;
import com.balugaq.jeg.api.objects.collection.data.rsc.RSCLinkedOutput;
import com.balugaq.jeg.api.objects.collection.data.rsc.RSCMachineTemplate;
import com.balugaq.jeg.api.objects.collection.data.sc.SCCustomMaterialGeneratorData;
import com.balugaq.jeg.api.objects.collection.data.sf.AContainerData;
import com.balugaq.jeg.api.objects.collection.data.sf.AbstractEnergyProviderData;
import com.balugaq.jeg.core.managers.IntegrationManager;
import com.balugaq.jeg.implementation.JustEnoughGuide;
import com.balugaq.jeg.utils.Debug;
import com.balugaq.jeg.utils.StackUtils;
import com.balugaq.jeg.utils.compatibility.Converter;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineFuel;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineRecipe;
import net.guizhanss.guizhanlib.minecraft.helper.inventory.ItemStackHelper;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class CERCalculator {
    public static final Map<SlimefunItem, MachineData> machines = new HashMap<SlimefunItem, MachineData>();
    public static final Pattern trimp = Pattern.compile("[&\u00a7]k[&\u00a7]");

    public static void load() {
        IntegrationManager.scheduleRun(CERCalculator::loadInternal);
        ValueTable.load();
    }

    @CallTimeSensitive(value="After Integrations loaded")
    @ApiStatus.Internal
    private static void loadInternal() {
        for (SlimefunItem slimefunItem : Slimefun.getRegistry().getEnabledSlimefunItems()) {
            String className = slimefunItem.getClass().getName();
            MachineData wrapper = MachineData.get(slimefunItem);
            if (wrapper == null) continue;
            machines.put(slimefunItem, wrapper);
        }
        if (JustEnoughGuide.getConfigManager().isDebug()) {
            Debug.debug("[CER]");
            Debug.debug("[CER] size: " + machines.size());
            for (Map.Entry entry : machines.entrySet()) {
                Debug.debug("[CER]" + String.valueOf(entry.getKey()));
            }
        }
    }

    public static boolean cerable(SlimefunItem sf) {
        return machines.containsKey(sf);
    }

    public static double getCER(@NotNull SlimefunItem sf, @NotNull String searchTerm) {
        if (sf == null || sf.isDisabled() || searchTerm == null || !machines.containsKey(sf)) {
            return -1.0;
        }
        return CERCalculator.calc0(sf, item -> CERCalculator.similar(searchTerm, item));
    }

    /*
     * WARNING - void declaration
     */
    @ParametersAreNonnullByDefault
    private static double calc0(SlimefunItem sf, Predicate<ItemStack> predicate) {
        String className = sf.getClass().getName();
        double cost = ValueTable.getValue(sf);
        MachineData data = machines.get(sf);
        if (data instanceof AContainerData) {
            AContainerData acd = (AContainerData)data;
            for (MachineRecipe machineRecipe : acd.getRecipes()) {
                for (ItemStack item : machineRecipe.getOutput()) {
                    if (!predicate.test(item)) continue;
                    return CERCalculator.calc(cost + ValueTable.getValue(machineRecipe.getInput()), item.getAmount(), machineRecipe.getTicks(), (double)acd.getEnergyConsumption() / (double)acd.getSpeed() * (double)machineRecipe.getTicks());
                }
            }
        }
        if (data instanceof RSCCustomRecipeMachineData) {
            RSCCustomRecipeMachineData rcrmd = (RSCCustomRecipeMachineData)data;
            for (RSCCustomMachineRecipe rSCCustomMachineRecipe : rcrmd.getRecipes()) {
                if (rSCCustomMachineRecipe.isForDisplay()) continue;
                int j = 0;
                for (ItemStack item : rSCCustomMachineRecipe.getOutput()) {
                    if (predicate.test(item)) {
                        double v2;
                        boolean forDisplay = rSCCustomMachineRecipe.isForDisplay();
                        if (forDisplay) continue;
                        boolean chooseOneIfHas = rSCCustomMachineRecipe.isChooseOneIfHas();
                        List<Integer> chances = rSCCustomMachineRecipe.getChances();
                        IntList noConsume = rSCCustomMachineRecipe.getNoConsume();
                        double v = 0.0;
                        ItemStack[] ii = rSCCustomMachineRecipe.getInput();
                        for (int i = 0; i < ii.length; ++i) {
                            ItemStack iii = ii[i];
                            if (noConsume != null && i < noConsume.size()) {
                                v += ValueTable.getTemplateValue(iii);
                                continue;
                            }
                            v += ValueTable.getValue(iii);
                        }
                        double d = v2 = j >= chances.size() ? (double)item.getAmount() : (double)(item.getAmount() * chances.get(j));
                        if (chooseOneIfHas) {
                            v2 /= (double)rSCCustomMachineRecipe.getOutput().length;
                        }
                        return CERCalculator.calc(cost + v, v2, rSCCustomMachineRecipe.getTicks(), (double)rcrmd.getEnergyConsumption() / (double)rcrmd.getSpeed() * (double)rSCCustomMachineRecipe.getTicks());
                    }
                    ++j;
                }
            }
        }
        if (data instanceof RSCCustomLinkedRecipeMachineData) {
            RSCCustomLinkedRecipeMachineData rclrmd = (RSCCustomLinkedRecipeMachineData)data;
            for (RSCCustomLinkedMachineRecipe recipe : rclrmd.getRecipes()) {
                if (recipe.isForDisplay()) continue;
                double iv = 0.0;
                Map<Integer, ItemStack> li = recipe.getLinkedInput();
                for (Map.Entry<Integer, ItemStack> entry : li.entrySet()) {
                    if (recipe.getNoConsumes().contains(entry.getKey())) {
                        iv += ValueTable.getTemplateValue(entry.getValue());
                        continue;
                    }
                    iv += ValueTable.getValue(entry.getValue());
                }
                RSCLinkedOutput lo = recipe.getLinkedOutput();
                for (Map.Entry<Integer, ItemStack> entry : lo.linkedOutput().entrySet()) {
                    double amt;
                    int slot = entry.getKey();
                    ItemStack output = entry.getValue();
                    if (!predicate.test(output)) continue;
                    Integer chance = lo.linkedChances().get(slot);
                    double d = amt = chance == null ? (double)output.getAmount() : (double)(output.getAmount() * chance) / 100.0;
                    if (recipe.isChooseOneIfHas()) {
                        amt /= (double)lo.linkedOutput().size();
                    }
                    return CERCalculator.calc(cost + iv, amt, (double)recipe.getTicks() / (double)rclrmd.getSpeed(), (double)(recipe.getTicks() * rclrmd.getEnergyConsumption()) / (double)rclrmd.getSpeed());
                }
                ItemStack[] itemStackArray = lo.freeOutput();
                for (int slot = 0; slot < itemStackArray.length; ++slot) {
                    double amt;
                    ItemStack output = itemStackArray[slot];
                    if (!predicate.test(output)) continue;
                    Integer chance = lo.freeChances()[slot];
                    double d = amt = chance == null ? (double)output.getAmount() : (double)(output.getAmount() * chance) / 100.0;
                    if (recipe.isChooseOneIfHas()) {
                        amt /= (double)lo.freeChances().length;
                    }
                    return CERCalculator.calc(cost + iv, amt, (double)recipe.getTicks() / (double)rclrmd.getSpeed(), (double)(recipe.getTicks() * rclrmd.getEnergyConsumption()) / (double)rclrmd.getSpeed());
                }
            }
        } else if (data instanceof RSCCustomTemplateMachineData) {
            RSCCustomTemplateMachineData rctmd = (RSCCustomTemplateMachineData)data;
            boolean fasterIfMoreTemplates = rctmd.isFasterIfMoreTemplates();
            boolean moreOutputIfMoreTemplates = rctmd.isMoreOutputIfMoreTemplates();
            int consumption = rctmd.getConsumption();
            List<RSCMachineTemplate> templates = rctmd.getTemplates();
            for (RSCMachineTemplate template : templates) {
                ItemStack itemStack = template.template();
                int mavg = itemStack.getMaxStackSize() * 2;
                List<RSCCustomMachineRecipe> recipes = template.recipes();
                for (RSCCustomMachineRecipe recipe : recipes) {
                    if (recipe.isForDisplay()) continue;
                    int j = 0;
                    for (ItemStack item : recipe.getOutput()) {
                        if (predicate.test(item)) {
                            double v2;
                            boolean forDisplay = recipe.isForDisplay();
                            if (forDisplay) continue;
                            boolean chooseOneIfHas = recipe.isChooseOneIfHas();
                            List<Integer> chances = recipe.getChances();
                            IntList noConsume = recipe.getNoConsume();
                            double v = 0.0;
                            ItemStack[] ii = recipe.getInput();
                            for (int i = 0; i < ii.length; ++i) {
                                ItemStack iii = ii[i];
                                if (noConsume != null && i < noConsume.size()) {
                                    v += ValueTable.getTemplateValue(iii);
                                    continue;
                                }
                                v += ValueTable.getValue(iii);
                            }
                            double d = v2 = j >= chances.size() ? (double)item.getAmount() : (double)(item.getAmount() * chances.get(j));
                            if (chooseOneIfHas) {
                                v2 /= (double)recipe.getOutput().length;
                            }
                            if (moreOutputIfMoreTemplates) {
                                v2 *= (double)mavg;
                            }
                            double btv = ValueTable.getTemplateValue(itemStack);
                            return CERCalculator.calc(cost + (fasterIfMoreTemplates ? btv / (double)mavg : btv) + v, v2, fasterIfMoreTemplates ? (double)recipe.getTicks() / (double)mavg : (double)recipe.getTicks(), (double)consumption * (double)recipe.getTicks());
                        }
                        ++j;
                    }
                }
            }
        } else if (data instanceof AbstractEnergyProviderData) {
            AbstractEnergyProviderData abstractEnergyProviderData = (AbstractEnergyProviderData)data;
            for (MachineFuel ft : abstractEnergyProviderData.getFuelTypes()) {
                if (!predicate.test(ft.getOutput())) continue;
                return CERCalculator.calc(cost + ValueTable.getValue(ft.getInput()), ft.getOutput().getAmount(), ft.getTicks(), -abstractEnergyProviderData.getEnergyProduction() * ft.getTicks());
            }
        } else if (data instanceof RSCCustomMaterialGeneratorData) {
            RSCCustomMaterialGeneratorData rcmgd = (RSCCustomMaterialGeneratorData)data;
            int tickRate = rcmgd.getTickRate();
            int per = rcmgd.getPer();
            List<ItemStack> generation = rcmgd.getGeneration();
            List<Integer> chances = rcmgd.getChances();
            boolean chooseOne = rcmgd.isChooseOne();
            for (int a = 0; a < generation.size(); ++a) {
                ItemStack itemStack = generation.get(a);
                if (!predicate.test(itemStack)) continue;
                if (chances != null && !chances.isEmpty()) {
                    double bv = itemStack.getAmount() * chances.get(a);
                    return CERCalculator.calc(cost, chooseOne ? bv / (double)chances.size() : bv, tickRate, per * tickRate);
                }
                return CERCalculator.calc(cost, itemStack.getAmount(), tickRate, per * tickRate);
            }
        } else if (data instanceof SCCustomMaterialGeneratorData) {
            SCCustomMaterialGeneratorData scmgd = (SCCustomMaterialGeneratorData)data;
            int tickRate = scmgd.getTickRate();
            ItemStack output = scmgd.getOutput();
            if (predicate.test(output)) {
                return CERCalculator.calc(cost, output.getAmount(), tickRate, 0.0);
            }
        } else if (data instanceof StrainerBaseData) {
            ItemStack[] OUTPUTS;
            StrainerBaseData sbd = (StrainerBaseData)data;
            ItemStack POTATO = sbd.getPOTATO();
            if (predicate.test(POTATO)) {
                return CERCalculator.calc(cost, POTATO.getAmount(), 40.0, 0.0);
            }
            for (ItemStack o : OUTPUTS = sbd.getOUTPUTS()) {
                if (!predicate.test(o)) continue;
                return CERCalculator.calc(cost, o.getAmount(), 40.0, 0.0);
            }
        } else if (data instanceof QuarryData) {
            QuarryData qd = (QuarryData)data;
            int INTERVAL = qd.getINTERVAL();
            Material[] outputs = qd.getOutputs();
            int speed = qd.getSpeed();
            int energyPerTick = qd.getEnergyPerTick();
            if (outputs != null) {
                void var27_122;
                Material[] chooseOne = outputs;
                int o = chooseOne.length;
                boolean bl = false;
                while (var27_122 < o) {
                    Material m = chooseOne[var27_122];
                    if (predicate.test(new ItemStack(m))) {
                        return CERCalculator.calc(cost, speed, INTERVAL, energyPerTick * INTERVAL);
                    }
                    ++var27_122;
                }
            }
        } else if (data instanceof SingularityConstructorData) {
            SingularityConstructorData scd = (SingularityConstructorData)data;
            List<SingularityConstructorData.Recipe> RECIPE_LIST = scd.getRECIPE_LIST();
            int energyPerTick = scd.getEnergyPerTick();
            for (SingularityConstructorData.Recipe recipe : RECIPE_LIST) {
                SlimefunItemStack output = recipe.getOutput();
                ItemStack input = recipe.getInput();
                int n = recipe.getAmount();
                if (!predicate.test(Converter.getItem(output))) continue;
                int speed = scd.getSpeed();
                return CERCalculator.calc(cost + ValueTable.getValue(input, n), 1.0, speed, (double)(energyPerTick * n) / (double)speed);
            }
        } else if (data instanceof MaterialGeneratorData) {
            MaterialGeneratorData mgd = (MaterialGeneratorData)data;
            Material material = mgd.getMaterial();
            int speed = mgd.getSpeed();
            int energyPerTick = mgd.getEnergyPerTick();
            if (predicate.test(new ItemStack(material))) {
                return CERCalculator.calc(cost, speed, 1.0, (double)energyPerTick / (double)speed);
            }
        } else if (data instanceof ResourceSynthesizerData) {
            ResourceSynthesizerData rsd = (ResourceSynthesizerData)data;
            int energyPerTick = rsd.getEnergyPerTick();
            for (ResourceSynthesizerData.Recipe recipe : rsd.getRecipes()) {
                ItemStack i1 = Converter.getItem(recipe.getInput1());
                ItemStack i2 = Converter.getItem(recipe.getInput2());
                ItemStack output = Converter.getItem(recipe.getOutput());
                if (!predicate.test(output)) continue;
                return CERCalculator.calc(cost + ValueTable.getValue(i1) + ValueTable.getValue(i2), output.getAmount(), 1.0, energyPerTick);
            }
        } else if (data instanceof GrowingMachineData) {
            GrowingMachineData gmd = (GrowingMachineData)data;
            EnumMap<Material, ItemStack[]> recipes = gmd.getRecipes();
            int ticksPerOutput = gmd.getTicksPerOutput();
            int energyPerTick = gmd.getEnergyPerTick();
            for (Map.Entry<Material, ItemStack[]> entry : recipes.entrySet()) {
                ItemStack[] itemStackArray;
                Material material = entry.getKey();
                for (ItemStack o : itemStackArray = entry.getValue()) {
                    if (!predicate.test(o)) continue;
                    return CERCalculator.calc(cost + ValueTable.getValue(new ItemStack(material)), o.getAmount(), ticksPerOutput, energyPerTick * ticksPerOutput);
                }
            }
        } else if (data instanceof MachineBlockData) {
            MachineBlockData mbd = (MachineBlockData)data;
            List<MachineBlockRecipe> recipes = mbd.getRecipes();
            int ticksPerOutput = mbd.getTicksPerOutput();
            int energyPerTick = mbd.getEnergyPerTick();
            if (recipes != null) {
                for (MachineBlockRecipe recipe : recipes) {
                    ItemStack output = recipe.getOutput();
                    if (!predicate.test(output)) continue;
                    return CERCalculator.calc(cost + ValueTable.getValue(recipe.getInputs()), output.getAmount(), ticksPerOutput, energyPerTick * ticksPerOutput);
                }
            }
        } else if (data instanceof AbstractElectricMachineData) {
            AbstractElectricMachineData aemd = (AbstractElectricMachineData)data;
            List<MachineRecipe> recipes = aemd.getRecipes();
            int energyConsumedPerTick = aemd.getEnergyConsumedPerTick();
            int processingSpeed = aemd.getProcessingSpeed();
            for (MachineRecipe recipe : recipes) {
                for (ItemStack o : recipe.getOutput()) {
                    if (!predicate.test(o)) continue;
                    return CERCalculator.calc(cost + ValueTable.getValue(recipe.getInput()), o.getAmount(), (double)recipe.getTicks() / (double)processingSpeed, (double)(energyConsumedPerTick * recipe.getTicks()) / (double)processingSpeed);
                }
            }
        } else if (data instanceof StoneworksFactoryData) {
            StoneworksFactoryData sfd = (StoneworksFactoryData)data;
            int energyPerTick = sfd.getEnergyPerTick();
            for (Material material : sfd.getMaterials()) {
                if (!predicate.test(new ItemStack(material))) continue;
                return CERCalculator.calc(cost + ValueTable.getValue(material), 1.0, 1.0, energyPerTick);
            }
        } else if (data instanceof VoidHarvesterData) {
            VoidHarvesterData vhd = (VoidHarvesterData)data;
            int TIME = vhd.getTIME();
            int speed = vhd.getSpeed();
            int energyPerTick = vhd.getEnergyPerTick();
            ItemStack output = vhd.getOutput();
            if (predicate.test(output)) {
                return CERCalculator.calc(cost, output.getAmount(), (double)TIME / (double)speed, energyPerTick);
            }
        }
        if (data instanceof MobDataCardData) {
            MobDataCardData mdcd = (MobDataCardData)data;
            SlimefunItem chamber = mdcd.getChamber();
            int n = mdcd.getChamberEnergy();
            int interval = mdcd.getChamberInterval();
            for (Map.Entry<ItemStack, Float> entry : mdcd.getItemStackDoubleMap().entrySet()) {
                if (!predicate.test(entry.getKey())) continue;
                return CERCalculator.calc(cost + ValueTable.getValue(chamber), entry.getValue().floatValue() * (float)entry.getKey().getAmount(), interval, n * interval);
            }
        }
        if (data instanceof AbstractMachineData) {
            AbstractMachineData amd = (AbstractMachineData)data;
            for (MachineRecipe machineRecipe : amd.getMachineRecipes()) {
                for (ItemStack output : machineRecipe.getOutput()) {
                    if (!predicate.test(output)) continue;
                    return CERCalculator.calc(cost + ValueTable.getValue(machineRecipe.getInput()), output.getAmount(), machineRecipe.getTicks(), machineRecipe.getTicks() * amd.getEnergyConsumption());
                }
            }
        }
        return -2.0;
    }

    public static ItemStack[] translateIntoItemStackArray(String[] strings, int[] amounts) {
        int v = Math.min(amounts.length, strings.length);
        ItemStack[] array = new ItemStack[v];
        for (int i = 0; i < v; ++i) {
            Material material;
            String s = strings[i];
            if (s == null) {
                array[i] = null;
                continue;
            }
            int amount = amounts[i];
            SlimefunItem sf = SlimefunItem.getById((String)s);
            array[i] = sf != null ? StackUtils.getAsQuantity(sf.getItem(), amount) : ((material = Material.getMaterial((String)s)) == null ? null : new ItemStack(material, amount));
        }
        return array;
    }

    public static double calc(double cost, double outputAmount, double processTicks, double energyCost) {
        if (Double.isInfinite(cost) || Double.isNaN(cost) || Double.isInfinite(outputAmount) || Double.isNaN(outputAmount) || Double.isInfinite(processTicks) || Double.isNaN(processTicks) || Double.isInfinite(energyCost) || Double.isNaN(energyCost)) {
            return -3.0;
        }
        if (cost < 0.0 || outputAmount <= 0.0 || processTicks < 0.0) {
            return -4.0;
        }
        if (energyCost >= 0.0) {
            return Math.log10(128.0 * outputAmount / (1.0 + processTicks * ((1.0 + cost) / 10.0) * ((1.0 + energyCost) / 128000.0)));
        }
        return Math.log10(128.0 * outputAmount / (1.0 + processTicks * ((1.0 + cost) / 10.0) - energyCost / 12800.0));
    }

    public static String supertrim(String i1) {
        String result = ChatColor.stripColor((String)i1);
        result = trimp.matcher(result).replaceAll("");
        return result.replace(" ", "");
    }

    public static boolean similar(String i1, ItemStack i2) {
        if (i2 == null || i2.getType() == Material.AIR) {
            return false;
        }
        String name = ItemStackHelper.getDisplayName((ItemStack)i2);
        return CERCalculator.supertrim(i1).equalsIgnoreCase(CERCalculator.supertrim(name));
    }

    public static <T extends SlimefunItem> boolean isInstanceSimple(@NotNull T item, String classSimpleName) {
        for (Class<?> clazz = item.getClass(); clazz != SlimefunItem.class; clazz = clazz.getSuperclass()) {
            if (!clazz.getSimpleName().equals(classSimpleName)) continue;
            return true;
        }
        return false;
    }

    public static <T extends SlimefunItem> boolean isInstance(@NotNull T item, String className) {
        for (Class<?> clazz = item.getClass(); clazz != SlimefunItem.class; clazz = clazz.getSuperclass()) {
            if (!clazz.getName().equals(className)) continue;
            return true;
        }
        return false;
    }
}

